macro(SDL_DetectCMakePlatform)
  set(SDL_CMAKE_PLATFORM )
  # Get the platform
  if(WIN32)
    set(SDL_CMAKE_PLATFORM WINDOWS)
  elseif(UNIX AND NOT APPLE)
    if(CMAKE_SYSTEM_NAME MATCHES ".*Linux")
      set(SDL_CMAKE_PLATFORM LINUX)
    elseif(CMAKE_SYSTEM_NAME MATCHES "kFreeBSD.*")
      set(SDL_CMAKE_PLATFORM FREEBSD)
    elseif(CMAKE_SYSTEM_NAME MATCHES "kNetBSD.*|NetBSD.*")
      set(SDL_CMAKE_PLATFORM NETBSD)
    elseif(CMAKE_SYSTEM_NAME MATCHES "kOpenBSD.*|OpenBSD.*")
      set(SDL_CMAKE_PLATFORM OPENBSD)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*GNU.*")
      set(SDL_CMAKE_PLATFORM GNU)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*BSDI.*")
      set(SDL_CMAKE_PLATFORM BSDI)
    elseif(CMAKE_SYSTEM_NAME MATCHES "DragonFly.*|FreeBSD")
      set(SDL_CMAKE_PLATFORM FREEBSD)
    elseif(CMAKE_SYSTEM_NAME MATCHES "SYSV5.*")
      set(SDL_CMAKE_PLATFORM SYSV5)
    elseif(CMAKE_SYSTEM_NAME MATCHES "Solaris.*|SunOS.*")
      set(SDL_CMAKE_PLATFORM SOLARIS)
    elseif(CMAKE_SYSTEM_NAME MATCHES "HP-UX.*")
      set(SDL_CMAKE_PLATFORM HPUX)
    elseif(CMAKE_SYSTEM_NAME MATCHES "AIX.*")
      set(SDL_CMAKE_PLATFORM AIX)
    elseif(CMAKE_SYSTEM_NAME MATCHES "Minix.*")
      set(SDL_CMAKE_PLATFORM MINIX)
    endif()
  elseif(APPLE)
    if(CMAKE_SYSTEM_NAME MATCHES ".*Darwin.*")
      set(SDL_CMAKE_PLATFORM DARWIN)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*MacOS.*")
      set(SDL_CMAKE_PLATFORM MACOSX)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*tvOS.*")
      set(SDL_CMAKE_PLATFORM TVOS)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*iOS.*")
      # !!! FIXME: remove the version check when we start requiring >= 3.14.0
      if(CMAKE_VERSION VERSION_LESS 3.14)
        set(SDL_CMAKE_PLATFORM IOS)
      endif()
    endif()
  elseif(CMAKE_SYSTEM_NAME MATCHES "BeOS.*")
    message_error("BeOS support has been removed as of SDL 2.0.2.")
  elseif(CMAKE_SYSTEM_NAME MATCHES "Haiku.*")
    set(SDL_CMAKE_PLATFORM HAIKU)
  elseif(NINTENDO_3DS)
    set(SDL_CMAKE_PLATFORM N3DS)
  endif()
  if(SDL_CMAKE_PLATFORM)
    set(${SDL_CMAKE_PLATFORM} TRUE)
  endif()
endmacro()
