/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html SBML converter to convert a model's units to SI units.
 * 
 * @htmlinclude libsbml-facility-only-warning.html
 *
 * This SBML converter converts the units in a model to base SI units,
 * namely metre, kilogram, second, Ampere, Kelvin, mole and candela.
 *
 * Unit conversion will only be performed on models that are fully unit
 * consistent; that is, all objects have associated units, and there are no
 * literal numbers with no units specified.  In the case of an SBML
 * Level&nbsp;3 model involving math expressions, this means that the @c
 * timeUnits attribute on the Model object must be set, and if there are
 * any reactions in the model, the @c extentUnits attribute on the Model
 * object must also be set.
 *
 * This converter has the additional Boolean property 'removeUnusedUnits'
 * that can be used to tell the converter whether to remove any
 * UnitDefinition objects that are not referred to, after conversion is
 * complete.  You can set this value by adding the property using
 * @verbatim
prop.addOption('removeUnusedUnits', false);
@endverbatim
 * The converter's default behavior is to remove the unused
 * UnitDefinition objects in the model.
 *
 * @see SBMLFunctionDefinitionConverter
 * @see SBMLLevelVersionConverter
 * @see SBMLRuleConverter
 * @see SBMLStripPackageConverter
 * @see SBMLUnitsConverter
 */

public class SBMLUnitsConverter : SBMLConverter {
	private HandleRef swigCPtr;
	
	internal SBMLUnitsConverter(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.SBMLUnitsConverter_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.SBMLUnitsConverterUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBMLUnitsConverter obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBMLUnitsConverter obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBMLUnitsConverter() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBMLUnitsConverter(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  public static void init() {
    libsbmlPINVOKE.SBMLUnitsConverter_init();
  }

  public SBMLUnitsConverter() : this(libsbmlPINVOKE.new_SBMLUnitsConverter__SWIG_0(), true) {
  }

  public SBMLUnitsConverter(SBMLUnitsConverter obj) : this(libsbmlPINVOKE.new_SBMLUnitsConverter__SWIG_1(SBMLUnitsConverter.getCPtr(obj)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this SBMLConverter object.
   * 
   * @return a (deep) copy of this SBMLConverter object.
   */ public
 SBMLConverter clone() {
    IntPtr cPtr = libsbmlPINVOKE.SBMLUnitsConverter_clone(swigCPtr);
    SBMLUnitsConverter ret = (cPtr == IntPtr.Zero) ? null : new SBMLUnitsConverter(cPtr, true);
    return ret;
  }

  
/**
   * Predicate returning @c true if this converter's properties matches a
   * given set of configuration properties.
   * 
   * @param props the configuration properties to match.
   * 
   * @return @c true if this converter's properties match, @c false
   * otherwise.
   */ public
 bool matchesProperties(ConversionProperties props) {
    bool ret = libsbmlPINVOKE.SBMLUnitsConverter_matchesProperties(swigCPtr, ConversionProperties.getCPtr(props));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Perform the conversion.
   *
   * This method causes the converter to do the actual conversion work,
   * that is, to convert the SBMLDocument object set by
   * SBMLConverter::setDocument(@if java SBMLDocument doc@endif) and
   * with the configuration options set by
   * SBMLConverter::setProperties(@if java ConversionProperties props@endif).
   * 
   * @return  integer value indicating the success/failure of the operation.
   * @if clike The value is drawn from the enumeration
   * #OperationReturnValues_t. @endif The set of possible values that may
   * be returned depends on the converter subclass; please consult
   * the documentation for the relevant class to find out what the
   * possibilities are.
   */ public
 int convert() {
    int ret = libsbmlPINVOKE.SBMLUnitsConverter_convert(swigCPtr);
    return ret;
  }

  
/**
   * Returns the default properties of this converter.
   *
   * A given converter exposes one or more properties that can be adjusted
   * in order to influence the behavior of the converter.  This method
   * returns the @em default property settings for this converter.  It is
   * meant to be called in order to discover all the settings for the
   * converter object.  The run-time properties of the converter object can
   * be adjusted by using the method
   * SBMLConverter::setProperties(ConversionProperties props).
   * 
   * @return the default properties for the converter.
   *
   * @see setProperties(@if java ConversionProperties props@endif)
   * @see matchesProperties(@if java ConversionProperties props@endif)
   */ public
 ConversionProperties getDefaultProperties() {
    ConversionProperties ret = new ConversionProperties(libsbmlPINVOKE.SBMLUnitsConverter_getDefaultProperties(swigCPtr), true);
    return ret;
  }

}

}
