/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  SBML converter to convert a model's units to SI units.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  It is a class used in
the implementation of extra functionality provided by libSBML.
</p>

 <p>
 * This SBML converter converts the units in a model to base SI units,
 * namely metre, kilogram, second, Ampere, Kelvin, mole and candela.
 <p>
 * {@link Unit} conversion will only be performed on models that are fully unit
 * consistent; that is, all objects have associated units, and there are no
 * literal numbers with no units specified.  In the case of an SBML
 * Level&nbsp;3 model involving math expressions, this means that the 
 * <code>timeUnits</code> attribute on the {@link Model} object must be set, and if there are
 * any reactions in the model, the <code>extentUnits</code> attribute on the {@link Model}
 * object must also be set.
 <p>
 * This converter has the additional Boolean property 'removeUnusedUnits'
 * that can be used to tell the converter whether to remove any
 * {@link UnitDefinition} objects that are not referred to, after conversion is
 * complete.  You can set this value by adding the property using
 * <div class='fragment'><pre class='fragment'>
prop.addOption('removeUnusedUnits', false);
</pre></div>
 * The converter's default behavior is to remove the unused
 * {@link UnitDefinition} objects in the model.
 <p>
 * @see SBMLFunctionDefinitionConverter
 * @see SBMLLevelVersionConverter
 * @see SBMLRuleConverter
 * @see SBMLStripPackageConverter
 * @see SBMLUnitsConverter
 */

public class SBMLUnitsConverter extends SBMLConverter {
   private long swigCPtr;

   protected SBMLUnitsConverter(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLUnitsConverter_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLUnitsConverter obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLUnitsConverter obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLUnitsConverter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public static void init() {
    libsbmlJNI.SBMLUnitsConverter_init();
  }

  
/**
   * Creates a new {@link SBMLUnitsConverter} object.
   */ public
 SBMLUnitsConverter() {
    this(libsbmlJNI.new_SBMLUnitsConverter__SWIG_0(), true);
  }

  
/**
   * Copy constructor; creates a copy of an {@link SBMLUnitsConverter}
   * object.
   <p>
   * @param obj the {@link SBMLUnitsConverter} object to copy.
   */ public
 SBMLUnitsConverter(SBMLUnitsConverter obj) {
    this(libsbmlJNI.new_SBMLUnitsConverter__SWIG_1(SBMLUnitsConverter.getCPtr(obj), obj), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link SBMLUnitsConverter}
   * object.
   <p>
   * @return a (deep) copy of this converter.
   */ public
 SBMLConverter cloneObject() {
    long cPtr = libsbmlJNI.SBMLUnitsConverter_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLUnitsConverter(cPtr, true);
  }

  
/**
   * Returns <code>true</code> if this converter object's properties match the given
   * properties. 
   <p>
   * A typical use of this method involves creating a {@link ConversionProperties}
   * object, setting the options desired, and then calling this method on
   * an {@link SBMLUnitsConverter} object to find out if the object's
   * property values match the given ones.  This method is also used by
   * {@link SBMLConverterRegistry#getConverterFor(ConversionProperties props)}
   * to search across all registered converters for one matching particular
   * properties.
   <p>
   * @param props the properties to match.
   <p>
   * @return <code>true</code> if this converter's properties match, <code>false</code>
   * otherwise.
   */ public
 boolean matchesProperties(ConversionProperties props) {
    return libsbmlJNI.SBMLUnitsConverter_matchesProperties(swigCPtr, this, ConversionProperties.getCPtr(props), props);
  }

  
/**
   * Convers the units in the model to base SI units; namely metre,
   * kilogram, second, Ampere, Kelvin, mole and candela.
   <p>
   * @return  integer value indicating the success/failure of the operation.
   *  The possible values are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE }
   * <li> {@link  libsbmlConstants#LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int convert() {
    return libsbmlJNI.SBMLUnitsConverter_convert(swigCPtr, this);
  }

  
/**
   * Returns the default properties of this converter.
   <p>
   * A given converter exposes one or more properties that can be adjusted
   * in order to influence the behavior of the converter.  This method
   * returns the <em>default</em> property settings for this converter.  It is
   * meant to be called in order to discover all the settings for the
   * converter object.
   <p>
   * @return the {@link ConversionProperties} object describing the default properties
   * for this converter.
   */ public
 ConversionProperties getDefaultProperties() {
    return new ConversionProperties(libsbmlJNI.SBMLUnitsConverter_getDefaultProperties(swigCPtr, this), true);
  }

}
