########################################################################
#
# librets
#
ARCH  =

ifeq ($(TARGET_CPU),x86)
ARCH  = -${TARGET_CPU}
endif
ifeq ($(TARGET_CPU),x64)
ARCH  = -${TARGET_CPU}
endif
BUILD = build${ARCH}

LIBRETS_ANTLR_GRAMMAR_DIR = $(top_srcdir)/project/librets/src
LIBRETS_ANTLR_PARSER = $(LIBRETS_ANTLR_GRAMMAR_DIR)/rets-sql.g
LIBRETS_ANTLR_TREE_PARSER = $(LIBRETS_ANTLR_GRAMMAR_DIR)/dmql-tree.g
LIBRETS_ANTLR_GET_OBJECT_TREE_PARSER = \
	$(LIBRETS_ANTLR_GRAMMAR_DIR)/get-object-tree.g
LIBRETS_ANTLR_LOOKUP_PARSER = $(LIBRETS_ANTLR_GRAMMAR_DIR)/lookup-tree.g
LIBRETS_ANTLR_LOOKUP_COLUMNS_PARSER = \
	$(LIBRETS_ANTLR_GRAMMAR_DIR)/lookup-columns-tree.g

LIBRETS_ANTLR_GRAMMARS = $(LIBRETS_ANTLR_PARSER) $(LIBRETS_ANTLR_TREE_PARSER) \
	$(LIBRETS_ANTLR_GET_OBJECT_TREE_PARSER) \
	$(LIBRETS_ANTLR_LOOKUP_PARSER) $(LIBRETS_ANTLR_LOOKUP_COLUMNS_PARSER)
LIBRETS_ANTLR_SRC_DIR = ${BUILD}/librets/antlr
LIBRETS_ANTLR_OBJ_DIR = $(LIBRETS_ANTLR_SRC_DIR)
LIBRETS_ANTLR_TRIGGER = $(LIBRETS_ANTLR_SRC_DIR)/.antlr-up-to-date
LIBRETS_ANTLR_HDR_FILES = $(patsubst %, $(LIBRETS_ANTLR_SRC_DIR)/%, \
			RetsSqlLexer.hpp RetsSqlParser.hpp \
			DmqlTreeParser.hpp GetObjectTreeParser.hpp \
			LookupTreeParser.hpp LookupColumnsTreeParser.hpp)
LIBRETS_ANTLR_SRC_FILES = $(patsubst %, $(LIBRETS_ANTLR_SRC_DIR)/%, \
			RetsSqlLexer.cpp RetsSqlParser.cpp \
			DmqlTreeParser.cpp GetObjectTreeParser.cpp \
			LookupTreeParser.cpp LookupColumnsTreeParser.cpp)
LIBRETS_ANTLR_OBJECTS := $(LIBRETS_ANTLR_SRC_FILES:.cpp=.o)
LIBRETS_ANTLR_DEPENDS := $(LIBRETS_ANTLR_SRC_FILES:.cpp=.d)
LIBRETS_ANTLR_CFLAGS = $(CXXFLAGS) $(CPPFLAGS) $(BOOST_CFLAGS) $(ARCH_CFLAGS)

ANTLR_FLAGS = -o $(LIBRETS_ANTLR_SRC_DIR)
ANTLR_TREE_FLAGS = $(ANTLR_FLAGS) -glib $(LIBRETS_ANTLR_PARSER)

$(LIBRETS_ANTLR_TRIGGER): $(LIBRETS_ANTLR_GRAMMARS)
	$(ANTLR) $(ANTLR_FLAGS) $(LIBRETS_ANTLR_PARSER)
	$(ANTLR) $(ANTLR_TREE_FLAGS) $(LIBRETS_ANTLR_TREE_PARSER)
	$(ANTLR) $(ANTLR_TREE_FLAGS) $(LIBRETS_ANTLR_GET_OBJECT_TREE_PARSER)
	$(ANTLR) $(ANTLR_TREE_FLAGS) $(LIBRETS_ANTLR_LOOKUP_PARSER)
	$(ANTLR) $(ANTLR_TREE_FLAGS) $(LIBRETS_ANTLR_LOOKUP_COLUMNS_PARSER)
	touch $(LIBRETS_ANTLR_TRIGGER)

$(LIBRETS_ANTLR_HDR_FILES): $(LIBRETS_ANTLR_TRIGGER)
$(LIBRETS_ANTLR_SRC_FILES): $(LIBRETS_ANTLR_TRIGGER)
$(LIBRETS_ANTLR_OBJECTS): $(LIBRETS_ANTLR_TRIGGER)
$(LIBRETS_ANTLR_DEPENDS): $(LIBRETS_ANTLR_TRIGGER)

$(LIBRETS_ANTLR_OBJECTS): \
	$(LIBRETS_ANTLR_OBJ_DIR)/%.o:  $(LIBRETS_ANTLR_SRC_DIR)/%.cpp
	$(CXX) $(LIBRETS_ANTLR_CFLAGS) -I$(LIBRETS_INC_DIR) -c $< -o $@

$(LIBRETS_ANTLR_DEPENDS): \
	$(LIBRETS_ANTLR_OBJ_DIR)/%.d: $(LIBRETS_ANTLR_SRC_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_ANTLR_CFLAGS) -I$(LIBRETS_INC_DIR) $< \
	| $(FIXDEP) $(LIBRETS_ANTLR_SRC_DIR) $(LIBRETS_ANTLR_OBJ_DIR) > $@

#####

LIBRETS_CFLAGS = $(CXXFLAGS) $(CPPFLAGS) $(CURL_CFLAGS) $(EXPAT_CFLAGS) \
	${LIBRETS_THREAD_FLAGS} $(BOOST_CFLAGS) -I$(LIBRETS_INC_DIR) 

ifeq ($(USE_SQL_COMPILER),1)
LIBRETS_SQL_DIR = $(top_srcdir)/project/librets/sql
LIBRETS_SQL_OBJ_DIR = ${BUILD}/librets/sql
LIBRETS_SQL_FILES := $(wildcard ${LIBRETS_SQL_DIR}/*.cpp)
LIBRETS_SQL_OBJECTS := $(patsubst $(LIBRETS_SQL_DIR)/%.cpp, \
	$(LIBRETS_SQL_OBJ_DIR)/%.o, $(LIBRETS_SQL_FILES))

LIBRETS_SQL_DEPENDS := $(patsubst $(LIBRETS_SQL_DIR)/%.cpp, \
	$(LIBRETS_SQL_OBJ_DIR)/%.d, $(LIBRETS_SQL_FILES))
LIBRETS_SQL_DEPENDS += $(LIBRETS_ANTLR_DEPENDS)
LIBRETS_SQL_CFLAGS = $(LIBRETS_CFLAGS) -I$(LIBRETS_ANTLR_SRC_DIR) $(ARCH_FLAGS)

$(filter $(LIBRETS_SQL_OBJ_DIR)/%.o, $(LIBRETS_SQL_OBJECTS)): \
	$(LIBRETS_SQL_OBJ_DIR)/%.o: $(LIBRETS_SQL_DIR)/%.cpp
	$(CXX) $(LIBRETS_SQL_CFLAGS) -c $< -o $@

$(filter $(LIBRETS_SQL_OBJ_DIR)/%.d, $(LIBRETS_SQL_DEPENDS)): \
	$(LIBRETS_SQL_OBJ_DIR)/%.d: $(LIBRETS_SQL_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_SQL_CFLAGS) $< \
	| $(FIXDEP) $(LIBRETS_SQL_DIR) $(LIBRETS_SQL_OBJ_DIR) > $@

endif

#####

LIBRETS_A       = librets.a
LIBRETS_SRC_DIR = $(top_srcdir)/project/librets/src
LIBRETS_INC_DIR = $(top_srcdir)/project/librets/include
LIBRETS_H       = librets.h
LIBRETS_OBJ_DIR = ${BUILD}/librets/objects
LIBRETS_LIB    = ${BUILD}/librets/lib/$(LIBRETS_A)
LIBRETS_SRC_FILES := $(wildcard ${LIBRETS_SRC_DIR}/*.cpp)
LIBRETS_OBJECTS := $(patsubst $(LIBRETS_SRC_DIR)/%.cpp, \
	$(LIBRETS_OBJ_DIR)/%.o, $(LIBRETS_SRC_FILES))
LIBRETS_DEPENDS := $(patsubst $(LIBRETS_SRC_DIR)/%.cpp, \
	$(LIBRETS_OBJ_DIR)/%.d, $(LIBRETS_SRC_FILES))


#######

ifeq ($(USE_SQL_COMPILER),1)
LIBRETS_OBJECTS :=  $(LIBRETS_ANTLR_OBJECTS) $(LIBRETS_SQL_OBJECTS) $(LIBRETS_OBJECTS)
LIBRETS_DEPENDS += $(LIBRETS_SQL_DEPENDS) $(LIBRETS_ANTLR_DEPENDS)
LIBRETS_CFLAGS += -I$(LIBRETS_ANTLR_SRC_DIR)
endif

#######

LIBRETS_INC_FILE := ${LIBRETS_INC_DIR}/$(LIBRETS_H)
LIBRETS_INC_FILES := $(wildcard ${LIBRETS_INC_DIR}/librets/*.h)

$(filter $(LIBRETS_OBJ_DIR)/%.o, $(LIBRETS_OBJECTS)): \
	$(LIBRETS_OBJ_DIR)/%.o: $(LIBRETS_SRC_DIR)/%.cpp
	$(CXX) $(LIBRETS_CFLAGS) $(ARCH_FLAGS) -c $< -o $@

$(filter $(LIBRETS_OBJ_DIR)/%.d, $(LIBRETS_DEPENDS)): \
	$(LIBRETS_OBJ_DIR)/%.d: $(LIBRETS_SRC_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_CFLAGS) $< \
	| $(FIXDEP) $(LIBRETS_SRC_DIR) $(LIBRETS_OBJ_DIR) > $@

$(LIBRETS_LIB): $(LIBRETS_OBJECTS)
	$(AR) -rs $(LIBRETS_LIB) $(LIBRETS_OBJECTS)

########################################################################
#
# librets test
#

LIBRETS_TEST_SRC_DIR	= $(top_srcdir)/project/librets/test/src
LIBRETS_TEST_INC_DIR	= 
LIBRETS_TEST_OBJ_DIR	= ${BUILD}/librets/test/objects
LIBRETS_TEST_CFLAGS = $(CFLAGS) $(BOOST_CFLAGS) $(CPPUNIT_CFLAGS)

ifeq ($(USE_SQL_COMPILER),1)
LIBRETS_TEST_SQL_SRC_DIR = $(top_srcdir)/project/librets/test/sql
LIBRETS_TEST_SQL_OBJ_DIR = ${BUILD}/librets/test/objects
LIBRETS_TEST_SQL_SRC_FILES := $(wildcard $(LIBRETS_TEST_SQL_SRC_DIR)/*.cpp)
LIBRETS_TEST_SQL_OBJECTS := $(patsubst $(LIBRETS_TEST_SQL_SRC_DIR)/%.cpp, \
	$(LIBRETS_TEST_SQL_OBJ_DIR)/%.o, $(LIBRETS_TEST_SQL_SRC_FILES))
LIBRETS_TEST_SQL_DEPENDS := $(patsubst $(LIBRETS_TEST_SQL_SRC_DIR)/%.cpp, \
	$(LIBRETS_TEST_SQL_OBJ_DIR)/%.d, $(LIBRETS_TEST_SQL_SRC_FILES))

LIBRETS_TEST_SQL_CFLAGS = $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_TEST_SRC_DIR)

$(LIBRETS_TEST_SQL_OBJ_DIR)/%.o: $(LIBRETS_TEST_SQL_SRC_DIR)/%.cpp
	$(CXX) $(LIBRETS_TEST_SQL_CFLAGS) -I$(LIBRETS_INC_DIR) -c $< -o $@

$(LIBRETS_TEST_SQL_OBJ_DIR)/%.d: $(LIBRETS_TEST_SQL_SRC_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_TEST_SQL_CFLAGS) -I$(LIBRETS_INC_DIR) $< \
	| $(FIXDEP) $(LIBRETS_TEST_SQL_SRC_DIR) $(LIBRETS_TEST_SQL_OBJ_DIR) > $@
endif

LIBRETS_TEST_SRC_FILES	:= $(wildcard $(LIBRETS_TEST_SRC_DIR)/*.cpp)
LIBRETS_TEST_OBJECTS	:= $(patsubst $(LIBRETS_TEST_SRC_DIR)/%.cpp, \
	$(LIBRETS_TEST_OBJ_DIR)/%.o, $(LIBRETS_TEST_SRC_FILES))
LIBRETS_TEST_DEPENDS	:= $(patsubst $(LIBRETS_TEST_SRC_DIR)/%.cpp, \
	$(LIBRETS_TEST_OBJ_DIR)/%.d, $(LIBRETS_TEST_SRC_FILES))
LIBRETS_TEST_EXE	= ${BUILD}/librets/test/bin/test

ifeq ($(USE_SQL_COMPILER),1)
LIBRETS_TEST_OBJECTS += $(LIBRETS_TEST_SQL_OBJECTS)
LIBRETS_TEST_DEPENDS += $(LIBRETS_TEST_SQL_DEPENDS)
endif

dld-test:
	@echo $(LIBRETS_TEST_SQL_CFLAGS)

$(LIBRETS_TEST_OBJ_DIR)/%.o: $(LIBRETS_TEST_SRC_DIR)/%.cpp
	$(CXX) $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_INC_DIR) -c $< -o $@

$(LIBRETS_TEST_OBJ_DIR)/%.d: $(LIBRETS_TEST_SRC_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_INC_DIR) $< \
	| $(FIXDEP) $(LIBRETS_TEST_SRC_DIR) $(LIBRETS_TEST_OBJ_DIR) > $@

$(LIBRETS_TEST_EXE): $(LIBRETS_TEST_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(LIBRETS_TEST_EXE) $(LIBRETS_TEST_OBJECTS) $(LIBRETS_LIB) \
	$(LIBRETS_LDFLAGS) $(CPPUNIT_LDFLAGS)

########################################################################
#
# librets network test
#

LIBRETS_NETTEST_SRC_DIR	= $(top_srcdir)/project/librets/test-network/src
LIBRETS_NETTEST_INC_DIR	= ${LIBRETS_TEST_SRC_DIR}
LIBRETS_NETTEST_BIN_DIR	= ${BUILD}/librets/test-network/bin
LIBRETS_NETTEST_OBJ_DIR	= ${BUILD}/librets/test-network/objects
LIBRETS_NETTEST_CFLAGS = $(CFLAGS) $(BOOST_CFLAGS) $(CPPUNIT_CFLAGS)

LIBRETS_NETTEST_HTTPSERVER = ${BUILD}/librets/test-network/bin/httpServer.class
LIBRETS_NETTEST_SRC_FILES	:= $(wildcard $(LIBRETS_NETTEST_SRC_DIR)/*.cpp) 
LIBRETS_NETTEST_OBJECTS	:= $(patsubst $(LIBRETS_NETTEST_SRC_DIR)/%.cpp,  \
	$(LIBRETS_NETTEST_OBJ_DIR)/%.o, $(LIBRETS_NETTEST_SRC_FILES)) \
	${LIBRETS_NETTEST_OBJ_DIR}/main.o ${LIBRETS_NETTEST_OBJ_DIR}/testUtil.o
LIBRETS_NETTEST_DEPENDS	:= $(patsubst $(LIBRETS_NETTEST_SRC_DIR)/%.cpp, \
	$(LIBRETS_NETTEST_OBJ_DIR)/%.d, $(LIBRETS_NETTEST_SRC_FILES)) \
	${LIBRETS_NETTEST_OBJ_DIR}/main.d ${LIBRETS_NETTEST_OBJ_DIR}/testUtil.d
LIBRETS_NETTEST_EXE	= ${LIBRETS_NETTEST_BIN_DIR}/test

$(LIBRETS_NETTEST_OBJ_DIR)/%.o: $(LIBRETS_NETTEST_SRC_DIR)/%.cpp
	$(CXX) $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_NETTEST_INC_DIR) \
		-I${LIBRETS_INC_DIR} -c $< -o $@

$(LIBRETS_NETTEST_OBJ_DIR)/main.o: $(LIBRETS_TEST_SRC_DIR)/main.cpp
	$(CXX) $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_NETTEST_INC_DIR) \
		-I${LIBRETS_INC_DIR} -c $< -o $@

$(LIBRETS_NETTEST_OBJ_DIR)/testUtil.o: $(LIBRETS_TEST_SRC_DIR)/testUtil.cpp
	$(CXX) $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_NETTEST_INC_DIR) \
		-I${LIBRETS_INC_DIR} -c $< -o $@

$(LIBRETS_NETTEST_HTTPSERVER): $(LIBRETS_NETTEST_SRC_DIR)/httpServer.java
	$(JAVAC)  $< -d ${LIBRETS_NETTEST_BIN_DIR}

$(LIBRETS_NETTEST_OBJ_DIR)/%.d: $(LIBRETS_NETTEST_SRC_DIR)/%.cpp ${LIBRETS_TEST_SRC_DIR}/main.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(LIBRETS_TEST_CFLAGS) -I$(LIBRETS_NETTEST_INC_DIR) $< \
	-I${LIBRETS_INC_DIR} \
	| $(FIXDEP) $(LIBRETS_NETTEST_SRC_DIR) $(LIBRETS_NETTEST_OBJ_DIR) > $@

$(LIBRETS_NETTEST_EXE): $(LIBRETS_NETTEST_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(LIBRETS_NETTEST_EXE) $(LIBRETS_NETTEST_OBJECTS) $(LIBRETS_LIB) \
	-I${LIBRETS_NETTEST_INC_DIR} -I${LIBRETS_INC_DIR} \
	$(LIBRETS_LDFLAGS) $(CPPUNIT_LDFLAGS)

########################################################################
#
# examples
#

EXAMPLES_SRC_DIR = $(top_srcdir)/project/examples/src
EXAMPLES_OBJ_DIR = ${BUILD}/examples/objects
EXAMPLES_LDFLAGS = $(LDFLAGS) $(LIBRETS_LDFLAGS) $(BOOST_PROGRAM_OPTIONS)
EXAMPLES_CFLAGS = $(CFLAGS) $(CPPFLAGS) $(BOOST_CFLAGS) 

OPTIONS_EXAMPLE_SRC = $(EXAMPLES_SRC_DIR)/Options.cpp
LOGIN_EXAMPLE_SRC_FILES := $(EXAMPLES_SRC_DIR)/login.cpp $(OPTIONS_EXAMPLE_SRC)
LOGIN_EXAMPLE_OBJECTS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(LOGIN_EXAMPLE_SRC_FILES))
LOGIN_EXAMPLE_DEPENDS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(LOGIN_EXAMPLE_SRC_FILES))
LOGIN_EXE = ${BUILD}/examples/bin/login

SEARCH_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/search.cpp \
	$(OPTIONS_EXAMPLE_SRC)
SEARCH_EXAMPLE_OBJECTS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(SEARCH_EXAMPLE_SRC_FILES))
SEARCH_EXAMPLE_DEPENDS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(SEARCH_EXAMPLE_SRC_FILES))
SEARCH_EXE = ${BUILD}/examples/bin/search

DEMO_SEARCH_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/demo-search.cpp \
	$(OPTIONS_EXAMPLE_SRC)
DEMO_SEARCH_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(DEMO_SEARCH_EXAMPLE_SRC_FILES))
DEMO_SEARCH_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(DEMO_SEARCH_EXAMPLE_SRC_FILES))
DEMO_SEARCH_EXE = ${BUILD}/examples/bin/demo-search

INTERLEAVED_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/interleaved.cpp \
	$(OPTIONS_EXAMPLE_SRC)
INTERLEAVED_EXAMPLE_OBJECTS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(INTERLEAVED_EXAMPLE_SRC_FILES))
INTERLEAVED_EXAMPLE_DEPENDS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(INTERLEAVED_EXAMPLE_SRC_FILES))
INTERLEAVED_EXE = ${BUILD}/examples/bin/interleaved

METADATA_EXAMPLE_SRC_FILES := $(EXAMPLES_SRC_DIR)/metadata.cpp \
	$(OPTIONS_EXAMPLE_SRC)
METADATA_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(METADATA_EXAMPLE_SRC_FILES))
METADATA_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(METADATA_EXAMPLE_SRC_FILES))
METADATA_EXE = ${BUILD}/examples/bin/metadata

METADATA2DDL_EXAMPLE_SRC_FILES := $(EXAMPLES_SRC_DIR)/metadata2ddl.cpp \
	$(OPTIONS_EXAMPLE_SRC)
METADATA2DDL_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(METADATA2DDL_EXAMPLE_SRC_FILES))
METADATA2DDL_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(METADATA2DDL_EXAMPLE_SRC_FILES))
METADATA2DDL_EXE = ${BUILD}/examples/bin/metadata2ddl

UPDATE_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/update.cpp \
	$(OPTIONS_EXAMPLE_SRC)
UPDATE_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(UPDATE_EXAMPLE_SRC_FILES))
UPDATE_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(XML_EXAMPLE_SRC_FILES))
UPDATE_EXE = ${BUILD}/examples/bin/update

XML_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/xml.cpp
XML_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(XML_EXAMPLE_SRC_FILES))
XML_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(XML_EXAMPLE_SRC_FILES))
XML_EXE = ${BUILD}/examples/bin/xml

HTTP_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/http.cpp
HTTP_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(HTTP_EXAMPLE_SRC_FILES))
HTTP_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(HTTP_EXAMPLE_SRC_FILES))
HTTP_EXE = ${BUILD}/examples/bin/http

RAW_METADATA_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/rawmetadata.cpp \
	$(OPTIONS_EXAMPLE_SRC)
RAW_METADATA_EXAMPLE_OBJECTS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(RAW_METADATA_EXAMPLE_SRC_FILES))
RAW_METADATA_EXAMPLE_DEPENDS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(RAW_METADATA_EXAMPLE_SRC_FILES))
RAW_METADATA_EXE = ${BUILD}/examples/bin/rawmetadata

RAW_RETS_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/raw-rets.cpp
RAW_RETS_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(RAW_RETS_EXAMPLE_SRC_FILES))
RAW_RETS_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(RAW_RETS_EXAMPLE_SRC_FILES))
RAW_RETS_EXE = ${BUILD}/examples/bin/raw-rets

RAW_SEARCH_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/rawsearch.cpp \
	$(OPTIONS_EXAMPLE_SRC)
RAW_SEARCH_EXAMPLE_OBJECTS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(RAW_SEARCH_EXAMPLE_SRC_FILES))
RAW_SEARCH_EXAMPLE_DEPENDS	 := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(RAW_SEARCH_EXAMPLE_SRC_FILES))
RAW_SEARCH_EXE = ${BUILD}/examples/bin/rawsearch

SQL2DMQL_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/sql2dmql.cpp
SQL2DMQL_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(SQL2DMQL_EXAMPLE_SRC_FILES))
SQL2DMQL_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(SQL2DMQL_EXAMPLE_SRC_FILES))
SQL2DMQL_EXE = ${BUILD}/examples/bin/sql2dmql

GET_OBJECT_EXAMPLE_SRC_FILES := ${EXAMPLES_SRC_DIR}/get-object.cpp \
	$(OPTIONS_EXAMPLE_SRC)
GET_OBJECT_EXAMPLE_OBJECTS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.o, $(GET_OBJECT_EXAMPLE_SRC_FILES))
GET_OBJECT_EXAMPLE_DEPENDS := $(patsubst $(EXAMPLES_SRC_DIR)/%.cpp, \
	$(EXAMPLES_OBJ_DIR)/%.d, $(GET_OBJECT_EXAMPLE_SRC_FILES))
GET_OBJECT_EXE = ${BUILD}/examples/bin/get-object

EXAMPLES_DEPENDS = $(LOGIN_EXAMPLE_DEPENDS) $(SEARCH_EXAMPLE_DEPENDS) \
	$(METADATA_EXAMPLE_DEPENDS) $(XML_EXAMPLE_DEPENDS) \
	$(HTML_EXAMPLE_DEPENDS) $(SQL2DMQL_EXAMPLE_DEPENDS) \
	$(HTTP_EXAMPLE_DEPENDS) $(GET_OBJECT_EXAMPLE_DEPENDS) \
	$(DEMO_SEARCH_EXAMPLE_DEPENDS) ${INTERLEAVED_EXAMPLE_DEPENDS} \
	${RAW_METADATA_EXAMPLE_DEPENDS} ${RAW_SEARCH_EXAMPLE_DEPENDS} \
        ${METADATA2DDL_EXAMPLE_DEPENDS} ${UPDATE_EXAMPLE_DEPENDS}

EXAMPLES_EXE = $(LOGIN_EXE) $(SEARCH_EXE) $(METADATA_EXE) $(XML_EXE) \
	$(HTTP_EXE) $(RAW_RETS_EXE) $(GET_OBJECT_EXE) \
	$(DEMO_SEARCH_EXE) ${INTERLEAVED_EXE} ${RAW_SEARCH_EXE} \
	${RAW_METADATA_EXE} ${METADATA2DDL_EXE} ${UPDATE_EXE}

ifeq ($(USE_SQL_COMPILER),1)
EXAMPLES_EXE += $(SQL2DMQL_EXE)
endif

$(EXAMPLES_OBJ_DIR)/%.o: $(EXAMPLES_SRC_DIR)/%.cpp
	$(CXX) $(EXAMPLES_CFLAGS) -I$(LIBRETS_INC_DIR) -c $< -o $@

$(EXAMPLES_OBJ_DIR)/%.d: $(EXAMPLES_SRC_DIR)/%.cpp
	@echo Generating dependencies for $<
	@mkdir -p $(dir $@)
	@$(CC) -MM $(EXAMPLES_CFLAGS) -I$(LIBRETS_INC_DIR) $< \
	| $(FIXDEP) $(EXAMPLES_SRC_DIR) $(EXAMPLES_OBJ_DIR) > $@


$(LOGIN_EXE): $(LOGIN_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(LOGIN_EXE) $(LOGIN_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(SEARCH_EXE): $(SEARCH_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(SEARCH_EXE) $(SEARCH_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(DEMO_SEARCH_EXE): $(DEMO_SEARCH_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(DEMO_SEARCH_EXE) $(DEMO_SEARCH_EXAMPLE_OBJECTS) \
	$(LIBRETS_LIB) $(EXAMPLES_LDFLAGS)

$(METADATA_EXE): $(METADATA_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(METADATA_EXE) $(METADATA_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(METADATA2DDL_EXE): $(METADATA2DDL_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(METADATA2DDL_EXE) $(METADATA2DDL_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(UPDATE_EXE): $(UPDATE_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(UPDATE_EXE) $(UPDATE_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(XML_EXE): $(XML_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(XML_EXE) $(XML_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(HTTP_EXE): $(HTTP_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(HTTP_EXE) $(HTTP_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(RAW_METADATA_EXE): $(RAW_METADATA_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(RAW_METADATA_EXE) $(RAW_METADATA_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(RAW_RETS_EXE): $(RAW_RETS_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(RAW_RETS_EXE) $(RAW_RETS_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(RAW_SEARCH_EXE): $(RAW_SEARCH_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(RAW_SEARCH_EXE) $(RAW_SEARCH_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(SQL2DMQL_EXE): $(SQL2DMQL_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(SQL2DMQL_EXE) $(SQL2DMQL_EXAMPLE_OBJECTS) $(LIBRETS_LIB) \
	$(EXAMPLES_LDFLAGS)

$(GET_OBJECT_EXE): $(GET_OBJECT_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(GET_OBJECT_EXE) $(GET_OBJECT_EXAMPLE_OBJECTS) \
	$(LIBRETS_LIB) $(EXAMPLES_LDFLAGS)

$(INTERLEAVED_EXE): $(INTERLEAVED_EXAMPLE_OBJECTS) $(LIBRETS_LIB)
	$(CXX) -o $(INTERLEAVED_EXE) $(INTERLEAVED_EXAMPLE_OBJECTS) \
	$(LIBRETS_LIB) $(EXAMPLES_LDFLAGS)


########################################################################
#
# swig
#
ifeq (${USE_SWIG_BINDINGS}, 1)

include ${top_srcdir}/project/build/swig.mk

endif

########################################################################
#
# misc
#

DISTCLEAN_FILES = \
	config.status config.log config.cache \
	project/librets/src/config.h \
	Makefile project/build/Doxyfile \
	librets-config librets-config-inplace
