#ifndef LIBPOSTAL_CONFIG_H
#define LIBPOSTAL_CONFIG_H

#ifdef HAVE_CONFIG_H
  #ifndef CONFIG_H
    #define CONFIG_H
    #include <config.h>
  #endif
#endif

#ifndef LIBPOSTAL_DATA_DIR
#error LIBPOSTAL_DATA_DIR not defined!
#endif

#define LIBPOSTAL_ADDRESS_PARSER_SUBDIR "address_parser"
#define LIBPOSTAL_ADDRESS_PARSER_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_ADDRESS_PARSER_SUBDIR
#define LIBPOSTAL_ADDRESS_EXPANSIONS_SUBDIR "address_expansions"
#define LIBPOSTAL_ADDRESS_EXPANSIONS_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_ADDRESS_EXPANSIONS_SUBDIR
#define LIBPOSTAL_GEONAMES_SUBDIR "geonames"
#define LIBPOSTAL_GEONAMES_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_GEONAMES_SUBDIR
#define LIBPOSTAL_GEODB_SUBDIR "geodb"
#define LIBPOSTAL_GEODB_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_GEODB_SUBDIR
#define LIBPOSTAL_LANGUAGE_CLASSIFIER_SUBDIR "language_classifier"
#define LIBPOSTAL_LANGUAGE_CLASSIFIER_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_LANGUAGE_CLASSIFIER_SUBDIR
#define LIBPOSTAL_NUMEX_SUBDIR "numex"
#define LIBPOSTAL_NUMEX_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_NUMEX_SUBDIR
#define LIBPOSTAL_TRANSLITERATION_SUBDIR "transliteration"
#define LIBPOSTAL_TRANSLITERATION_DIR LIBPOSTAL_DATA_DIR PATH_SEPARATOR LIBPOSTAL_TRANSLITERATION_SUBDIR

#define GEODB_BLOOM_FILTER_SIZE 100000000
#define GEODB_BLOOM_FILTER_ERROR 0.001

#endif
