/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: util.c,v 1.10 2002/10/02 07:27:01 kingofgib Exp $
 */

 /*----------------------------------------------------------------------*
 * filename:		netutil.c
 * renamed:		util.c
 * created on:		Tue Feb 29 16:52:15 CET 2000
 * created by:		peter
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

# include "local.h"

/*----------------------------------------------------------------------*
 * Returns a string that represent the readable format of the socket 	*
 * family given								*
 *----------------------------------------------------------------------*/
const char *
net_aftoa(int sock_fam)
{
    switch (sock_fam)
    {
    case AF_UNSPEC:	return "AF_UNSPEC";
    case AF_INET:	return "AF_INET";

# ifdef AF_LOCAL
    case AF_LOCAL:	return "AF_LOCAL";
# endif

# ifdef PNET_HAVE_IPv6
    case AF_INET6:	return "AF_INET6";
# endif
    }

    return "UNKNOWN";
}

const char *
net_paftoa(int pnet_fam)
{
    if (pnet_fam == PNET_IPv4)
	return "PNET_IPv4";
    else if (pnet_fam == PNET_IPv6)
	return "PNET_IPv6";
    else if (pnet_fam == PNET_LOCAL)
	return "PNET_LOCAL";
    return "Unknown";
}
const char *
pnetFamilyToAscii(int pnet_fam)
{
    return net_paftoa(pnet_fam);
}
int
pfam2fam(int pfam)
{
    switch (pfam)
    {
    case PNET_UNSPEC:			return AF_UNSPEC;
    case PNET_IPv4:			return AF_INET  ;
    case PNET_IPv6:			return AF_INET6 ;

# ifdef PNET_HAVE_LOCAL
    case PNET_LOCAL:			return AF_LOCAL ;
# endif 

    }

    return AF_UNSPEC;
}
int
fam2pfam(int fam)
{
    if (fam == AF_UNSPEC)
	return PNET_UNSPEC;
    IPv4_ONLY( if (fam == AF_INET) return PNET_IPv4;);
    IPv6_ONLY( if (fam == AF_INET6) return PNET_IPv6; );
    Local_ONLY( if (fam == AF_LOCAL) return PNET_LOCAL; );

    return PNET_UNSPEC;
}

/*----------------------------------------------------------------------*
 * Return the socket type as an ascii string				*
 *----------------------------------------------------------------------*/

const char *
net_sttoa(int sock_type)
{
    switch ( sock_type )
    {
    case SOCK_STREAM:	return "SOCK_STREAM";
    case SOCK_DGRAM:	return "SOCK_DGRAM";
    case SOCK_RAW:	return "SOCK_RAW";
    }
    return "other";
}
