/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pnetudp.c,v 1.3 2002/11/01 07:36:11 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:		pnetudp.c
 * created on:		Tue Oct 29 08:14:30 CET 2002
 * created by:		kingofgib
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* UDP header access							*/
/*----------------------------------------------------------------------*/

# include "local.h"
# include "pnet6tlp.h"

int
pnetUDP_Build(  pnet_udp * udp,
		pnet_ushort src_port, pnet_ushort dst_port,
		pnet_ushort length  , pnet_ushort chksum )
{
    udp->uh_sport = htons( src_port );
    udp->uh_dport = htons( dst_port );
    udp->uh_ulen  = htons( length );
    udp->uh_sum   = htons( chksum );

    return 0;
}
int
pnetUDP_Send( PNETSOCK ps, PNETADDR pa, void *pip,
	      pnet_udp *udp, int do_cksum, byte * buf, int buflen )
{
    struct iovec	iov[3];
    int			i = 0;

    DBG( dbg( "pnetUDP_Send(ps=%lX,pa=%lX,ip=%lX,udp=%lX)\n",
	      XX(ps),XX(pa),XX(ip),XX(udp)) );

    if ( do_cksum )
    {
    	/* Compute UDP check sum here */
	udp->uh_sum = pnetUDP_ComputeChecksum( pip, udp, buf, buflen );
    }

    if ( ps->own_header )
    {
	iov[i].iov_base = (char*) pip;
	iov[i].iov_len  = pnetIP_HeaderLength( pip );
	LLOG( pnetIP_HeaderLength( ip ) );
	i++;
    }

    iov[i].iov_base = (char*) udp;
    iov[i].iov_len  = sizeof( pnet_udp );
    i++;

    iov[i].iov_base = (char*) buf;
    iov[i].iov_len  = buflen;
    i++;

    return net_writev( ps, pa, iov, i, 0 );
}
pnet_ushort
pnetUDP_ComputeChecksum( void * pip, pnet_udp * udp, byte *data, int datalen )
{
    return pnetIP_TLHComputeChecksum( pip, (pnet_byte*) udp,
				sizeof( pnet_udp ), data, datalen, 6, 1 );
}
