/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pnet6tlp.h,v 1.27 2002/12/08 14:31:15 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:		pnet6tlp.h
 * created on:		Thu Jul 25 17:05:53 EDT 2002
 * created by:		teddykgb
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

# ifndef _PNET6_TRANSPORT_LAYER_PROTO_H		/* { */
# define _PNET6_TRANSPORT_LAYER_PROTO_H

/*----------------------------------------------------------------------*/
/* Definitions of some transport layer protocols			*/
/* Well, OK, ip and ip6 aren't _really_ transport layer protocols...	*/
/* Go figure...								*/
/*----------------------------------------------------------------------*/

typedef struct pnet_ip
{
    pnet_byte           ip_vhl;         /* Version and Header Length */
    pnet_byte           ip_tos;         /* Type of Service byte */
    pnet_ushort         ip_len;         /* Total length of datagram */
    pnet_ushort         ip_id;          /* Identification of datagram */
    pnet_ushort         ip_off;         /* Fragmentation offset */
    pnet_byte           ip_ttl;         /* Time to live byte */
    pnet_byte           ip_p;           /* Protocol of user level datagram */
    pnet_ushort         ip_sum;         /* Header checksum */
    pnet_uint           ip_src;         /* Source address of datagram */
    pnet_uint           ip_dst;         /* Destination address of datagram */
} pnet_ip;

# define PNET_IP_RF	0x8000		/* Reserved fragment flag */
# define PNET_IP_DF	0x4000		/* Don't fragment flag */
# define PNET_IP_MF	0x2000		/* More fragments */
# define PNET_IP_FRAGOFFMASK 0x1FFF	/* Actual value of frag offset */

# define PNET_IPHDRLEN( ip )	( ((ip)->ip_vhl & 0X0F) )
# define PNET_IPVERSION(  ip )	( ((ip)->ip_vhl & 0xF0) >> 4 )

/* Just in case */
# undef ip6_vfc
# undef ip6_flow
# undef ip6_plen
# undef ip6_nxt
# undef ip6_hlim

typedef struct pnet_ip6			/* Our own ip6 header */
{
    union {
	pnet_byte	_un_ip6_vfc;		/* Version and priority */
	pnet_uint	_un_ip6_head;	/* Holds traffic class and flow info */
    } _ip6_hdr_un;

    pnet_ushort	ip6_plen;		/* Payload length 	*/
    pnet_byte	ip6_nxt;		/* Next header ( == proto) */
    pnet_byte	ip6_hlim;		/* Hop limit 		*/
    pnet_byte 	ip6_src[16];		/* Let's hope this size won't	*/
    pnet_byte 	ip6_dst[16];		/* change any time soon 	*/
} pnet_ip6;

# define ip6_vfc	_ip6_hdr_un._un_ip6_vfc
# define ip6_flow	_ip6_hdr_un._un_ip6_head

/* This is more or less copied from BSD */
typedef struct pnet_icmp
{
    pnet_byte		icmp_type;
    pnet_byte		icmp_code;
    pnet_ushort		icmp_cksum;
    union
    {
	pnet_byte	ih_pptr;
	pnet_int	ih_gwaddr;
	struct ih_idseq
	{
	    pnet_ushort	icd_id;
	    pnet_ushort icd_seq;
	} ih_idseq;

	pnet_uint	ih_void;
    } icmp_hun;
# define icmp_pptr       icmp_hun.ih_pptr
# define icmp_gwaddr     icmp_hun.ih_gwaddr
# define icmp_id         icmp_hun.ih_idseq.icd_id
# define icmp_seq        icmp_hun.ih_idseq.icd_seq
# define icmp_void       icmp_hun.ih_void
    union
    {
	struct
	{
	    pnet_uint its_otime;
	    pnet_uint its_rtime;
	    pnet_uint its_ttime;
	} id_ts;

# if 0
	struct
	{
	    struct ip idi_ip; /* options and then 64 bits of data */
	} id_ip;
	struct icmp_ra_addr id_radv;
# endif
	pnet_uint	id_mask;
	pnet_byte	id_data[1];
    } icmp_dun;

# define icmp_otime      icmp_dun.id_ts.its_otime
# define icmp_rtime      icmp_dun.id_ts.its_rtime
# define icmp_ttime      icmp_dun.id_ts.its_ttime
# define icmp_ip         icmp_dun.id_ip.idi_ip
# define icmp_radv       icmp_dun.id_radv
# define icmp_mask       icmp_dun.id_mask
# define icmp_data       icmp_dun.id_data

} pnet_icmp;

#define ICMP_ECHOREPLY          0       /* Echo Reply                   */
#define ICMP_UNREACH            3               /* dest unreachable, codes: */
#define 	ICMP_UNREACH_NET                0       /* bad net */
#define 	ICMP_UNREACH_HOST               1       /* bad host */
#define 	ICMP_UNREACH_PROTOCOL           2       /* bad protocol */
#define 	ICMP_UNREACH_PORT               3       /* bad port */
#define 	ICMP_UNREACH_NEEDFRAG           4       /* IP_DF caused drop */
#define 	ICMP_UNREACH_SRCFAIL            5       /* src route failed */
#define 	ICMP_UNREACH_NET_UNKNOWN        6       /* unknown net */
#define 	ICMP_UNREACH_HOST_UNKNOWN       7       /* unknown host */
#define 	ICMP_UNREACH_ISOLATED           8       /* src host isolated */
#define 	ICMP_UNREACH_NET_PROHIB         9       /* net denied */
#define 	ICMP_UNREACH_HOST_PROHIB        10      /* host denied */
#define 	ICMP_UNREACH_TOSNET             11      /* bad tos for net */
#define 	ICMP_UNREACH_TOSHOST            12      /* bad tos for host */
#define 	ICMP_UNREACH_FILTER_PROHIB      13      /* admin prohib */
#define 	ICMP_UNREACH_HOST_PRECEDENCE    14      /* host prec vio. */
#define 	ICMP_UNREACH_PRECEDENCE_CUTOFF  15      /* prec cutoff */
#define ICMP_REDIRECT           5       /* Redirect (change route)      */
#define         ICMP_REDIRECT_NET       0               /* for network */
#define         ICMP_REDIRECT_HOST      1               /* for host */
#define         ICMP_REDIRECT_TOSNET    2               /* for tos and net */
#define         ICMP_REDIRECT_TOSHOST   3               /* for tos and host */
#define ICMP_ECHO               8       /* Echo Request                 */
#define ICMP_SOURCEQUENCH       4               /* packet lost, slow down */
#define ICMP_ROUTERADVERT       9               /* router advertisement */
#define ICMP_ROUTERSOLICIT      10              /* router solicitation */
#define ICMP_TIMXCEED           11              /* time exceeded, code: */
#define         ICMP_TIMXCEED_INTRANS   0               /* ttl==0 in transit */
#define         ICMP_TIMXCEED_REASS     1               /* ttl==0 in reass */
#define ICMP_PARAMPROB          12              /* ip header bad */
#define         ICMP_PARAMPROB_ERRATPTR 0               /* error at param ptr */
#define         ICMP_PARAMPROB_OPTABSENT 1              /* req. opt. absent */
#define         ICMP_PARAMPROB_LENGTH 2                 /* bad length */
#define ICMP_TSTAMP             13              /* timestamp request */
#define ICMP_TSTAMPREPLY        14              /* timestamp reply */
#define ICMP_IREQ               15              /* information request */
#define ICMP_IREQREPLY          16              /* information reply */
#define ICMP_MASKREQ            17              /* address mask request */
#define ICMP_MASKREPLY          18              /* address mask reply */

#define ICMP_MAXTYPE            18

/* UNREACH codes */

/* REDIRECT codes */
#define ICMP_REDIRECT_NET       0               /* for network */
#define ICMP_REDIRECT_HOST      1               /* for host */
#define ICMP_REDIRECT_TOSNET    2               /* for tos and net */
#define ICMP_REDIRECT_TOSHOST   3               /* for tos and host */

/* TIMEXCEED codes */
#define ICMP_TIMXCEED_INTRANS   0               /* ttl==0 in transit */
#define ICMP_TIMXCEED_REASS     1               /* ttl==0 in reass */

typedef struct pnet_icmp6
{
    pnet_byte	icmp6_type;
    pnet_byte	icmp6_code;
    pnet_ushort	icmp6_cksum;
    union
    {
	pnet_uint	icmp6_un_data32[1]; /* type-specific field */
	pnet_ushort	icmp6_un_data16[2]; /* type-specific field */
	pnet_byte	icmp6_un_data8[4];  /* type-specific field */
    } icmp6_dataun;
} pnet_icmp6;

# define icmp6_data32    icmp6_dataun.icmp6_un_data32
# define icmp6_data16    icmp6_dataun.icmp6_un_data16
# define icmp6_data8     icmp6_dataun.icmp6_un_data8
# define icmp6_pptr      icmp6_data32[0]  /* parameter prob */
# define icmp6_mtu       icmp6_data32[0]  /* packet too big */
# define icmp6_id        icmp6_data16[0]  /* echo request/reply */
# define icmp6_seq       icmp6_data16[1]  /* echo request/reply */
# define icmp6_maxdelay  icmp6_data16[0]  /* mcast group membership */

#define ICMP6_DST_UNREACH             1
#define ICMP6_PACKET_TOO_BIG          2
#define ICMP6_TIME_EXCEEDED           3
#define ICMP6_PARAM_PROB              4

#define ICMP6_INFOMSG_MASK  0x80    /* all informational messages */

#define ICMP6_ECHO_REQUEST	    128
#define ICMP6_ECHO_REPLY            129
#define ICMP6_MEMBERSHIP_QUERY          130     /* group membership query */
#define MLD6_LISTENER_QUERY             130     /* multicast listener query */
#define ICMP6_MEMBERSHIP_REPORT         131     /* group membership report */
#define MLD6_LISTENER_REPORT            131     /* multicast listener report */
#define ICMP6_MEMBERSHIP_REDUCTION      132     /* group membership termination
*/
#define MLD6_LISTENER_DONE              132     /* multicast listener done */
 
#define ND_ROUTER_SOLICIT               133     /* router solicitation */
#define ND_ROUTER_ADVERT                134     /* router advertisment */ 
#define ND_NEIGHBOR_SOLICIT             135     /* neighbor solicitation */
#define ND_NEIGHBOR_ADVERT              136     /* neighbor advertisment */
#define ND_REDIRECT                     137     /* redirect */
 
#define ICMP6_ROUTER_RENUMBERING        138     /* router renumbering */  
 
#define ICMP6_WRUREQUEST                139     /* who are you request */
#define ICMP6_WRUREPLY                  140     /* who are you reply */
#define ICMP6_FQDN_QUERY                139     /* FQDN query */
#define ICMP6_FQDN_REPLY                140     /* FQDN reply */
#define ICMP6_NI_QUERY                  139     /* node information request */
#define ICMP6_NI_REPLY                  140     /* node information reply */


typedef pnet_uint	tcp_seq;
typedef struct pnet_tcp
{
    pnet_ushort		th_sport;
    pnet_ushort		th_dport;
    tcp_seq		th_seq;
    tcp_seq		th_ack;
    pnet_byte		th_x2off;
    pnet_byte		th_flags;	/* For values, see below */
    pnet_ushort		th_win;
    pnet_ushort		th_sum;
    pnet_ushort		th_urp;
} pnet_tcp;

# define TH_FIN		0x01
# define TH_SYN		0x02
# define TH_RST		0x04
# define TH_PUSH	0x08
# define TH_ACK		0x10
# define TH_URG		0x20
# define TH_CE		0x40
# define TH_CC		0x80

typedef struct pnet_upd
{
    pnet_ushort		uh_sport;
    pnet_ushort		uh_dport;
    pnet_ushort		uh_ulen ;
    pnet_ushort		uh_sum  ;
} pnet_udp;

# ifndef IPV6_VERSION_MASK
#   define IPV6_VERSION_MASK	(0xF0)
# endif

# define pnetIP6Next( pip )		( ((struct pnet6*)pip)->ip6_nxt )
# define pnetIP6Hoplimit( pip )		( ((struct pnet6*)pip)->ip6_hlim )

extern pnet_ip * pnetAuxIP(PNETSOCK_AUXINFO);
extern pnet_ip6 * pnetAuxIP6(PNETSOCK_AUXINFO);

extern int pnetSockOwnIPHeader(PNETSOCK,int);

/*----------------------------- (   27 lines ) --------------------------*/
extern pnet_ip* pnetIP4_Build(pnet_ip *,int,int,int,int,int,int,int,PNETADDR,PNETADDR);
extern int pnetIP4_Checksum(pnet_ip *);
extern pnet_ushort pnetIP4_ComputeChecksum(pnet_ip *);
extern int pnetIP4_DontFrag(pnet_ip *);
extern int pnetIP4_FragOffset(pnet_ip *);
extern int pnetIP4_Id(pnet_ip *);
extern int pnetIP4_MoreFrags(pnet_ip *);
extern int pnetIP4_Tos(pnet_ip *);
extern pnet_ip6* pnetIP6_Build(pnet_ip6 *,int,pnet_uint,pnet_ushort,int,int,PNETADDR,PNETADDR);
extern int pnetIP6_Flow(pnet_ip6 *);
extern int pnetIP6_Priority(pnet_ip6 *);
extern int pnetIP6_TrafficClass(pnet_ip6 *);
extern pnet_uint pnetIP_ChecksumAdd(pnet_ushort*,pnet_uint,pnet_uint);
extern pnet_ushort pnetIP_ChecksumFold(pnet_uint);
extern int pnetIP_Destination(void *,PNETADDR);
extern int pnetIP_HeaderLength(void *);
extern int pnetIP_Hoplimit(void *);
extern int pnetIP_Length(void *);
extern pnet_byte* pnetIP_Payload(void *);
extern int pnetIP_PayloadLength(void *);
extern int pnetIP_Protocol(void *);
extern int pnetIP_Send(PNETSOCK,PNETADDR,void *,pnet_byte *,int,int,int,pnet_byte *,int);
extern int pnetIP_Source(void *,PNETADDR);
extern pnet_ushort pnetIP_TLHComputeChecksum(void *,pnet_byte *,int,pnet_byte *,int,int,int);
extern int pnetIP_TTL(void *);
extern int pnetIP_Version(void *);

extern int pnetICMPSend(PNETSOCK,PNETADDR,int,int,void *,int);
extern int pnetICMPSendDestUnreach(PNETSOCK,PNETADDR,int,void *,int);
extern int pnetICMPSendEchoReq(PNETSOCK,PNETADDR,int);
extern int pnetICMPSendTimeX(PNETSOCK,PNETADDR,int,void *,int);
extern void pnetICMP_FilterClose(PNET_ICMPv6_Filter);
extern int pnetICMP_FilterInstall(PNETSOCK,PNET_ICMPv6_Filter);
extern PNET_ICMPv6_Filter pnetICMP_FilterOpen(void);
extern void pnetICMP_FilterSetBlock(PNET_ICMPv6_Filter,int);
extern void pnetICMP_FilterSetPass(PNET_ICMPv6_Filter,int);
extern int pnetICMP_FilterWillBlock(PNET_ICMPv6_Filter,int);
extern int pnetICMP_FilterWillPass(PNET_ICMPv6_Filter,int);
extern const char * pnetICMP_TypeDesc(int,int);
extern const char * pnetICMP_CodeDesc(int,int,int);


/*----------------------------------------------------------------------*/
/* TCP stuff								*/
/*----------------------------------------------------------------------*/

# define pnetTCP_DataOffset( tcp )	(((tcp)->th_x2off & 0xF0) >> 2)
# define pnetTCP_HeaderLength( tcp )	pnetTCP_DataOffset( tcp )
# define pnetTCP_SrcPort( tcp )		pnet_ntohs( (tcp)->th_sport )
# define pnetTCP_DstPort( tcp )		pnet_ntohs( (tcp)->th_dport )
# define pnetTCP_Seq( tcp )		pnet_ntohl( (tcp)->th_seq   )
# define pnetTCP_Ack( tcp )		pnet_ntohl( (tcp)->th_ack   )
# define pnetTCP_Win( tcp )		pnet_ntohs( (tcp)->th_win   )
# define pnetTCP_Checksum( tcp )	pnet_ntohs( (tcp)->th_sum   )

# define pnetTCP_Fin( tcp )		((tcp)->th_flags&TH_FIN )
# define pnetTCP_Syn( tcp )		((tcp)->th_flags&TH_SYN )
# define pnetTCP_Rst( tcp )		((tcp)->th_flags&TH_RST )
# define pnetTCP_Push( tcp )		((tcp)->th_flags&TH_PUSH)
# define pnetTCP_Urg( tcp )		((tcp)->th_flags&TH_URG )
# define pnetTCP_Ece( tcp )		((tcp)->th_flags&TH_CE )
# define pnetTCP_Cwr( tcp )		((tcp)->th_flags&TH_CC )

# define pnetTCP_Opts(tcp )	(((pnet_byte*)(tcp)) + sizeof( pnet_tcp ) )
# define pnetTCP_OptsLen( tcp )	\
	( pnetTCP_DataOffset( tcp ) - sizeof( pnet_tcp ) )

/*----------------------------- (    4 lines ) --------------------------*/
extern int pnetTCP_Build(pnet_tcp *,pnet_ushort,pnet_ushort,pnet_uint,pnet_uint,pnet_byte,pnet_byte,pnet_ushort,pnet_ushort,pnet_ushort);
extern pnet_ushort pnetTCP_ComputeChecksum(void *,pnet_tcp *,pnet_byte *,int);
extern int pnetTCP_Send(PNETSOCK,PNETADDR,void *,pnet_tcp *,pnet_byte *,int);

/*----------------------------------------------------------------------*/
/* UDP Stuff								*/
/*----------------------------------------------------------------------*/

# define pnetUDP_SrcPort( udp )		pnet_ntohs( (udp)->uh_sport )
# define pnetUDP_DstPort( udp )		pnet_ntohs( (udp)->uh_dport )
# define pentUDP_Length( udp )		pnet_ntohs( (udp)->uh_ulen  )
# define pnetUDP_Checksum( udp )	pnet_ntohs( (udp)->uh_sum   )


/*----------------------------- (    4 lines ) --------------------------*/
extern int pnetUDP_Build(pnet_udp *,pnet_ushort,pnet_ushort,pnet_ushort,pnet_ushort);
extern pnet_ushort pnetUDP_ComputeChecksum(void *,pnet_udp *,pnet_byte *,int);
extern int pnetUDP_Send(PNETSOCK,PNETADDR,void *,pnet_udp *,int,pnet_byte *,int);

# endif						/* } */
