/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pnet6pkt.h,v 1.12 2002/11/04 11:10:58 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:		pnet6pkt.h
 * created on:		Tue Jul  9 21:37:30 CEST 2002
 * created by:		teddykgb
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

# ifndef _PNETPKT_INCLUDE_	/* { */
# define _PNETPKT_INCLUDE_

/*----------------------------------------------------------------------*/
/* In order to speed up packet access, I'm exporting ! the packet 	*/
/* struct.								*/
/*----------------------------------------------------------------------*/
struct pnet_pkt
{
    pnet_ulong		pkt_tssec;
    pnet_ulong		pkt_tsusec;	/* When we got packet 		*/
    pnet_ushort		pkt_grablen;	/* What we got 			*/
    pnet_uint		pkt_datalen;	/* Actual length of packet 	*/
    pnet_byte*		pkt_buf;	/* Shared (!) buffer		*/
    PNetPktAccess *	pkt_pa;		/* Interface we got packet from */
    pnet_ushort		pkt_type,pkt_stype;	/* IP/TCP, IP/UDP etc... */
};

/* Packet types			*/
# define PNET_PKTTYPE_NONE	0
# define PNET_PKTTYPE_IPv4	1
# define PNET_PKTTYPE_IPv6	2
# define PNET_PKTTYPE_ARP	3
# define PNET_PKTTYPE_RARP	4

# define PNET_READ_RAW		1
# define PNET_READ_COOKED	2

extern int pnetPktAddFilter(PNetPktAccess *,const char *);
extern void pnetPktCloseInterface(PNET_PKTACCESS);
extern void pnetPktDump(FILE *,PNET_PKT);
extern int pnetPktGetStats(PNET_PKTACCESS,pnet_uint *,pnet_uint *);
extern pnet_byte* pnetPktLLDest(PNetPacket *,int *);
extern int pnetPktLLLength(PNET_PKTACCESS,int *);
extern pnet_byte* pnetPktLLSource(PNetPacket *,int *);
extern int pnetPktLLType(PNetPacket *,int *);
extern PNET_PKT pnetPktMake(void);
extern int pnetPktNextPacket(PNET_PKTACCESS,PNET_PKT);
extern PNET_PKTACCESS pnetPktOpenInterface(const char *,int,int,int);
extern int pnetPktSetReadMode(PNET_PKTACCESS,int);
extern int pnetPktSetReadTimeout(PNET_PKTACCESS,int);
extern int pnetPktWrite(PNET_PKTACCESS,pnet_byte *,pnet_uint);


# endif /* } */
