/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pkt.h,v 1.39 2002/11/04 08:39:53 kingofgib Exp $
 */


/*----------------------------------------------------------------------*
 * filename:            pkt.h
 * created on:          Fri Jul  5 16:36:33 CEST 2002
 * created by:          peter
 * project:             Portable Network Library
 *----------------------------------------------------------------------*/

# ifndef _LOCAL_PKT_H_				/* { */
# define _LOCAL_PKT_H_

# ifndef PNET_WIN32				/* {{ */

# include <sys/types.h>
# include <sys/socket.h>
# include <sys/ioctl.h>
# include <sys/time.h>

# include <net/if.h>

# ifdef HAVE_NETINET_IF_ETHER_H
#   include <netinet/if_ether.h>
# elif defined HAVE_SYS_ETHERNET_H
#   include <sys/ethernet.h>
# elif defined HAVE_NET_ETHERNET_H
#   include <net/ethernet.h>
# endif

# include <netinet/in.h>

# if defined HAVE_NET_IF_ARP_H
#   include <net/if_arp.h>
# endif

# if defined HAVE_NET_PFILT_H		/* Tru64 */
#   include <net/pfilt.h>
# endif

# ifdef STDLinux			/* {{ */

# include <sys/socket.h>
# include <features.h>
# if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1

#   include <netpacket/packet.h>
#   include <net/ethernet.h>     /* the L2 protocols */

# else

#   include <asm/types.h>
#   include <linux/if_packet.h>
#   include <linux/if_ether.h>   /* The L2 protocols */

# endif


# ifdef HAVE_NET_BPF_H		/* {{ */

#   include <net/bpf.h>

typedef struct bpf_program	BPF_PROG;
typedef struct bpf_insn 	BPF_FILTER;

# elif HAVE_LINUX_FILTER_H	/* }{ */

#   include <linux/filter.h>

typedef struct sock_fprog       BPF_PROG;
typedef struct sock_filter      BPF_FILTER;

# define bf_len			len
# define bf_insns		filter

# endif				/* }} */

# else					/* }{ */

# if defined HAVE_NET_BPF_H 	/* {{ */

# include <net/bpf.h>

# ifdef PNET_WIN32_USE_PACKET_DLL
#   include <packet32.h>
#   include <ntddndis.h>
# endif

typedef struct bpf_program	BPF_PROG;
typedef struct bpf_insn 	BPF_FILTER;

# else				/* }{ */

typedef void* 			BPF_PROG;
typedef void*			BPF_FILTER;

# endif				/* }} */


# endif					/* }} */


# else						/* }{ */

# ifdef PNET_WIN32_USE_PACKET_DLL	/* {{ */

#   include <net/bpf.h>
#   include <packet32.h>
#   include <ntddndis.h>

typedef struct bpf_program	BPF_PROG;
typedef struct bpf_insn		BPF_FILTER;

# else					/* }{ */

typedef void* 			BPF_PROG;
typedef void*			BPF_FILTER;

# endif					/* }} */

/*
 * The number of bytes in an ethernet (MAC) address.
 */
# define ETHER_ADDR_LEN          6

/*
 * The number of bytes in the type field.
 */
# define ETHER_TYPE_LEN          2

/*
 * The number of bytes in the trailing CRC field.
 */
# define ETHER_CRC_LEN           4

/*
 * The length of the combined header.
 */
# define ETHER_HDR_LEN           (ETHER_ADDR_LEN*2+ETHER_TYPE_LEN)

/*
 * The minimum packet length.
 */
# define ETHER_MIN_LEN           64

/*
 * The maximum packet length.
 */
# define ETHER_MAX_LEN           1518

/*
 * A macro to validate a length with
 */
# define ETHER_IS_VALID_LEN(foo) \
        ((foo) >= ETHER_MIN_LEN && (foo) <= ETHER_MAX_LEN)

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct  ether_header
{
    pnet_uchar  ether_dhost[ETHER_ADDR_LEN];
    pnet_uchar  ether_shost[ETHER_ADDR_LEN];
    pnet_ushort ether_type;
};

/*
 * Structure of a 48-bit Ethernet address.
 */
struct  ether_addr
{
    pnet_byte octet[ETHER_ADDR_LEN];
};

# endif						/* }} */


# define PKTBUFSIZ              4096

# ifndef IPV6_VERSION_MASK
#    define IPV6_VERSION_MASK	0xF0
# endif

# ifndef ETHERTYPE_IP
# define ETHERTYPE_IP		0x0800
# endif

# ifndef ETHERTYPE_ARP
# define ETHERTYPE_ARP		0x0806
# endif

# ifndef ETHERTYPE_REVARP
# define ETHERTYPE_REVARP	0x8035
# endif

# ifndef ETHERTYPE_IPV6
# define ETHERTYPE_IPV6		0x86DD
# endif

/*----------------------------------------------------------------------*/
/* The pnet packet access object.                                       */
/*----------------------------------------------------------------------*/
struct pnet_pktacc
{
    char        pa_ifname[IFNAMSIZ + 1];
                                /* Packets are accessed on this interface */
    int         pa_ifindex;     /* Interface index      */
    int         pa_iftype;      /* Interface type: ETHER, LOOP, SLIP    */
    int         pa_ifisprom;    /* Is this device in promiscuous mode */

    int         pa_buflen;
    byte*       pa_buf;
    byte*	pa_sbuf,*pa_ebuf;

# if PNET_WIN32_USE_PACKET_DLL
    LPADAPTER	pa_fd;
    LPPACKET	pa_pkt;
# else 
    int         pa_fd;
# endif
    int		pa_glen;	/* Length to grab 			*/
    int		pa_llh_len;	/* Length of link layer header		*/

    int		pa_cooked;	/* grab in raw/cooked mode 		*/
# define PKTACC_NOT_COOKED	0
# define PKTACC_PSEUDO_COOKED	1
# define PKTACC_TRUE_COOKED	2

    BPF_FILTER*			pa_bpf;
};

# define pkt_get_payload(pkt)	(pkt->pkt_buf + pkt->pkt_pa->pa_llh_len)

/* Link layer types */

# ifndef DLT_NULL
#   define DLT_NULL		0
# endif
# ifndef DLT_EN10MB
#   define DLT_EN10MB		1
# endif
# ifndef DLT_SLIP
#   define DLT_SLIP		2
# endif
# ifndef DLT_PPP
#   define DLT_PPP		3
# endif
# ifndef DLT_FDDI
#   define DLT_FDDI		4
# endif
# ifndef DLT_RAW
#   define DLT_RAW		5
# endif

/* Link layer header access constants */

# define PPKT_LL_SRC		1
# define PPKT_LL_DST		2
# define PPKT_LL_TYP		3
# define PPKT_LL_LENGTH		4

# include "pktproto.h"

# endif						/* } */
