/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: local.h,v 1.66 2002/11/15 14:43:08 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:            local.h
 * created on:          Fri May 10 19:27:17 CEST 2002
 * created by:          peter
 * project:             Portable Network Library
 *----------------------------------------------------------------------*/

# ifndef _PNET_LOCAL_INCLUDED	/* { */
# define _PNET_LOCAL_INCLUDED

# define PNET_COMPILE		1

# define PNET_VERSION		"1.0"
# include "stdinc.h"

# define XX(x)			((unsigned long)(x))
# define PMAX(a,b)		((a) < (b) ? (b) : (a))
# define PMIN(a,b)		((a) > (b) ? (b) : (a))

# define PYESNO(x)		((x) ? "YES" : "NO")
# define pyesno(x)		((x) ? "yes" : "no")
# define PONOFF(x)		((x) ? "ON" : "OFF")
# define ponoff(x)		((x) ? "on" : "off")

# if defined STDWin32
#   include "win32-config.h"
# else
#   include "config.h"
# endif

/*
 * Set flags for available networking support.
 *  if sockaddr_un is present, we assume host can work with AF_LOCAL sockets.
 *  if sockaddr_in is present, we assume host can work with AF_INET sockets.
 *  if sockaddr_in6 is present, we asssume host can work with AF_INET6 sockets.
 * In all cases, ``can work'' simply means the code will be able to
 *  compile, not actually do something.
 */
# if defined HAVE_STRUCT_SOCKADDR_UN
#   define PNET_HAVE_LOCAL	1
# endif
# if defined HAVE_STRUCT_SOCKADDR_IN
#   define PNET_HAVE_IPv4	1
# endif
# if defined HAVE_STRUCT_SOCKADDR_IN6
#   define PNET_HAVE_IPv6	1
# endif

# ifdef STDWin32
typedef SOCKET		pnetsock_t;
# ifndef __GNUC__
typedef int		pid_t;
# endif
# endif

# ifdef PNET_APPLE
typedef int socklen_t;
# endif

# ifndef STDWin32				/* {{ */

# include <sys/param.h>
# include <time.h>
# include <sys/time.h>
# include <sys/uio.h>
# include <sys/types.h>

# include <unistd.h>

# if defined PNET_TRU64
#   define _SOCKADDR_LEN            1
#   define _OSF_SOURCE
# endif

# if defined PNET_HPUX || defined PNET_TRU64	/* {{ */

#   define _XOPEN_SOURCE_EXTENDED
#     include <sys/socket.h>
#   undef _XOPEN_SOURCE_EXTENDED

# else						/* }{ */

# if defined PNET_SUN		/* { */

# define _XOPEN_SOURCE			500
# define _XOPEN_SOURCE_EXTENDED		1
# define __EXTENSIONS__

/* THIS IS A HACK. Fix it if you can... */
# define _XPG4_2

# endif				/* } */

#   include <sys/socket.h>

# endif						/* }} */

# include <netdb.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# include <net/if.h>

# ifdef HAVE_STRUCT_SOCKADDR_DL
#  include <net/if_dl.h> 
# endif

# include <fcntl.h>
# include <signal.h>

# ifdef HAVE_SYS_WAIT_H
#   include <sys/wait.h>
# elif defined HAVE_WAIT_H
#   include <wait.h>
# else
#   error "Cannot find wait.h on this system."
# endif

# if ! defined AF_LOCAL
#    if ! defined AF_UNIX 
#        error "Don't seem to have AF_LOCAL/AF_UNIX."
#    else
#        define AF_LOCAL	AF_UNIX
#    endif
# endif

# ifdef HAVE_SYS_UN_H
#   include <sys/un.h>
# endif

# ifdef STDLinux
#   if defined HAVE_NETPACKET_PACKET_H && defined HAVE_NET_ETHERNET_H
#      define PNET_HAVE_PACKET_ACCESS		1
#      define PNET_HAVE_PF_PACKET
#   elif defined HAVE_LINUX_IF_PACKET_H && defined HAVE_LINUX_IF_ETHER_H
#      define PNET_HAVE_PACKET_ACCESS		1
#      define PNET_HAVE_PF_PACKET
#   endif
# endif

# ifdef HAVE_NET_BPF_H
#   define PNET_HAVE_PACKET_ACCESS		1
# endif

typedef int		pnetsock_t;

# endif						/* }} */

# if defined PNET_HAVE_LOCAL
#   ifndef SUN_LEN		/* This one's from BSD */
#     define SUN_LEN(su) \
	  (sizeof(*(su)) - sizeof((su)->sun_path) + strlen((su)->sun_path))
#   endif
# endif 

# if defined PNET_HAVE_LOCAL
#   define Local_ONLY(x)		x
# else
#   define Local_ONLY(x)
# endif

# if defined PNET_HAVE_IPv4
#   define IPv4_ONLY(x)		x
# else
#   define IPv4_ONLY(x)
# endif

# if defined PNET_HAVE_IPv6
#   define IPv6_ONLY(x)		x
# else
#   define IPv6_ONLY(x)
# endif

# include "pnet6.h"
# include "pnet6tlp.h"

typedef pnet_byte		byte;

typedef struct sockaddr		SockAddr;
typedef struct sockaddr_in	InetAddr;

# ifdef PNET_HAVE_LOCAL
typedef struct sockaddr_un	UnixAddr;
# endif

# ifdef PNET_HAVE_IPv6		/* { */

typedef struct sockaddr_in6	InetAddr6;

# else 		/* Some fake defines for systems that don't have IPv6 */

#     define AF_INET6		AF_INET
#     define INET_ADDRSTRLEN	16
#     define INET6_ADDRSTRLEN	INET_ADDRSTRLEN
#     define in6_addr		in_addr
#     define sin6_family	sin_family
#     define sin6_addr		sin_addr
#     define sin6_port		sin_port
#     define in6addr_any	INADDR_ANY

typedef struct sockaddr_in	InetAddr6;

# endif 			/* } */

/*
 * The following is highly experimental
 * We won't deal with it for now
# ifdef STDLinux
#   ifndef IPV6_FLOWINFO_SEND
#     define IPV6_FLOWINFO_SEND	33
#   endif
#   ifndef IPV6_FLOWINFO
#     define IPV6_FLOWINFO	11
#   endif
# endif

*/

# define PNETSockType_NONE	0
# define PNETSockType_TCP	1
# define PNETSockType_UDP	2
# define PNETSockType_RAW	3
# define PNETSockType_RDM	4
# define PNETSockType_SEQ	5

/* The following must be given in this order */
# ifdef PNET_HAVE_IPv4
#   define PNET_MAX_SOCKADDR	sizeof(struct sockaddr_in)
# endif

# ifdef PNET_HAVE_IPv6
#   undef PNET_MAX_SOCKADDR
#   define PNET_MAX_SOCKADDR	sizeof(struct sockaddr_in6)
# endif

# ifdef PNET_HAVE_LOCAL
#   undef PNET_MAX_SOCKADDR
#   define PNET_MAX_SOCKADDR	sizeof(struct sockaddr_un)
# endif

/*----------------------------------------------------------------------*/
/* Interface support.							*/
/*----------------------------------------------------------------------*/

# define PIF_IS_UP		(1<<0)
# define PIF_IS_LOOP		(1<<1)
# define PIF_IS_BCAST		(1<<2)
# define PIF_IS_MCAST		(1<<3)
# define PIF_IS_P2P		(1<<4)
# define PIF_HAS_ADDR		(1<<5)
# define PIF_HAS_BADDR		(1<<6)
# define PIF_HAS_DADDR		(1<<7)
# define PIF_HAS_NETMASK	(1<<8)
# define PIF_HAS_HWADDR		(1<<9)

# ifndef IFNAMSIZ
#   define IFNAMSIZ		16
# endif

# ifdef PNET_SUN
#   undef IFNAMSIZ
#   define IFNAMSIZ		LIFNAMSIZ
# endif

# define IF_ADDRLEN		4
# define IF_HWADDRLEN		8

typedef union
{
    SockAddr	saddr;
    InetAddr	addr4;
    InetAddr6	addr6;
} AddrUn;

/* typedef pnet_byte	byte; */

struct pif_address
{
# ifndef HAVE_SOCKADDR_IN6_SIN6_SCOPE_ID
    int 		pia_scope_id;
# endif
    AddrUn		pia_address;
    int			pia_prefixlen;
    pnet_byte		pia_netmask[17];
    pnet_byte 		pia_broadaddr[5];
    struct pif_address*	pia_next;
    struct pnet_if *    pia_if;
};

# define pia_family	pia_saddr.sa_family
# define pia_saddr	pia_address.saddr
# define pia_addr4	pia_address.addr4
# define pia_addr6	pia_address.addr6
# ifdef HAVE_SOCKADDR_IN6_SIN6_SCOPE_ID
# define pia_scope_id	pia_address.addr6.sin6_scope_id
# endif

struct pnet_if
{
    char 	pif_name[IFNAMSIZ+1];
    u_long	pif_index;
    short	pif_type;
    int		pif_family;
    int		pif_flags;		/* Actual interface flags 	*/
    u_short	pif_pflags;		/* The PIF_XXX flags above 	*/
    int		pif_mtu;		/* MTU of interface 		*/

    pnet_byte	hwaddr_len;
    pnet_byte	hwaddr[IF_HWADDRLEN];

    PNetIfAddr* pif_addrs;		/* List of addresses 		*/
    AddrUn	_pif_daddr;		/* P2P destination address	*/

    struct pnet_if *	next;
};

# define pif_addr		pif_addrs->pia_address.saddr
# define pif_addr4		pif_addrs->pia_address.addr4
# define pif_addr6		pif_addrs->pia_address.addr6
# define pif_daddr		_pif_daddr.saddr
# define pif_daddr4		_pif_daddr.addr4
# define pif_daddr6		_pif_daddr.addr6

/*----------------------------------------------------------------------*/
/* Our encapsulation of an Internet Address.				*/
/*----------------------------------------------------------------------*/
typedef union
{
    SockAddr	saddr;
    InetAddr	addr4;
    InetAddr6	addr6;
# ifdef PNET_HAVE_LOCAL
    struct sockaddr_un	addru;
# endif
} AddrUnX;

/* Definition of an internet address */
struct pnet_addr
{
# ifndef HAVE_SOCKADDR_SA_LEN
    socklen_t	pa_len;		/* Length of InetAddr/InetAddr6 struct */
# endif
# ifndef HAVE_SOCKADDR_IN6_SIN6_SCOPE_ID
    pnet_uint	pa_scope_id;
# endif
# ifndef HAVE_SOCKADDR_IN6_SIN6_FLOWINFO
    pnet_uint	pa_flowinfo;
# endif
    unsigned	init_addr : 1;
    unsigned 	init_port : 1;

    AddrUnX	_addr;

    struct pnet_addr*	pa_next;
};

# define pa_saddr		_addr.saddr
# define pa_family		_addr.saddr.sa_family
# define pa_in4addr		_addr.addr4
# define pa_sin_addr		_addr.addr4.sin_addr
# define pa_s_addr		_addr.addr4.sin_addr.s_addr
# define pa_sin_port		_addr.addr4.sin_port
# ifdef PNET_HAVE_IPv6
#   define pa_in6addr		_addr.addr6
#   define pa_sin6_addr		_addr.addr6.sin6_addr
#   define pa_s6_addr		_addr.addr6.sin6_addr.s6_addr
#   define pa_sin6_port		_addr.addr6.sin6_port
#   ifdef HAVE_SOCKADDR_IN6_SIN6_SCOPE_ID
#     define pa_scope_id	_addr.addr6.sin6_scope_id
#   endif
#   ifdef HAVE_SOCKADDR_IN6_SIN6_FLOWINFO
#     define pa_flowinfo	_addr.addr6.sin6_flowinfo
#   endif
# else
#   define pa_in6addr		_addr.addr4
#   define pa_sin6_addr		_addr.addr4.sin_addr
#   define pa_s6_addr		_addr.addr4.sin_addr.s_addr
#   define pa_sin6_port		_addr.addr4.sin_port
# endif

# ifdef PNET_HAVE_LOCAL
#   define pa_unaddr		_addr.addru
#   define pa_unpath		_addr.addru.sun_path
# endif

# define PA_AddrLen(a)		( addr_len( (pa)->pa_family ) )
# define PA_IPLen(a)		( addr_ip_len( (pa)->pa_family ) )

# ifdef HAVE_SOCKADDR_SA_LEN
#   define pa_len	pa_saddr.sa_len
# endif

# define PA_INIT_PORT(pa)	((pa)->init_port)
# define PA_INIT_ADDR(pa)	((pa)->init_addr)

/*----------------------------------------------------------------------*/
/* Auxiliary Information: UDP aux info, and IP packet aux info		*/
/*----------------------------------------------------------------------*/

struct pnet_aux_pktoptions
{
    int 		pkt_flags;	/* from recvmsg() */
    int			pkt_hoplimit;	/* datagram's hoplimit */
    struct pnet_addr 	pkt_daddr;	/* dest address of datagram */
    struct pnet_if* 	pkt_if;		/* interface datagram arrived on */
};

struct pnet_aux_info
{
    int 	ai_type;
    int		ai_alloc_flag;
    struct {
	struct pnet_aux_pktoptions *	_pkt_info;

	union {
	    pnet_ip *	_ip_header;
	    pnet_ip6*	_ip6_header;
	} _ai_ip_un;

    } _aux_un;
};

# define MAXIPHDRSIZE		60	/* 60 bytes IPv4 header */

# define aux_pkt_opts		_aux_un._pkt_info
# define aux_pkt_flags		_aux_un._pkt_info->pkt_flags
# define aux_pkt_hoplimit	_aux_un._pkt_info->pkt_hoplimit
# define aux_pkt_dst_addr	_aux_un._pkt_info->pkt_daddr
# define aux_pkt_if		_aux_un._pkt_info->pkt_if
# define aux_ip			_aux_un._ai_ip_un._ip_header
# define aux_ip6		_aux_un._ai_ip_un._ip6_header

/*----------------------------------------------------------------------*/
/* PNET socket wrapper structure.					*/
/*----------------------------------------------------------------------*/
struct pnet_sock
{
    pnetsock_t  sd;
    pnet_byte	fam;		/* AF_INET, AF_LOCAL, AF_INET6 ...	*/
    pnet_byte	req_fam;	/* Requested family 			*/
    pnet_byte	type;		/* SOCK_STREAM, SOCK_DGRAM, etc, ...	*/
    pnet_byte	proto;		/* See /etc/protocols 			*/

# ifdef PNET_HAVE_LOCAL
    unsigned    copied_path : 1;   /* Is unix socket path my own? 	*/
# endif
    unsigned 	own_header : 1;	/* Used with raw sockets 		*/
    unsigned 	connected : 1;
    unsigned	multicast : 1;

    struct pnet_addr local_addr; /* Used with UDP and RAW 		*/
    struct pnet_addr peer_addr;

    PNETREADCB	read_callback;	/* Useful, for servers? 		*/
    void*       callback_data;

    /* Additional info stored here */
    struct pnet_aux_info * aux_info;
};

/*----------------------------------------------------------------------*/
/* hstrerror()'s growing obsolete....					*/
/*----------------------------------------------------------------------*/

# ifndef HAVE_HSTRERROR
# define hstrerror(x)		neterr()
# endif 

/* Some people still do not provide inet_ntop() and friends		*/
# ifndef HAVE_INET_NTOP
# define PNET_NO_INET_NTOP
# endif

# ifdef PNET_NO_INET_NTOP	/* { */
extern int inet_pton(int,const char *,void *);
extern const char * inet_ntop(int,const void *,char *,size_t);
# endif				/* } */

# ifndef HAVE_GETTIMEOFDAY
# ifdef __GNUC__
struct timezone {
	int  tz_minuteswest; /* minutes W of Greenwich */
	int  tz_dsttime;     /* type of dst correction */
};
#endif
    extern int gettimeofday(struct timeval *,struct timezone*);
# endif

# include "proto.h"

/* IPv4 address + port address length:  255.255.255.255:65535'\0'   */
# define PNET_IPv4_ADDR_BUFFSIZE 	(INET_ADDRSTRLEN + 6)

/* IPv6 address + port address length (incl. terminating zero) */
# define PNET_IPv6_ADDR_BUFFSIZE	(INET6_ADDRSTRLEN + 6)

extern int		pnetInitDone;		/* defined in init.c */
extern const char *	pnetSysOSName;		/* defined in sysinfo.c */
extern const char * 	pnetSysNodename;	/* defined in sysinfo.c */
extern const char * 	pnetSysRelease ;	/* defined in sysinfo.c */
extern const char *	pnetSysVersion ;	/* defined in sysinfo.c */
extern const char *	pnetSysMachine ;	/* defined in sysinfo.c */

/* 
 * Value of address/scope separator for IPv6 addresses:
 *  -default is '%': 	address%scope
 * Value is controlled by PNET6_SCOPE_SEP env. variable.
 */
extern int		pnet_ScopeSep;		/* defined in init.c	*/

/*----------------------------------------------------------------------*/
/* IP Layer macros							*/
/*----------------------------------------------------------------------*/

# define IPDUMP(ip)	\
	pnetHexdumpX(stdout,(pnet_byte*)ip,pnetIP_HeaderLength(ip),4,16)
# define TCPDUMP(tcp)	\
	pnetHexdumpX(stdout,(pnet_byte*)tcp,pnetTCP_HeaderLength(tcp),4,16)

/*----------------------------------------------------------------------*/
/* Logging and Errors							*/
/*----------------------------------------------------------------------*/
# define PNET_ENV_LOG_FILE		"PNET6_LOG_FILE"
# define PNET_ENV_ERR_FILE		"PNET6_ERR_FILE"
# define PNET_ENV_LOG_FLAGS		"PNET6_LOG_FLAGS"
# define PNET_ENV_SCOPE_SEP		"PNET6_SCOPE_SEP"

# define E_NULL		0
# define E_FATAL	1
# define E_WARN		2
# define E_MSG		3
# define E_INFO		4
# define E_DBG1		5
# define E_DBG2		6
# define E_DBG3		7
# define E_DBG4		8

extern int		dbg(const char*,...);
extern int		err(const char*,...);
extern int		pdbg(unsigned,const char*,...);
extern int		perr(unsigned,const char*,...);
extern const char*	pneterr(int);
extern int		pnetinternalerror(const char*,int,const char*,...);

# define LOGSYSERR(m)	perr(E_FATAL,"[%s,%4d], %s: errno %d: %s\n",\
			     __FILE__,__LINE__,(m),errno,SYSERR())
# define FATALERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s (%d)\n",\
			     __FILE__,__LINE__,(m),SYSERR(),errno)
# define NETERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),neterr())
# define FAMERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),pneterr(PNETerrFam))
# define PROTOERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),pneterr(PNETerrProto))
# define TYPEERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),pneterr(PNETerrType))
# define SPACEERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),pneterr(PNETerrSpace))
# define NOIMPLERR(m)	perr(E_FATAL,"[%s,%4d]: %s: %s\n",\
			     __FILE__,__LINE__,(m),"not implemented\n")
# define THRDERR(m,e)	perr(E_FATAL,"[%s,%4d]: %s: %d\n",\
			     __FILE__,__LINE__,(m), e )
# define LOGTHRDERR(m,e) perr(E_FATAL,"[%s,%4d]: %s: err = %d (%s)\n",\
			     __FILE__,__LINE__,(m), (e), strerror((e)) )
# define MEMERR(m,len)	perr(E_FATAL,"[%s,%4d]: %s: failed on %d bytes\n",\
			     __FILE__,__LINE__,(m), len )

# endif 			/* } */
