/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: init.c,v 1.13 2002/10/28 09:15:04 kingofgib Exp $
 */


/*----------------------------------------------------------------------*
 * filename:            init.c
 * created on:          Mon May 13 09:15:58 CEST 2002
 * created by:          teddykgb
 * project:             Portable Network Library
 *----------------------------------------------------------------------*/

# include "local.h"

int	pnetInitDone = 0;
int 	pnet_ScopeSep = '%';

# ifdef STDWin32
static int	wsa_init(int,int);

static int
wsa_init(int major,int minor)
{
    WSADATA wsd;

    return WSAStartup(MAKEWORD(major,minor),&wsd);
}

# endif

# ifndef __DATE__
# define __DATE__	"today"
# endif
int
pnetShowLibInfo(void)
{
    pdbg(E_DBG1,"libpnet6 %s, built %s on %s.\n",
	PNET_VERSION,__DATE__,PNET_COMPILE_HOST );

    pdbg(E_DBG1,"Variables sizes in bits (as used by pnet):\n" );
    pdbg(E_DBG1,"char=%2d,short=%2d,int=%2d,long=%2d,longlong=%2d\n",
	sizeof( pnet_char ) * 8,
	sizeof( pnet_short ) * 8,
	sizeof( pnet_int ) * 8, 
	sizeof( pnet_long ) * 8, 
	sizeof( pnet_longlong ) * 8 );

    pdbg(E_DBG1,"Software support for address families:\n");
    pdbg(E_DBG1," IPv4 = %s, IPv6 = %s, LOCAL=%s\n",
# ifdef PNET_HAVE_IPv4
	 "yes"
# else
	 "no"
# endif
	,
# ifdef PNET_HAVE_IPv6
	 "yes"
# else
	 "no"
# endif
	,
# ifdef PNET_HAVE_LOCAL
	 "yes"
# else
	 "no"
# endif
	);
    pdbg(E_DBG1,"Software support for socket types:\n");
    pdbg(E_DBG1," STREAM = %s, DGRAM = %s, RAW = %s\n",
# ifdef SOCK_STREAM
	 "yes"
# else
	 "no"
# endif
	,
# ifdef SOCK_DGRAM
	 "yes"
# else
	 "no"
# endif
	,
# ifdef SOCK_RAW
	 "yes"
# else
	 "no"
# endif
	);
    return 0;
}
/*----------------------------------------------------------------------*/
/* Initialize the library. 						*/
/*  1. Initialize logging environment.					*/
/*  2. Compute local time difference with UTC.				*/
/*  3. Get and log system info.						*/
/*  4. Try to open Windows socket DLLs.					*/
/*----------------------------------------------------------------------*/
int
pnetInit( void )
{
    int maj = 2;
    int min = 2;
    char *p;

    if ( pnetInitDone )
	return 0;

    (void) print_init();
    (void) sys_timediff();

    pdbg(E_MSG,"pnetInit(major=%d,minor=%d)\n",maj,min);

    pnetGetSystemInfo();
    pnetShowLibInfo();

# ifdef STDWin32

    if (wsa_init(maj,min))
    {
	pnetInitDone = 0;
	perr(E_FATAL,
	    "Cannot initialize socket DLL version %d.%d\n",maj,min);
	return -1;
    }
    pnetInitDone = 1;

    DBG(pdbg(E_MSG,"Socket DLL version %d.%d successfully initialized.\n",
	    maj,min));

# endif
    pnetInitDone = 1;

    /* 
     * Read various other env. variables here
     */
    if ( (p = sys_getenv( PNET_ENV_SCOPE_SEP )) && *p )
	pnet_ScopeSep = *p;
    XLOG( p );
    pdbg(E_DBG1,"Using IPv6 address scope separator of '%c'\n", pnet_ScopeSep);

    return 0;
}

void
pnetCleanup(void)
{
# ifdef STDWin32
    int err;

    DBG(pdbg(E_MSG,"pnetCleanup()\n"));

    err = WSACleanup();

    if (err == SOCKET_ERROR)
    {
	perr(E_WARN,"pnetCleanup(): WSACleanup() failed\n");
	perr(E_WARN,"pnetCleanup(): %d\n",WSAGetLastError());
	return;
    }
# else
    DBG(pdbg(E_MSG,"pnetCleanup()\n"));
# endif
}
