/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if HAVE_CTYPE_H
# include <ctype.h>
#endif
#if HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#if HAVE_NETDB_H
# include <netdb.h>
#endif
#if HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif

#include "str.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

long parse_port(const char *line, int *valid)
{
    long ret;
    char *err;
    ret = strtol(line, &err, 10);

    if (err == line) {
	if (valid) (*valid) = 0;
	return 0;
    }
    if (ret < 0 || ret > 0xFFFE) {
	if (valid) (*valid) = 0;
	return 0;
    }
    if (err[0] == '\0') {
	if (valid) (*valid) = 1;
	return ret;
    } else {
	if (valid) (*valid) = 0;
	return 0;
    }
}

unsigned long parse_ulong(const char *line, int *valid)
{
    unsigned long ret;
    char *err;
    ret = strtoul(line, &err, 10);
    
    if (err == line) {
	if (valid) (*valid) = 0;
	return 0;
    }
    if (err[0] == '\0') {
	if (valid) (*valid) = 1;
	return ret;
    } else {
	if (valid) (*valid) = 0;
	return 0;
    }
}

int yes_or_no(const char *line)
{
    if (tolower(line[0]) == 'n') {
	return 0;
    } else if (tolower(line[0]) == 'y') {
	return 1;
    } else {
#if HAVE_STRDUPA
	char *tmp = strdupa(line);
#else
	char *tmp;
	tmp = strdup(line);
#endif
	trim(tmp);
	if (tmp[0] == '\0') {
#if HAVE_STRDUPA
#else
	    free(tmp);
#endif
	    return -1;
	}
#if HAVE_STRDUPA
#else
        free(tmp);
#endif
    }
    
    return 2;
}

int set_yes_or_no(char *line, int *set)
{
    int loc_set;
    loc_set = yes_or_no(line);
    if (loc_set == 0 || loc_set == 1 || loc_set == -1) {    
	*set = loc_set;
	return 0;
    }
    return -1;
}

int check_interface(const char *_interface)
{
    struct in_addr addr;
    
    if (!_interface || !_interface[0])
	return 0;
    
    if (!inet_aton(_interface, &addr)) {
	struct hostent *host = gethostbyname(_interface);
	
	if (!host) 
	    return -1;
    }

    return 0;
}

int check_ip(const char *ip)
{
    return check_interface(ip);
}

int check_list(const char **list, size_t len)
{
    /* What exactly am I supposed to check here? */
    return 0;
}

int set_servers(const char *line, char ***hostname, uint16_t **port, 
		size_t *hosts)
{
    size_t h, len;
    int valid;
    char *pos, *end;
    unsigned long tmplong;
    if (*hostname) {
	for (h = 0; h < (*hosts); h++)
	    free((*hostname)[h]);
	free((*hostname));
	(*hostname) = NULL;
    }
    if (*port) {
	free((*port));
    }
    (*hosts) = split(line, " ", hostname, NULL);
    (*port) = NULL;
    if ((*hosts) == 0)
	return -1;
    (*port) = malloc(sizeof(uint16_t) * (*hosts));
    h = 0;
    while (h < (*hosts)) {
	valid = 1;
	len = strlen((*hostname)[h]);
	if (len == 0) {
	    valid = 0;
	} else {
	    if (!(pos = strchr((*hostname)[h], ':'))) {
		(*port)[h] = 21;
	    } else {
		tmplong = strtoul(pos + 1, &end, 10);
		if (!end || end[0] || tmplong == 0 || tmplong >= 0xFFFF) {
		    valid = 0;
		} else {
		    (*port)[h] = (uint16_t)tmplong;
		    pos[0] = '\0';
		}
	    }
	}

	if (!valid) {
	    free((*hostname)[h]);
	    (*hosts)--;
	    memmove((*hostname) + h, (*hostname) + h + 1,
		    ((*hosts) - h) * sizeof(char *));
	} else {
	    h++;
	}
    }
    if ((*hosts) == 0) {
	free((*hostname));
	free((*port));
	(*hostname) = NULL;
	(*port) = NULL;
	return -1;
    }
    return 0;
}

int split_conf_row(char *line, char **name, char **value)
{
    char *pos = strchr(line, '=');

    if (pos) {
	*pos = '\0';
	*name = line;
	*value = pos + 1;
	trim(*name);
	trim(*value);
	return 0;
    }

    return -1;
}

