/* -*- pftp-c -*- */
/*********************************************************************\
MODULE NAME:    b64.c
AUTHOR:         Bob Trower 08/04/01
PROJECT:        Crypt Data Packaging
COPYRIGHT:      Copyright (c) Trantor Standard Systems Inc., 2001

NOTE:           This source code may be used as you wish, subject to
                the MIT license.  See the LICENCE section below.

LICENCE:        Copyright (c) 2001 Bob Trower, Trantor Standard Systems Inc.

                Permission is hereby granted, free of charge, to any person
                obtaining a copy of this software and associated
                documentation files (the "Software"), to deal in the
                Software without restriction, including without limitation
                the rights to use, copy, modify, merge, publish, distribute,
                sublicense, and/or sell copies of the Software, and to
                permit persons to whom the Software is furnished to do so,
                subject to the following conditions:

                The above copyright notice and this permission notice shall
                be included in all copies or substantial portions of the
                Software.

                THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
                KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
                WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
                PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
                OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
                OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
                OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
                SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

VERSION HISTORY:
                Bob Trower 08/04/01 -- Create Version 0.00.00B
                Joel Klinghed 28/09/05 -- Modified it to match libpftputil needs

\******************************************************************* */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDIO_H
# include <stdio.h>
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif

/*
** Translation Table as described in RFC1113
*/
static const char cb64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*
** Translation Table to decode (created by author)
*/
static const char cd64[]="|$$$}rstuvwxyz{$$$$$$$>?@ABCDEFGHIJKLMNOPQRSTUVW$$$$$$XYZ[\\]^_`abcdefghijklmnopq";

/*
** encodeblock
**
** encode 3 8-bit binary bytes as 4 '6-bit' characters
*/
static __inline void _encodeblock(unsigned char in[3], unsigned char out[4], 
                  int len)
{
    out[0] = cb64[in[0] >> 2];
    out[1] = cb64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4)];
    out[2] = (unsigned char) (len > 1 ? cb64[((in[1] & 0x0f) << 2) 
                         | ((in[2] & 0xc0) >> 6)] : '=');
    out[3] = (unsigned char) (len > 2 ? cb64[in[2] & 0x3f] : '=');
}

/*
** encode
**
** base64 encode a stream adding padding and line breaks as per spec.
*/
void b64_encode(const char *in_data, size_t in_size, 
        char **out_data, size_t *out_size)
{
    unsigned char in[3], out[4];
    register int i, len;
    register size_t in_pos, out_pos;
    in_pos = out_pos = 0;
    if ((in_size % 3)) {
    *out_size = ((in_size + (3 - (in_size % 3))) / 3) * 4;
    } else {
    *out_size = (in_size / 3) * 4;
    }
    *out_data = realloc(*out_data, *out_size);
    
    while (in_pos < in_size) {
        len = 0;
        for (i = 0; i < 3; i++) {
        if (in_pos < in_size) {
        in[i] = (unsigned char) in_data[in_pos++];
                len++;
            } else {
                in[i] = 0;
            }
        }
        if (len) {
            _encodeblock(in, out, len);
            for (i = 0; i < 4; i++) {
        (*out_data)[out_pos++] = out[i];
            }
        }
    }
}

/*
** decodeblock
**
** decode 4 '6-bit' characters into 3 8-bit binary bytes
*/
static __inline void _decodeblock(unsigned char in[4], unsigned char out[3])
{   
    out[0] = (unsigned char) (in[0] << 2 | in[1] >> 4);
    out[1] = (unsigned char) (in[1] << 4 | in[2] >> 2);
    out[2] = (unsigned char) (((in[2] << 6) & 0xc0) | in[3]);
}

/*
** decode
**
** decode a base64 encoded stream discarding padding, line breaks and noise
*/
void b64_decode(const char *in_data, size_t in_size,
        char **out_data, size_t *out_size)
{
    unsigned char in[4], out[3], v;
    register int i, len;
    register size_t in_pos, out_pos;
    in_pos = out_pos = 0;
    *out_size = ((in_size / 4) + 1) * 3;
    *out_data = realloc(*out_data, *out_size);

    while (in_pos < in_size) {
        for (len = 0, i = 0; i < 4 && in_pos < in_size; i++ ) {
            v = 0;
            while (in_pos < in_size && v == 0) {
                v = (unsigned char) in_data[in_pos++];
                v = (unsigned char) ((v < 43 || v > 122) ? 0 : cd64[v - 43]);
                if (v) {
                    v = (unsigned char) ((v == '$') ? 0 : v - 61);
                }
            }
            if (in_pos < in_size) {
                len++;
                if (v) {
                    in[i] = (unsigned char) (v - 1);
                }
            } else {
                in[i] = 0;
            }
        }
        if (len) {
            _decodeblock(in, out);
            for (i = 0; i < len - 1; i++) {
                (*out_data)[out_pos++] = out[i];
            }
        }
    }

    *out_size = out_pos;
}
