/* -*- pftp-c -*- */
/* str.h - String helper functions */

#ifndef STR_H
#define STR_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

LIBPFTPUTIL_API char *realloc_strncat(char *str, const char *newstr, 
				      size_t len);
LIBPFTPUTIL_API char *realloc_strncpy(char *str, const char *newstr, 
				      size_t len);
LIBPFTPUTIL_API char *realloc_strcat(char *str, const char *newstr);
LIBPFTPUTIL_API char *realloc_strcpy(char *str, const char *newstr);
LIBPFTPUTIL_API char *alloc_strncpy(const char *newstr, size_t len);
LIBPFTPUTIL_API char *alloc_strcpy(const char *newstr);

LIBPFTPUTIL_API size_t split(const char *str, const char *needle, char ***part,
			     ...);
LIBPFTPUTIL_API void free_split(char ***part, size_t *parts);

LIBPFTPUTIL_API char *unsplit(const char **str, size_t str_count, 
			      const char *seporator);

LIBPFTPUTIL_API void unbackslash(char *str);

LIBPFTPUTIL_API int is_whitespace(char c);
LIBPFTPUTIL_API void trim_left(char *str);
LIBPFTPUTIL_API void trim_right(char *str);
LIBPFTPUTIL_API void trim(char *str);

LIBPFTPUTIL_API char *strtolower(char *str);
LIBPFTPUTIL_API char *strtoupper(char *str);

LIBPFTPUTIL_API char *alloc_strreplace(const char *body, const char *needle, 
				       const char *new);
LIBPFTPUTIL_API char *realloc_strreplace(char *str, const char *needle, 
					 const char *new);

#ifndef xisspace
#define xisspace(_c_) isspace((int)_c_)
#endif /* xisspace */

#ifndef xisdigit
#define xisdigit(_c_) isdigit((int)_c_)
#endif /* xisdigit */

#ifndef xisascii
#define xisascii(_c_) isascii((int)_c_)
#endif /* xisascii */

#ifndef xisalpha
#define xisalpha(_c_) isalpha((int)_c_)
#endif /* xisalpha */

#ifndef xislower
#define xislower(_c_) islower((int)_c_)
#endif /* xislower */

#ifndef xisupper
#define xisupper(_c_) isupper((int)_c_)
#endif /* xisupper */

#endif /* STR_H */
