/* -*- pftp-c -*- */

#ifndef PFTP_GETCONF_H
#define PFTP_GETCONF_H

#ifndef LIBPFTPUTIL_API
# ifdef WIN32
#  include "w32-libpftputil.h"
# else
#  define LIBPFTPUTIL_API 
# endif
#endif

#include <pftp_default.h>

LIBPFTPUTIL_API struct pftp_conf_s {
    pftp_default_t ftp;
    char *pager;
    unsigned long gui_width, gui_height, horzpan1, horzpan2;    
};

LIBPFTPUTIL_API typedef struct pftp_conf_s *pftp_conf_t;

LIBPFTPUTIL_API pftp_conf_t pftp_get_conf(void);
LIBPFTPUTIL_API void pftp_close_conf(void);
LIBPFTPUTIL_API void pftp_free_conf(pftp_conf_t conf);

#endif /* PFTP_GETCONF_H */
