/* -*- pftp-c -*- */
#ifndef PFTPUTIL_H
#define PFTPUTIL_H

#include <pftp_settings.h>
#include <pftp_default.h>
#include <pftp.h>
#include "pftp_item.h"
#include "pftputil_comm.h"
#include "pftp_getconf.h"

void pftp_initUtil(pftp_comm_centralFunc_t comm_central);
void pftp_freeUtil(void);

pftp_settings_t pftp_getFTPSettings(const char *ftpname);
pftp_server_t pftp_getFTPCtrl(const char *ftpname);
int pftp_getFTPConnected(const char *ftpname);
void pftp_closeFTPCtrl(const char *ftpname);
void pftp_createFTPSettings(const char *ftpname, const char *username,
			    const char *hostname, const char *passwd,
			    unsigned short port, int ssl);
pftp_default_t pftp_getDefaultSettings(void);
pftp_conf_t pftp_getConfig(void);
int pftp_saveFTPSettings(const char *orgname, const char *targetname);

size_t pftp_getFreeFTPID(void);

size_t pftp_getNrOfSettings(void);
pftp_settings_t pftp_getFTPSettings2(size_t id);

int pftp_makePath(const char *ftpname, const char *path);

#endif /* PFTPUTIL_H */
