/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif

#ifdef DEBUG
# include <assert.h>
#else
# define assert(x) // x
#endif

#include "pftp_utf8.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

/*
 * Please note. This ONLY make the string into UTF-8.
 * Codepage conversion to ISO-10646 isn't done.
 */

void pftp_make_unicode_utf8(char **str)
{
    register size_t pos;
    register unsigned char orig;
    size_t len;

    len = strlen(*str);

    pos = 0;

    while (pos < len) {
	if (((unsigned char)(*str)[pos]) < 0x80) {
	    pos++;
	} else {
	    orig = (*str)[pos];
	    (*str) = realloc((*str), (len + 2));
	    memmove((*str) + pos + 2, (*str) + pos + 1, len - pos);
	    len++;
	    (*str)[pos++] = (char)(0xC0 | ((orig & 0xC0) >> 6));
	    (*str)[pos++] = (char)(0x80 | ((orig & 0x3F)));	    
	}
    }
}

/* 
 * Please note. ONLY converts UTF-8 into Ascii. Doesn't convert ISO-10646
 * into anything.
 * Also, will crash on >255 char codes in UTF-8. !!!
 */

void pftp_parse_unicode_utf8(char *str)
{
    register size_t pos;
    register unsigned char orig;
    size_t len;
    
    assert(str);
    
    len = strlen(str);

    pos = 0;

    while (pos < len) {
	if (((unsigned char)str[pos]) < 0x80) {
	    pos++;
	} else {
	    orig = ((unsigned char)str[pos + 1]) & 0x3F;
	    orig |= ((unsigned char)str[pos] & 0x3) << 6;
	    str[pos] = (char)orig;
	    pos++;
	    memmove(str + pos, str + pos + 1, len - pos);
	    len--;
	}
    }
}
