/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif

#ifndef NO_SSL

#include <openssl/bn.h>

#include "pftp_ssh_packet.h"
#include "pftp_ssh_buf.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

struct pftp_ssh_pkt_s
{
    pftp_ssh_buf_t buf;
};

pftp_ssh_pkt_t pftp_ssh_create_pkt(unsigned char msg)
{
    pftp_ssh_pkt_t ret;

    ret = malloc(sizeof(struct pftp_ssh_pkt_s));
    memset(ret, 0, sizeof(struct pftp_ssh_pkt_s));

    ret->buf = pftp_ssh_create_buf();
    pftp_ssh_buf_put_char(ret->buf, msg);
    pftp_ssh_buf_seek(ret->buf, 1);
	
    return ret;
}

pftp_ssh_pkt_t pftp_ssh_load_pkt(const void *data, size_t size)
{
    pftp_ssh_pkt_t ret;
	
    ret = malloc(sizeof(struct pftp_ssh_pkt_s));
    memset(ret, 0, sizeof(struct pftp_ssh_pkt_s));
	
    ret->buf = pftp_ssh_create_buf();
    pftp_ssh_buf_put_raw(ret->buf, data, size);
    pftp_ssh_buf_seek(ret->buf, 1);
	
    return ret;
}

void pftp_ssh_pkt_free(pftp_ssh_pkt_t pkt)
{
    if (pkt) {
	pftp_ssh_buf_free(pkt->buf);
	free(pkt);
    }
}

/* Writing */

void pftp_ssh_pkt_put_string(pftp_ssh_pkt_t pkt, const char *str)
{
    pftp_ssh_pkt_put_string2(pkt, str, strlen(str));
}

void pftp_ssh_pkt_put_string2(pftp_ssh_pkt_t pkt, const char *str,
			      size_t len)
{
    pftp_ssh_buf_put_string2(pkt->buf, str, len);
}

void pftp_ssh_pkt_put_bignum(pftp_ssh_pkt_t pkt, const BIGNUM *num)
{
    pftp_ssh_buf_put_bignum(pkt->buf, num);
}

void pftp_ssh_pkt_put_raw(pftp_ssh_pkt_t pkt, const void *data, 
			  size_t size)
{
    pftp_ssh_buf_put_raw(pkt->buf, data, size);
}

void pftp_ssh_pkt_put_uint32(pftp_ssh_pkt_t pkt, uint32_t num)
{
    pftp_ssh_buf_put_uint32(pkt->buf, num);
}

void pftp_ssh_pkt_put_char(pftp_ssh_pkt_t pkt, char c)
{
    pftp_ssh_buf_put_char(pkt->buf, c);
}

/* Reading */

void pftp_ssh_pkt_reset(pftp_ssh_pkt_t pkt)
{
    pftp_ssh_buf_seek(pkt->buf, 1);
}

int pftp_ssh_pkt_msg(pftp_ssh_pkt_t pkt)
{
    int ret, valid;
    size_t old;
    old = pftp_ssh_buf_tell(pkt->buf);
    pftp_ssh_buf_seek(pkt->buf, 0);
    ret = pftp_ssh_buf_get_char(pkt->buf, &valid);
    pftp_ssh_buf_seek(pkt->buf, old);
    if (valid) {
	return ret;
    } else {
	return -1;
    }
}

char *pftp_ssh_pkt_get_string(pftp_ssh_pkt_t pkt)
{
    size_t len;
    return pftp_ssh_pkt_get_string2(pkt, &len);
}

char *pftp_ssh_pkt_get_string2(pftp_ssh_pkt_t pkt, size_t *len)
{
    return pftp_ssh_buf_get_string2(pkt->buf, len);
}

BIGNUM *pftp_ssh_pkt_get_bignum(pftp_ssh_pkt_t pkt)
{
    return pftp_ssh_buf_get_bignum(pkt->buf);
}

const char *pftp_ssh_pkt_get_raw(pftp_ssh_pkt_t pkt, size_t len)
{
    return pftp_ssh_buf_get_raw(pkt->buf, len);
}

char pftp_ssh_pkt_get_char(pftp_ssh_pkt_t pkt, int *valid)
{
    return pftp_ssh_buf_get_char(pkt->buf, valid);
}

uint32_t pftp_ssh_pkt_get_uint32(pftp_ssh_pkt_t pkt, int *valid)
{
    return pftp_ssh_buf_get_uint32(pkt->buf, valid);
}

const char *pftp_ssh_pkt_save(pftp_ssh_pkt_t pkt, size_t *size)
{
    *size = pftp_ssh_buf_size(pkt->buf);
    return pftp_ssh_buf_raw(pkt->buf);
}

size_t pftp_ssh_pkt_size(pftp_ssh_pkt_t pkt)
{
    return pftp_ssh_buf_size(pkt->buf);
}

#endif /* NO_SSL */
