/* -*- pftp-c -*- */
#ifndef PFTP_SSH_PACKET_H
#define PFTP_SSH_PACKET_H

typedef struct pftp_ssh_pkt_s *pftp_ssh_pkt_t;

pftp_ssh_pkt_t pftp_ssh_create_pkt(unsigned char msg);
pftp_ssh_pkt_t pftp_ssh_load_pkt(const void *data, size_t size);
void pftp_ssh_pkt_free(pftp_ssh_pkt_t pkt);

/* Writing */

void pftp_ssh_pkt_put_string(pftp_ssh_pkt_t pkt, const char *str);
void pftp_ssh_pkt_put_string2(pftp_ssh_pkt_t pkt, const char *str, size_t len);
void pftp_ssh_pkt_put_bignum(pftp_ssh_pkt_t pkt, const BIGNUM *num);
void pftp_ssh_pkt_put_raw(pftp_ssh_pkt_t pkt, const void *data, size_t size);
void pftp_ssh_pkt_put_uint32(pftp_ssh_pkt_t pkt, uint32_t num);
void pftp_ssh_pkt_put_char(pftp_ssh_pkt_t pkt, char c);

/* Reading */

int pftp_ssh_pkt_msg(pftp_ssh_pkt_t pkt);
char *pftp_ssh_pkt_get_string(pftp_ssh_pkt_t pkt);
char *pftp_ssh_pkt_get_string2(pftp_ssh_pkt_t pkt, size_t *len);
BIGNUM *pftp_ssh_pkt_get_bignum(pftp_ssh_pkt_t pkt);
const char *pftp_ssh_pkt_get_raw(pftp_ssh_pkt_t pkt, size_t len);
char pftp_ssh_pkt_get_char(pftp_ssh_pkt_t pkt, int *valid);
uint32_t pftp_ssh_pkt_get_uint32(pftp_ssh_pkt_t pkt, int *valid);

size_t pftp_ssh_pkt_size(pftp_ssh_pkt_t pkt);
void pftp_ssh_pkt_reset(pftp_ssh_pkt_t pkt);
const char *pftp_ssh_pkt_save(pftp_ssh_pkt_t pkt, size_t *size);

#endif /* PFTP_SSH_PACKET_H */
