/* -*- pftp-c -*- */
#ifndef HAVE_PFTP_INTERNAL_H
#define HAVE_PFTP_INTERNAL_H

typedef enum { DOWNLOAD = 0, UPLOAD, 
	       PORT_CONN, CONNECT, SSL_HANDSHAKE } wait_mode_t;

typedef ssize_t (*RecvFunc_t)(pftp_server_t ftp, socket_t socket, void *buffer, 
			      size_t size);
typedef ssize_t (*SendFunc_t)(pftp_server_t ftp, socket_t socket, 
			      const void *buffer, size_t size);

typedef enum { UNIX = 0, DOS } system_t;

#define DEFAULT_TIMEOUT (100000L)

struct pftp_server_s {
    // sockets
    socket_t cmdstream, datastream, port_socket;
    // buffer
    char *inbuffer;
    size_t inbuffer_len;
    // capabilities
    int resume, cur_binary, binary, abort, tls, site, help, cdup, hidden_ls;
    int pasv, pret;
    int chmod, mdtm;
    // used with speed (or will be used with speed)
    size_t lastgoodbuffersize;
    // data for waiting
    wait_mode_t waitmode;
    time_t lastdata;
    
#ifndef NO_SSL
    SSL *cmdssl, *datassl;
    int ssl_private;
    pftp_sftp_t sftp;
#endif /* NO_SSL */
    
    // used to beable to switch between secure and insecure transfers
    RecvFunc_t cmdRecv, dataRecv;
    SendFunc_t cmdSend, dataSend;

    // buffer for crc calc
    uint32_t cur_crc;
    
    // is it a unix or?
    system_t system;

    // directory cache
    char *cur_path;
    pftp_directory_t *cache_dir;
    char **cache_path;
    size_t cached;

    pftp_comm_centralFunc_t comm_central;
    pftp_settings_t settings;
};

/* Helper function for data transfers (makes timeout and cancel work) */
void pftp_start_wait(pftp_server_t ftp, wait_mode_t mode, intptr_t trans);
/* Helper function for data transfers (makes timeout and cancel work) */
int pftp_do_wait(pftp_server_t ftp, speed_data_t speed, int gotdata, 
		 const char *op);
/* Helper function for data transfers (makes timeout and cancel work) */
void pftp_end_wait(pftp_server_t ftp, wait_mode_t mode, intptr_t error);

/* Format a message sent to client using statusMsgFunc */
void pftp_status_message(pftp_server_t ftp, const char *format, ...);

/* Tell client that next statusmsg is not fatal. */
void pftp_next_status_not_fatal(pftp_server_t ftp);

/* Ask client for username &/ password. */
int pftp_userauth(pftp_server_t ftp, char **username, char **password);

/* Send client info about coming transfer */
void pftp_status_filetransfer(pftp_server_t ftp, uint64_t resume_from,
			      uint64_t total_size);

#endif /* HAVE_PFTP_INTERNAL_H */
