/* -*- pftp-c -*- */
#ifndef PFTP_DIRECTORY_H
#define PFTP_DIRECTORY_H

#ifndef LIBPFTP_API
# ifdef WIN32
#  include "w32-libpftp.h"
# else
#  define LIBPFTP_API 
# endif
#endif

LIBPFTP_API typedef enum {
    pft_directory,
    pft_door,
    pft_block,
    pft_character,
    pft_fifo,
    pft_s_socket,
    pft_file,
    pft_unknown
} pftp_file_type_t;

LIBPFTP_API typedef struct {
    pftp_file_type_t type;
    unsigned short perm;
    unsigned long links;
    char *user;
    int link;
    char *group;
    uint64_t size;
    char *changed;
    char *name;
} pftp_file_t;

LIBPFTP_API typedef struct {
    pftp_file_t *files;
    size_t length;
} pftp_directory_t;

#include "pftp.h"

LIBPFTP_API pftp_directory_t pftp_dir_parse(const char *ls_output, 
					    pftp_server_t ftp, 
					    int sys_unix);
LIBPFTP_API void pftp_cpy_dir(pftp_directory_t *dest, 
			      const pftp_directory_t *src);
LIBPFTP_API void pftp_free_fft(pftp_file_t fft);
LIBPFTP_API void pftp_free_fdt(pftp_directory_t fdt);
LIBPFTP_API void pftp_get_fft_date(const pftp_file_t *fft, struct tm *date);
LIBPFTP_API void pftp_get_date(const char *changed, struct tm *date);
/* Stringbuffer must be atleast 13 characters big */
LIBPFTP_API void pftp_set_date(char *changed, const struct tm *date);

#endif /* PFTP_DIRECTORY_H */
