/* -*- pftpc -*- */
#ifndef PFTP_COMM_H
#define PFTP_COMM_H

typedef unsigned int pftp_msg_t;
typedef void * pftp_param_t;

typedef int (* pftp_comm_centralFunc_t)(pftp_msg_t msg, pftp_server_t ftp, 
					void *userdata,
					pftp_param_t param1, 
					pftp_param_t param2);

#define PFTP_BASE   0x100
#define PFTPUTIL_BASE  0x200
#define PFTPCLI_BASE   0x500

#define PFTP_STATUS (PFTP_BASE+0x001)
/* Ignores return value.
   param1: (const char *) ftpname (short for ftp->settings->name)
   param2: (const char *) msg
*/
#define PFTP_NEEDPASS (PFTP_BASE+0x002)
/* Return: 0 => cancel login, !0 => got info
   param1: (char **) username, NULL if it's not needed
   param2: (char **) password, NULL if it's not needed
*/
#define PFTP_NEEDPORT (PFTP_BASE+0x003)
/* Ignores return value.
   param1: (uint16_t *) port, set to port libftp should open for PORT 
   param2: (const pftp_settings_t) ftp->settings
*/
#define PFTP_INITTRANSFER (PFTP_BASE+0x004)
/* Ignores return value.
   param1: (int)what, 0 = DONT SHOW, 1 = DOWNLOAD, 2 = UPLOAD, 3 = TIMEOUT
   param2: NULL
*/
#define PFTP_FILETRANSFER (PFTP_BASE+0x005)
/* Ignores return value.
   param1: (const uint64_t *) start
   param2: (const uint64_t *) size
   (Is sent before INITTRANSFER)
*/
#define PFTP_TRANSFER (PFTP_BASE+0x006)
/* Return: 0 => cancel transfer now. !0 => continue
   param1: (const double *) current speed (NULL if it's a timeout)
   param2: (const float *) current percent (NULL if it's not known)
*/
#define PFTP_DONETRANSFER (PFTP_BASE+0x007)
/* Ignores return value.
   param1: (int) error, 0 => OK, 1 => Error
   param2: NULL
*/
#define PFTP_DISCONNECTED (PFTP_BASE+0x008)
/* Ignores return value.
   This is sent if cmd stream is closed unexpectedly, so it isn't send after a
   logout...
   param1: NULL
   param2: NULL
*/

#endif /* PFTP_COMM_H */
