
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_STRUCTS_TYPE_REGEX_H_
#define _PDEL_STRUCTS_TYPE_REGEX_H_

/*********************************************************************
			REGULAR EXPRESSION TYPE
*********************************************************************/

/*
 * Support for regular expressions (see regex(3)).
 *
 * The data is a "struct structs_regex". The "reg" argument is compiled
 * and filled in automatically.
 */

struct structs_regex {
	const char	*pat;			/* ascii pattern */
	regex_t		reg;			/* compiled pattern */
};

__BEGIN_DECLS

extern structs_equal_t		structs_regex_equal;
extern structs_ascify_t		structs_regex_ascify;
extern structs_binify_t		structs_regex_binify;
extern structs_uninit_t		structs_regex_free;

__END_DECLS

/*
 * Macro arguments:
 *	[const char *]		Memory allocation type for byte buffer
 *	[int]			"cflags" argument to regcomp(3)
 */
#define STRUCTS_REGEX_TYPE(mtype, flags) {				\
	sizeof(struct structs_regex),					\
	"regex",							\
	STRUCTS_TYPE_PRIMITIVE,						\
	structs_region_init,						\
	structs_ascii_copy,						\
	structs_regex_equal,						\
	structs_regex_ascify,						\
	structs_regex_binify,						\
	structs_string_encode,						\
	structs_string_decode,						\
	structs_regex_free,						\
	{ { (void *)(mtype) }, { (void *)(flags) }, { NULL } }		\
}

#define STRUCTS_REGEX_MTYPE	"structs_regex"

__BEGIN_DECLS

/* Regex with mtype STRUCTS_REGEX_MTYPE and flags REG_EXTENDED */
extern const struct structs_type	structs_type_regex;

/* Regex with mtype STRUCTS_REGEX_MTYPE and flags REG_EXTENDED | REG_ICASE */
extern const struct structs_type	structs_type_regex_icase;

__END_DECLS

#endif	/* _PDEL_STRUCTS_TYPE_REGEX_H_ */

