
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include "ppp/ppp_defs.h"
#include "ppp/ppp_channel.h"

void
ppp_channel_open(struct ppp_channel *chan)
{
	if (chan->meth->open != NULL)
		(*chan->meth->open)(chan);
}

void
ppp_channel_close(struct ppp_channel *chan)
{
	if (chan->meth->close != NULL)
		(*chan->meth->close)(chan);
}

void
ppp_channel_destroy(struct ppp_channel **chanp)
{
	struct ppp_channel *chan = *chanp;

	if (chan == NULL)
		return;
	*chanp = NULL;
	(*chan->meth->destroy)(&chan);
}

struct mesg_port *
ppp_channel_get_outport(struct ppp_channel *chan)
{
	return (chan->outport);
}

void
ppp_channel_free_output(struct ppp_channel *chan,
	struct ppp_channel_output *output)
{
	(*chan->meth->free_output)(chan, output);
}

void
ppp_channel_set_link_info(struct ppp_channel *chan, u_int32_t accm)
{
	if (chan->meth->set_link_info != NULL)
		(*chan->meth->set_link_info)(chan, accm);
}

int
ppp_channel_get_origination(struct ppp_channel *chan)
{
	return ((*chan->meth->get_origination)(chan));
}

const char *
ppp_channel_get_node(struct ppp_channel *chan)
{
	if (chan->meth->get_node == NULL)
		return (NULL);
	return ((*chan->meth->get_node)(chan));
}

const char *
ppp_channel_get_hook(struct ppp_channel *chan)
{
	if (chan->meth->get_hook == NULL)
		return (NULL);
	return ((*chan->meth->get_hook)(chan));
}

int
ppp_channel_is_async(struct ppp_channel *chan)
{
	if (chan->meth->is_async == NULL)
		return (0);
	return ((*chan->meth->is_async)(chan));
}

u_int
ppp_channel_get_mtu(struct ppp_channel *chan)
{
	if (chan->meth->get_mtu == NULL)
		return (0);
	return ((*chan->meth->get_mtu)(chan));
}

int
ppp_channel_get_acfcomp(struct ppp_channel *chan)
{
	if (chan->meth->get_acfcomp == NULL)
		return (0);
	return ((*chan->meth->get_acfcomp)(chan));
}

int
ppp_channel_get_pfcomp(struct ppp_channel *chan)
{
	if (chan->meth->get_pfcomp == NULL)
		return (0);
	return ((*chan->meth->get_pfcomp)(chan));
}


