
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#ifndef _PDEL_HTTP_SERVLET_XMLRPC_H_
#define _PDEL_HTTP_SERVLET_XMLRPC_H_

struct http_servlet_xmlrpc_method;
struct http_servlet_xmlrpc_servlet_info;
struct http_request;
struct structs_type;

/*
 * User-supplied handler for http_servlet_xmlrpc. Should return the
 * reply structure (and set *rtypep to its type) if successful.
 *
 * If a fault is to be returned, return a "struct structs_xmlrpc_fault",
 * set *typep to &structs_type_xmlrpc_fault, and set *fault to non-zero.
 *
 * If a system error is to be returned, return NULL and set errno.
 *
 * Parameters
 *
 *	arg		User-supplied cookie
 *	method		Name of XML-RPC method
 *	req		Incoming HTTP request structure (do not free)
 *	nparams		Number of parameters
 *	params		Parameters
 *	mtype		Memory type for allocating response
 *	rtypep		Upon return, response type or NULL for xmlrpc_value
 *	fault		Set *fault to non-zero if returning a fault
 */
typedef void	*http_servlet_xmlrpc_handler_t(void *arg, const char *method,
			struct http_request *req, u_int nparams,
			const void **params, const char *mtype,
			const struct structs_type **rtypep, int *fault);

/*
 * Information required by for one XML-RPC method.
 *
 *	name		Name of XML-RPC method, or empty string for wildcard
 *	handler		Handler function for method
 *	ptypes		Parameter types, or NULL for xmlrpc_value
 *	min_params	Minimum number of parameters accepted
 *	max_params	Maximum number of parameters accepted
 */
struct http_servlet_xmlrpc_method {
	const char      		*name;		/* method name */
	http_servlet_xmlrpc_handler_t	*handler;	/* method handler */
	const struct structs_type	**ptypes;	/* parameter types */
	u_int             		min_params;	/* min # params */
	u_int             		max_params;	/* max # params */
};

/*
 * Information required by http_servlet_xmlrpc().
 *
 *	method		List of acceptable methods
 *	logger		Logging function
 */
struct http_servlet_xmlrpc_info {
	const struct http_servlet_xmlrpc_method
					*methods;	/* methods (NULL trm)*/
	http_logger_t			*logger;	/* loggging function */
};

__BEGIN_DECLS

/*
 * Create a new http_servlet_xmlrpc servlet.
 *
 * NOTE: "info" is not copied and so must remain valid for the
 * lifetime of the servlet.
 */
extern struct	http_servlet *http_servlet_xmlrpc_create(
			const struct http_servlet_xmlrpc_info *info,
			void *arg, void (*destroy)(void *));

__END_DECLS

#endif	/* _PDEL_HTTP_SERVLET_XMLRPC_H_ */

