
/*
 * Copyright (c) 2001-2002 Packet Design, LLC.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty,
 * use and redistribution of this software, in source or object code
 * forms, with or without modifications are expressly permitted by
 * Packet Design; provided, however, that:
 * 
 *    (i)  Any and all reproductions of the source or object code
 *         must include the copyright notice above and the following
 *         disclaimer of warranties; and
 *    (ii) No rights are granted, in any manner or form, to use
 *         Packet Design trademarks, including the mark "PACKET DESIGN"
 *         on advertising, endorsements, or otherwise except as such
 *         appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY PACKET DESIGN "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, PACKET DESIGN MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING
 * THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.  PACKET DESIGN DOES NOT WARRANT, GUARANTEE,
 * OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS
 * OF THE USE OF THIS SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY,
 * RELIABILITY OR OTHERWISE.  IN NO EVENT SHALL PACKET DESIGN BE
 * LIABLE FOR ANY DAMAGES RESULTING FROM OR ARISING OUT OF ANY USE
 * OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE, OR CONSEQUENTIAL
 * DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF
 * USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF PACKET DESIGN IS ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 */

#include <sys/types.h>

#include <netinet/in.h>

#include <stdio.h>
#include <assert.h>
#include <syslog.h>
#include <unistd.h>
#include <stdarg.h>

#include "structs/structs.h"
#include "structs/type/array.h"
#include "util/typed_mem.h"
#include "config/app_config.h"
#include "sys/alog.h"

/************************************************************************
			CURCONF SUBSYSTEM
************************************************************************/

static app_ss_startup_t		app_curconf_start;
static app_ss_shutdown_t	app_curconf_shutdown;
static app_ss_changed_t		app_curconf_changed;

const struct app_subsystem	app_config_curconf_subsystem = {
	"curconf",
	NULL,
	app_curconf_start,
	app_curconf_shutdown,
	NULL,
	app_curconf_changed,
	NULL
};

static int
app_curconf_start(struct app_config_ctx *ctx,
	const struct app_subsystem *ss, const void *config)
{
	const void **const curconfp = ss->arg;

	/* Copy configuration and store it in 'curconf' */
	if ((*curconfp = app_config_copy(ctx, config)) == NULL) {
		alog(LOG_ERR, "%s: failed to copy config: %m", __FUNCTION__);
		return (-1);
	}
	return (0);
}

static void
app_curconf_shutdown(struct app_config_ctx *ctx,
	const struct app_subsystem *ss, const void *config)
{
	const void **const curconfp = ss->arg;

	/* Free and NULL-ify 'curconf' */
	app_config_free(ctx, (void **)curconfp);
}

static int
app_curconf_changed(struct app_config_ctx *ctx,
	const struct app_subsystem *ss, const void *config1,
	const void *config2)
{
	return (1);
}

