#include <stdio.h>
#include <libnd.h>

#define PACKET_SIZE_LIMIT         100

gboolean
filter_length(LND_Filter *filter, LND_Packet *packet, void *filter_data)
{
  return (packet->ph.len <= PACKET_SIZE_LIMIT) ? TRUE : FALSE;
  TOUCH(filter);
  TOUCH(filter_data);
}

int
main(int argn, char **argv)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  LND_Filter         *filter;

  if (argn < 2)
    {
      printf("USAGE: lnd-test-filer <trace file>\n"
	     "lnd-test-filter is an example of a custom filter instantiation.\n"
	     "It employs a filter that only allows packets of at most 100 bytes.\n");
      exit(-1);
    }
    
  libnd_init();

  /* Open a tracefile: */
  if (! (trace = libnd_trace_new(argv[1])))
    {
      printf("Could not open %s\n", argv[1]);
      exit(-1);
    }
        
  if (! (filter = libnd_filter_new("size filter",
				   NULL, /* no initialization needed */
				   filter_length,
				   NULL, /* no cleanup needed */
				   NULL, /* no state, so no state cleanup needed */
				   NULL))) /* no statekeeping needed */
    {
      /* Didn't work -- appropriate error handling. */
    }
  
  libnd_trace_add_filter(trace, filter);
  
  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    printf("Packet with header length %i passed the filter\n", libnd_pit_get(&pit)->ph.len);

  return 0;
}

        


