#include <stdio.h>
#include <libnd.h>

int
main(int argn, char **argv)
{
  LND_Trace          *trace;
  LND_PacketIterator  pit;
  LND_Packet         *packet;
  char line[4096];
  off_t offset;

  if (argn < 2)
    {
      printf("USAGE: lnd-dump <trace file>\n"
	     "lnd-dump reads a tcpdump trace file and prints for each packet\n"
	     " - the file pointer offset\n"
	     " - the file pointer offset relative to end of pcap file header\n"
	     " - timestamp of the packet in plain numbers\n"
	     " - the first line of tcpdump output for that packet.\n");
      exit(0);	     
    }

  libnd_init();

  /* Open a tracefile: */
  if (! (trace = libnd_trace_new(argv[1])))
    {
      printf("Could not open %s\n", argv[1]);
      exit(-1);
    }
        
  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      packet = libnd_pit_get(&pit);

      offset = pcapnav_get_offset(trace->tpm->current->pcn);

      if (! libnd_tcpdump_get_packet_line(packet, line, 4096, FALSE))
	break;
      
      printf("%lu (%lu) %lu.%lu %s\n", offset, offset - sizeof(struct pcap_file_header),
	     (long unsigned) packet->ph.ts.tv_sec,
	     (long unsigned) packet->ph.ts.tv_usec,
	     line);
    }

  return 0;
}

        


