/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __libnd_icmp_h
#define __libnd_icmp_h

#include <libnd.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#ifdef BSD_HOST
#define ICMP_DEST_UNREACH    ICMP_UNREACH
#define ICMP_SOURCE_QUENCH   ICMP_SOURCEQUENCH
#define ICMP_TIME_EXCEEDED   ICMP_TIMXCEED
#define ICMP_PARAMETERPROB   ICMP_PARAMPROB
#define ICMP_TIMESTAMP       ICMP_TSTAMP
#define ICMP_TIMESTAMPREPLY  ICMP_TSTAMPREPLY
#define ICMP_INFO_REQUEST    ICMP_IREQ
#define ICMP_INFO_REPLY      ICMP_IREQREPLY
#define ICMP_ADDRESS         ICMP_MASKREQ
#define ICMP_ADDRESSREPLY    ICMP_MASKREPLY

#define ICMP_HOST_UNREACH    ICMP_UNREACH_HOST
#define ICMP_NET_UNREACH     ICMP_UNREACH_NET
#define ICMP_PROT_UNREACH    ICMP_UNREACH_PROTOCOL
#define ICMP_PORT_UNREACH    ICMP_UNREACH_PORT
#define ICMP_FRAG_NEEDED     ICMP_UNREACH_NEEDFRAG
#define ICMP_SR_FAILED       ICMP_UNREACH_SRCFAIL
#define ICMP_NET_UNKNOWN     ICMP_UNREACH_NET_UNKNOWN
#define ICMP_HOST_UNKNOWN    ICMP_UNREACH_HOST_UNKNOWN
#define ICMP_HOST_ISOLATED   ICMP_UNREACH_ISOLATED
#define ICMP_NET_ANO         ICMP_UNREACH_NET_PROHIB
#define ICMP_HOST_ANO        ICMP_UNREACH_HOST_PROHIB
#define ICMP_NET_UNR_TOS     ICMP_UNREACH_TOSNET
#define ICMP_HOST_UNR_TOS    ICMP_UNREACH_TOSHOST
#define ICMP_PKT_FILTERED    ICMP_UNREACH_FILTER_PROHIB
#define ICMP_PREC_VIOLATION  ICMP_UNREACH_HOST_PRECEDENCE
#define ICMP_PREC_CUTOFF     ICMP_UNREACH_PRECEDENCE_CUTOFF

#define ICMP_REDIR_NET       ICMP_REDIRECT_NET
#define ICMP_REDIR_HOST      ICMP_REDIRECT_HOST
#define ICMP_REDIR_NETTOS    ICMP_REDIRECT_TOSNET
#define ICMP_REDIR_HOSTTOS   ICMP_REDIRECT_TOSHOST

#define ICMP_EXC_TTL         ICMP_TIMXCEED_INTRANS
#define ICMP_EXC_FRAGTIME    ICMP_TIMXCEED_REASS
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* These are the implementations of LND_Protocol's callbacks: */
guchar      *libnd_icmp_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean     libnd_icmp_header_complete(const LND_Packet *packet, guint nesting);
gboolean     libnd_icmp_fix_packet(LND_Packet *packet);

gboolean     libnd_icmp_message_complete(const LND_Packet *packet);

/* ICMP checksum functions */
guint16      libnd_icmp_checksum(const LND_Packet *packet);
gboolean     libnd_icmp_csum_correct(const LND_Packet *packet, guint16 *correct_sum);

/* Test if this is an icmp error message: */
gboolean     libnd_icmp_header_is_error(struct icmp *icmphdr);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *libnd_icmp_get(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
