/*
 * Copyright 2024 Aon Cyber Solutions
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <catch2/catch_test_macros.hpp>

#include <iostream>

#include "container_out.h"
#include "encoders/ascii.h"
#include "encoders/oceencoder.h"

TEST_CASE("testOCEEncoderASCIIName") {
  OCEEncoder enc{ASCII()};
  REQUIRE("ASCII|OCE" == enc.name());
}

TEST_CASE("testOCEEncoderWriteSingleASCII") {
  OCEEncoder enc{ASCII()};
  REQUIRE(1u == enc.maxByteLength());

  byte buf[1];
  uint32_t len;

  // too low
  REQUIRE(0u == enc.write(-1, buf));

  // just right
  for (uint32_t i = 0; i < 0x80; ++i) {
    len = enc.write(i, buf);
    REQUIRE(1u == len);
    REQUIRE(OCEEncoder::OCE[i] == buf[0]);
  }

  // too high
  REQUIRE(0u == enc.write(0x80, buf));
}

TEST_CASE("testOCEEncoderWriteSetASCII") {
  OCEEncoder enc{ASCII()};

  const std::vector<std::vector<ByteSet>> expected{
    {
      {
        0x41, 0x36, 0x13, 0x62, 0xA8, 0x21, 0x6E, 0xBB,
        0xF4, 0x16, 0xCC, 0x04, 0x7F, 0x64, 0xE8, 0x5D,
        0x1E, 0xF2, 0xCB, 0x2A, 0x74, 0xC5, 0x5E, 0x35,
        0xD2, 0x95, 0x47, 0x9E, 0x96, 0x2D, 0x9A, 0x88,
        0x4C, 0x7D, 0x84, 0x3F, 0xDB, 0xAC, 0x31, 0xB6,
        0x48, 0x5F, 0xF6, 0xC4, 0xD8, 0x39, 0x8B, 0xE7,
        0x23, 0x3B, 0x38, 0x8E, 0xC8, 0xC1, 0xDF, 0x25,
        0xB1, 0x20, 0xA5, 0x46, 0x60, 0x4E, 0x9C, 0xFB,
        0xAA, 0xD3, 0x56, 0x51, 0x45, 0x7C, 0x55, 0x00,
        0x07, 0xC9, 0x2B, 0x9D, 0x85, 0x9B, 0x09, 0xA0,
        0x8F, 0xAD, 0xB3, 0x0F, 0x63, 0xAB, 0x89, 0x4B,
        0xD7, 0xA7, 0x15, 0x5A, 0x71, 0x66, 0x42, 0xBF,
        0x26, 0x4A, 0x6B, 0x98, 0xFA, 0xEA, 0x77, 0x53,
        0xB2, 0x70, 0x05, 0x2C, 0xFD, 0x59, 0x3A, 0x86,
        0x7E, 0xCE, 0x06, 0xEB, 0x82, 0x78, 0x57, 0xC7,
        0x8D, 0x43, 0xAF, 0xB4, 0x1C, 0xD4, 0x5B, 0xCD
      }
    }
  };

  const UnicodeSet us{{0,0x80}};
  std::vector<std::vector<ByteSet>> actual;
  enc.write(us, actual);

  REQUIRE(expected == actual);
}
