dnl
dnl Checks endianess
dnl
dnl usage:
dnl
dnl     AC_LIBIPGEO_ENDIAN_CHECK
dnl
dnl results:
dnl
dnl     LIBIPGEO_BIG_ENDIAN = 1   or
dnl     LIBIPGEO_LIL_ENDIAN = 1
dnl

AC_DEFUN(AC_LIBIPGEO_ENDIAN_CHECK,
    [AC_MSG_CHECKING(machine endianess)

    cat > conftest.c << EOF
#       include <stdio.h>
#       include <stdlib.h>

        int main()
        {
            union
            {
                short s;
                char c[[sizeof(short)]];
            } un;

            un.s = 0x0102;
            if (sizeof (short) == 2)
            {
                if (un.c [[0]] == 1 && un.c [[1]] == 2)
                {
                    printf("B\n");
                }
                else
                {
                    if (un.c [[0]] == 2 && un.c [[1]] == 1)
                    {
                        printf("L\n");
                    }
                }
            }
            else
            {
                printf("?\n");
            }
            return (EXIT_SUCCESS);
        }
EOF
        ${CC-cc} -o conftest $CFLAGS $CPPFLAGS $LDFLAGS conftest.c $LIBS > /dev/null 2>&1
        # Oopz 4.3 BSD doesn't have this.  Sorry.
        if test ! -x conftest ; then
dnl failed to compile for some reason
            ac_cv_libipgeo_endianess=unknown
        else
            ./conftest > conftest.out
            result=`cat conftest.out`
            if test $result = "B"; then
                ac_cv_libipgeo_endianess=big
            elif test $result = "L"; then
                ac_cv_libipgeo_endianess=lil
            else
                ac_cv_libipgeo_endianess=unknown
            fi                                
        fi
        rm -f conftest* core core.conftest

        AC_MSG_RESULT($ac_cv_libipgeo_endianess)

        if test $ac_cv_libipgeo_endianess = big ; then
            AC_DEFINE(LIBIPGEO_BIG_ENDIAN, 1,
                [We are running on a big-endian machine.])
           ENDIANESS="LIBIPGEO_BIG_ENDIAN"
            LIBIPGEO_CONFIG_DEFINES="$LIBIPGEO_CONFIG_DEFINES -DLIBIPGEO_BIG_ENDIAN"
        elif test $ac_cv_libipgeo_endianess = lil ; then
            AC_DEFINE(LIBIPGEO_LIL_ENDIAN, 1,
                [We are running on a little-endian machine.])
            ENDIANESS="LIBIPGEO_LIL_ENDIAN"
            LIBIPGEO_CONFIG_DEFINES="$LIBIPGEO_CONFIG_DEFINES -DLIBIPGEO_LIL_ENDIAN"
        fi
    ])
