// -*- c++ -*-
// Generated by gmmproc 2.38.1 -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CONNECTIONEVENT_H
#define _LIBGDAMM_CONNECTIONEVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: connectionevent.hg,v 1.2 2006/06/11 08:12:29 murrayc Exp $ */
// -*- C++ -*- //

/* connectionevent.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgda/gda-connection-event.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaConnectionEvent GdaConnectionEvent;
typedef struct _GdaConnectionEventClass GdaConnectionEventClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class ConnectionEvent_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/** 
 * 
 * @ingroup libgdammEnums
 */
enum ConnectionEventCode
{
  CONNECTION_EVENT_CODE_CONSTRAINT_VIOLATION,
  CONNECTION_EVENT_CODE_RESTRICT_VIOLATION,
  CONNECTION_EVENT_CODE_NOT_NULL_VIOLATION,
  CONNECTION_EVENT_CODE_FOREIGN_KEY_VIOLATION,
  CONNECTION_EVENT_CODE_UNIQUE_VIOLATION,
  CONNECTION_EVENT_CODE_CHECK_VIOLATION,
  CONNECTION_EVENT_CODE_INSUFFICIENT_PRIVILEGES,
  CONNECTION_EVENT_CODE_UNDEFINED_COLUMN,
  CONNECTION_EVENT_CODE_UNDEFINED_FUNCTION,
  CONNECTION_EVENT_CODE_UNDEFINED_TABLE,
  CONNECTION_EVENT_CODE_DUPLICATE_COLUMN,
  CONNECTION_EVENT_CODE_DUPLICATE_DATABASE,
  CONNECTION_EVENT_CODE_DUPLICATE_FUNCTION,
  CONNECTION_EVENT_CODE_DUPLICATE_SCHEMA,
  CONNECTION_EVENT_CODE_DUPLICATE_TABLE,
  CONNECTION_EVENT_CODE_DUPLICATE_ALIAS,
  CONNECTION_EVENT_CODE_DUPLICATE_OBJECT,
  CONNECTION_EVENT_CODE_SYNTAX_ERROR,
  CONNECTION_EVENT_CODE_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionEventCode> : public Glib::Value_Enum<Gnome::Gda::ConnectionEventCode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/** 
 * 
 * @ingroup libgdammEnums
 */
enum ConnectionEventType
{
  CONNECTION_EVENT_NOTICE,
  CONNECTION_EVENT_WARNING,
  CONNECTION_EVENT_ERROR,
  CONNECTION_EVENT_COMMAND
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionEventType> : public Glib::Value_Enum<Gnome::Gda::ConnectionEventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Any event which has occurred on a Gda::Connection.
 * Events occuring on a connection are each represented as a ConnectionEvent object. 
 * Each Connection is responsible for keeping a list of past events; that list can be consulted using the Connection::get_events() function.
 *
 * @ingroup Connections
 */

class ConnectionEvent : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ConnectionEvent CppObjectType;
  typedef ConnectionEvent_Class CppClassType;
  typedef GdaConnectionEvent BaseObjectType;
  typedef GdaConnectionEventClass BaseClassType;

private:  friend class ConnectionEvent_Class;
  static CppClassType connectionevent_class_;

private:
  // noncopyable
  ConnectionEvent(const ConnectionEvent&);
  ConnectionEvent& operator=(const ConnectionEvent&);

protected:
  explicit ConnectionEvent(const Glib::ConstructParams& construct_params);
  explicit ConnectionEvent(GdaConnectionEvent* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ConnectionEvent();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaConnectionEvent*       gobj()       { return reinterpret_cast<GdaConnectionEvent*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaConnectionEvent* gobj() const { return reinterpret_cast<GdaConnectionEvent*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaConnectionEvent* gobj_copy();

private:

  
protected:

 ConnectionEvent();

public:
  
  static Glib::RefPtr<ConnectionEvent> create();


  /** Sets @a event's severity (from a simple notice to a fatal event)
   * This function should not be called directly.
   * @param type The severity of the event.
   */
  void set_event_type(ConnectionEventType type);
  
  /** Get @a event's severity (from a simple notice to a fatal event)
   * @return The event type.
   */
  ConnectionEventType get_event_type() const;
  
  /** Get the description of the event. Note that is @a event's type is GDA_CONNECTION_EVENT_COMMAND,
   * the the description is the SQL of the command.
   * @return  @a event's description.
   */
  Glib::ustring get_description() const;
  
  /** Sets @a event's @a description. This function should not be called directly.
   * @param description A description.
   */
  void set_description(const Glib::ustring& description);
  
  /** 
   * @return  @a event's code (the code is specific to the provider being used).
   */
  glong get_code() const;
  
  /** Sets @a event's code: the code is specific to the provider being used.
   * If you want to have a common understanding of the event codes, use
   * get_gda_code() instead.
   * 
   * This function should not be called directly
   * @param code A code.
   */
  void set_code(glong code);
  
  /** Retrieve the code associated to @a event.
   * @return The Gda::ConnectionEventCode event's code.
   */
  ConnectionEventCode get_gda_code() const;
  
  /** Sets @a event's gda code: that code is standardized by the libgda
   * library. If you want to specify the corresponding provider specific code,
   * use get_code() or get_sqlstate() instead.
   * 
   * This function should not be called directly
   * @param code A code.
   */
  void set_gda_code(ConnectionEventCode code);
  
  /** 
   * @return  @a event's source.
   */
  Glib::ustring get_source() const;
  
  /** Sets @a event's @a source; this function should not be called directly
   * @param source A source.
   */
  void set_source(const Glib::ustring& source);
  
  /** Get the SQLSTATE value of @a event. Even though the SQLSTATE values are specified by ANSI SQL and ODBC,
   * consult each DBMS for the possible values. However, the "00000" (success) value means that there is no error,
   * and the "HY000" (general error) value means an error but no better error code available.
   * @return  @a event's SQL state.
   */
  Glib::ustring get_sqlstate() const;
  
  /** Changes the SQLSTATE code of @a event, this function should not be called directly
   * 
   * Sets @a event's SQL state.
   * @param sqlstate SQL state.
   */
  void set_sqlstate(const Glib::ustring& sqlstate);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Connection event type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ConnectionEventType > property_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Connection event type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ConnectionEventType > property_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::ConnectionEvent
   */
  Glib::RefPtr<Gnome::Gda::ConnectionEvent> wrap(GdaConnectionEvent* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CONNECTIONEVENT_H */

