/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OSConfigurator.hh,v 1.5 2003/01/13 03:28:09 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __OSCONFIGURATOR_HH__
#define __OSCONFIGURATOR_HH__

#include "fwcompiler/Compiler.hh"

#include "fwbuilder/FWException.hh"
#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/IPAddress.hh"

#include <fstream>
#include <sstream>

namespace fwcompiler {

    class OSConfigurator : public Compiler {

	public:

	virtual ~OSConfigurator();
	OSConfigurator(libfwbuilder::FWObjectDatabase *_db,const std::string &fwname);

	virtual void processFirewallOptions() =0;
	virtual void addVirtualAddressForNAT(const libfwbuilder::Address   *addr) =0;
	virtual void addVirtualAddressForNAT(const libfwbuilder::Network   *nw)   =0;
    };
}

#endif
