/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWOptions.hh,v 1.7 2002/08/29 00:34:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef  __FWOPTINS_HH_FLAG__
#define  __FWOPTINS_HH_FLAG__

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/XMLTools.hh>

namespace libfwbuilder
{

class FWOptions : public FWObject 
{
    public:
    FWOptions();
    FWOptions(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(FWOptions);
    virtual void fromXML(xmlNodePtr parent) throw(FWException);
    virtual xmlNodePtr toXML(xmlNodePtr parent) throw(FWException);
};

class HostOptions : public FWOptions 
{
    public:
    HostOptions();
    HostOptions(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(HostOptions);
};

class FirewallOptions : public FWOptions 
{
    public:
    FirewallOptions();
    FirewallOptions(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(FirewallOptions);
};

class PolicyRuleOptions : public FWOptions 
{
    public:
    
    PolicyRuleOptions();
    PolicyRuleOptions(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(PolicyRuleOptions);
};

class NATRuleOptions : public FWOptions 
{
    public:

    NATRuleOptions();
    NATRuleOptions(const FWObject *root);
    DECLARE_FWOBJECT_SUBTYPE(NATRuleOptions);
};

}

#endif // __FWOPTINS_HH_FLAG
