"""
Python bindings to the libfive CAD kernel

DO NOT EDIT BY HAND!
This file is automatically generated from libfive/stdlib/stdlib.h

It was last generated on 2021-04-08 20:30:18 by user mkeeter

This is libfive.stdlib.transforms
"""

from libfive.ffi import libfive_tree, tfloat, tvec2, tvec3, stdlib
from libfive.shape import Shape

import ctypes

stdlib.move.argtypes = [libfive_tree, tvec3]
stdlib.move.restype = libfive_tree
def move(t, offset):
    """ Moves the given shape in 2D or 3D space
    """
    args = [Shape.wrap(t), list([Shape.wrap(i) for i in offset])]
    return Shape(stdlib.move(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]])))

stdlib.reflect_x.argtypes = [libfive_tree, tfloat]
stdlib.reflect_x.restype = libfive_tree
def reflect_x(t, x0=0):
    """ Reflects a shape about the x origin or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(x0)]
    return Shape(stdlib.reflect_x(
        args[0].ptr,
        args[1].ptr))

stdlib.reflect_y.argtypes = [libfive_tree, tfloat]
stdlib.reflect_y.restype = libfive_tree
def reflect_y(t, y0=0):
    """ Reflects a shape about the y origin or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(y0)]
    return Shape(stdlib.reflect_y(
        args[0].ptr,
        args[1].ptr))

stdlib.reflect_z.argtypes = [libfive_tree, tfloat]
stdlib.reflect_z.restype = libfive_tree
def reflect_z(t, z0=0):
    """ Reflects a shape about the z origin or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(z0)]
    return Shape(stdlib.reflect_z(
        args[0].ptr,
        args[1].ptr))

stdlib.reflect_xy.argtypes = [libfive_tree]
stdlib.reflect_xy.restype = libfive_tree
def reflect_xy(t):
    """ Reflects a shape about the plane X=Y
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.reflect_xy(
        args[0].ptr))

stdlib.reflect_yz.argtypes = [libfive_tree]
stdlib.reflect_yz.restype = libfive_tree
def reflect_yz(t):
    """ Reflects a shape about the plane Y=Z
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.reflect_yz(
        args[0].ptr))

stdlib.reflect_xz.argtypes = [libfive_tree]
stdlib.reflect_xz.restype = libfive_tree
def reflect_xz(t):
    """ Reflects a shape about the plane X=Z
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.reflect_xz(
        args[0].ptr))

stdlib.symmetric_x.argtypes = [libfive_tree]
stdlib.symmetric_x.restype = libfive_tree
def symmetric_x(t):
    """ Clips the given shape at the x origin, then duplicates the remaining
        shape reflected on the other side of the origin
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.symmetric_x(
        args[0].ptr))

stdlib.symmetric_y.argtypes = [libfive_tree]
stdlib.symmetric_y.restype = libfive_tree
def symmetric_y(t):
    """ Clips the given shape at the y origin, then duplicates the remaining
        shape reflected on the other side of the origin
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.symmetric_y(
        args[0].ptr))

stdlib.symmetric_z.argtypes = [libfive_tree]
stdlib.symmetric_z.restype = libfive_tree
def symmetric_z(t):
    """ Clips the given shape at the z origin, then duplicates the remaining
        shape reflected on the other side of the origin
    """
    args = [Shape.wrap(t)]
    return Shape(stdlib.symmetric_z(
        args[0].ptr))

stdlib.scale_x.argtypes = [libfive_tree, tfloat, tfloat]
stdlib.scale_x.restype = libfive_tree
def scale_x(t, sx, x0=0):
    """ Scales a shape by sx on the x axis about 0 or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(sx), Shape.wrap(x0)]
    return Shape(stdlib.scale_x(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr))

stdlib.scale_y.argtypes = [libfive_tree, tfloat, tfloat]
stdlib.scale_y.restype = libfive_tree
def scale_y(t, sy, y0=0):
    """ Scales a shape by sx on the x axis about 0 or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(sy), Shape.wrap(y0)]
    return Shape(stdlib.scale_y(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr))

stdlib.scale_z.argtypes = [libfive_tree, tfloat, tfloat]
stdlib.scale_z.restype = libfive_tree
def scale_z(t, sz, z0=0):
    """ Scales a shape by sx on the x axis about 0 or an optional offset
    """
    args = [Shape.wrap(t), Shape.wrap(sz), Shape.wrap(z0)]
    return Shape(stdlib.scale_z(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr))

stdlib.scale_xyz.argtypes = [libfive_tree, tvec3, tvec3]
stdlib.scale_xyz.restype = libfive_tree
def scale_xyz(t, s, center=(0, 0, 0)):
    """ Scales a shape on all three axes, about 0 or an optional offset
    """
    args = [Shape.wrap(t), list([Shape.wrap(i) for i in s]), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.scale_xyz(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        tvec3(*[a.ptr for a in args[2]])))

stdlib.rotate_x.argtypes = [libfive_tree, tfloat, tvec3]
stdlib.rotate_x.restype = libfive_tree
def rotate_x(t, angle, center=(0, 0, 0)):
    """ Rotate the given shape by an angle in radians
        The center of rotation is [0 0 0] or specified by the optional argument
    """
    args = [Shape.wrap(t), Shape.wrap(angle), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.rotate_x(
        args[0].ptr,
        args[1].ptr,
        tvec3(*[a.ptr for a in args[2]])))

stdlib.rotate_y.argtypes = [libfive_tree, tfloat, tvec3]
stdlib.rotate_y.restype = libfive_tree
def rotate_y(t, angle, center=(0, 0, 0)):
    """ Rotate the given shape by an angle in radians
        The center of rotation is [0 0 0] or specified by the optional argument
    """
    args = [Shape.wrap(t), Shape.wrap(angle), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.rotate_y(
        args[0].ptr,
        args[1].ptr,
        tvec3(*[a.ptr for a in args[2]])))

stdlib.rotate_z.argtypes = [libfive_tree, tfloat, tvec3]
stdlib.rotate_z.restype = libfive_tree
def rotate_z(t, angle, center=(0, 0, 0)):
    """ Rotate the given shape by an angle in radians
        The center of rotation is [0 0 0] or specified by the optional argument
    """
    args = [Shape.wrap(t), Shape.wrap(angle), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.rotate_z(
        args[0].ptr,
        args[1].ptr,
        tvec3(*[a.ptr for a in args[2]])))

stdlib.taper_x_y.argtypes = [libfive_tree, tvec2, tfloat, tfloat, tfloat]
stdlib.taper_x_y.restype = libfive_tree
def taper_x_y(shape, base, h, scale, base_scale=1):
    """ Tapers a shape along the x axis as a function of y
        width = base-scale at base
        width = scale at base + [0 h]
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in base]), Shape.wrap(h), Shape.wrap(scale), Shape.wrap(base_scale)]
    return Shape(stdlib.taper_x_y(
        args[0].ptr,
        tvec2(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr,
        args[4].ptr))

stdlib.taper_xy_z.argtypes = [libfive_tree, tvec3, tfloat, tfloat, tfloat]
stdlib.taper_xy_z.restype = libfive_tree
def taper_xy_z(shape, base, height, scale, base_scale=1):
    """ Tapers a shape in the xy plane as a function of z
        width = base-scale at base
        width = scale at base + [0 0 height]
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in base]), Shape.wrap(height), Shape.wrap(scale), Shape.wrap(base_scale)]
    return Shape(stdlib.taper_xy_z(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr,
        args[4].ptr))

stdlib.shear_x_y.argtypes = [libfive_tree, tvec2, tfloat, tfloat, tfloat]
stdlib.shear_x_y.restype = libfive_tree
def shear_x_y(t, base, height, offset, base_offset=0):
    """ Shears a shape on the x axis as a function of y
        offset = base-offset at base.y
        offset = offset = base.y + h
    """
    args = [Shape.wrap(t), list([Shape.wrap(i) for i in base]), Shape.wrap(height), Shape.wrap(offset), Shape.wrap(base_offset)]
    return Shape(stdlib.shear_x_y(
        args[0].ptr,
        tvec2(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr,
        args[4].ptr))

stdlib.repel.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel.restype = libfive_tree
def repel(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from a point based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_x.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_x.restype = libfive_tree
def repel_x(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from a YZ plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_x(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_y.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_y.restype = libfive_tree
def repel_y(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from a XZ plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_y(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_z.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_z.restype = libfive_tree
def repel_z(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from a XY plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_z(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_xy.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_xy.restype = libfive_tree
def repel_xy(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from line parallel to the Z axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_xy(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_yz.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_yz.restype = libfive_tree
def repel_yz(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from line parallel to the X axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_yz(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.repel_xz.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.repel_xz.restype = libfive_tree
def repel_xz(shape, locus, radius, exaggerate=1):
    """ Repels the shape away from line parallel to the Y axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.repel_xz(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract.restype = libfive_tree
def attract(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from a point based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_x.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_x.restype = libfive_tree
def attract_x(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from a YZ plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_x(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_y.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_y.restype = libfive_tree
def attract_y(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from a XZ plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_y(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_z.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_z.restype = libfive_tree
def attract_z(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from a XY plane based upon a radius r,
        with optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_z(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_xy.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_xy.restype = libfive_tree
def attract_xy(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from line parallel to the Z axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_xy(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_yz.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_yz.restype = libfive_tree
def attract_yz(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from line parallel to the X axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_yz(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.attract_xz.argtypes = [libfive_tree, tvec3, tfloat, tfloat]
stdlib.attract_xz.restype = libfive_tree
def attract_xz(shape, locus, radius, exaggerate=1):
    """ Attracts the shape away from line parallel to the Y axis,
        with a particular radius and optional exaggeration
    """
    args = [Shape.wrap(shape), list([Shape.wrap(i) for i in locus]), Shape.wrap(radius), Shape.wrap(exaggerate)]
    return Shape(stdlib.attract_xz(
        args[0].ptr,
        tvec3(*[a.ptr for a in args[1]]),
        args[2].ptr,
        args[3].ptr))

stdlib.revolve_y.argtypes = [libfive_tree, tfloat]
stdlib.revolve_y.restype = libfive_tree
def revolve_y(shape, x0=0):
    """ Revolves a 2D (XY) shape about a line parallel to the Y axis with the
        given x value
    """
    args = [Shape.wrap(shape), Shape.wrap(x0)]
    return Shape(stdlib.revolve_y(
        args[0].ptr,
        args[1].ptr))

stdlib.twirl_x.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_x.restype = libfive_tree
def twirl_x(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the x axis about the (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_x(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

stdlib.twirl_axis_x.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_axis_x.restype = libfive_tree
def twirl_axis_x(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the x axis about the line extending from the
        (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_axis_x(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

stdlib.twirl_y.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_y.restype = libfive_tree
def twirl_y(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the y axis about the (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_y(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

stdlib.twirl_axis_y.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_axis_y.restype = libfive_tree
def twirl_axis_y(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the y axis about the line extending from the
        (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_axis_y(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

stdlib.twirl_z.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_z.restype = libfive_tree
def twirl_z(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the z axis about the (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_z(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

stdlib.twirl_axis_z.argtypes = [libfive_tree, tfloat, tfloat, tvec3]
stdlib.twirl_axis_z.restype = libfive_tree
def twirl_axis_z(shape, amount, radius, center=(0, 0, 0)):
    """ Twirls the shape in the z axis about the line extending from the
        (optional) center point
    """
    args = [Shape.wrap(shape), Shape.wrap(amount), Shape.wrap(radius), list([Shape.wrap(i) for i in center])]
    return Shape(stdlib.twirl_axis_z(
        args[0].ptr,
        args[1].ptr,
        args[2].ptr,
        tvec3(*[a.ptr for a in args[3]])))

rotate = rotate_z
################################################################################
# Hand-written override to let move work in 2D
_move_prev = move
def move(shape, v):
    if len(v) == 2:
        v = [v[0], v[1], 0]
    return _move_prev(shape, v)
move.__doc__ = _move_prev.__doc__
