/* Warning: automatically generated code */
static ir_node *read_Add(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Add(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Alloc(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_count = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	ir_where_alloc where = read_where_alloc(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_node *res;
	res = new_r_Alloc(block, in_mem, in_count, type, where);
	set_irn_pinned(res, pin_state);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_And(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_And(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Bad(read_env_t *env)
{
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Bad(env->irg, mode);
	return res;
}

static ir_node *read_Borrow(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Borrow(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Bound(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_index = read_node_ref(env);
	ir_node *in_lower = read_node_ref(env);
	ir_node *in_upper = read_node_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_node *res;
	res = new_r_Bound(block, in_mem, in_index, in_lower, in_upper);
	set_irn_pinned(res, pin_state);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_Builtin(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_builtin_kind kind = read_builtin_kind(env);
	ir_type* type = read_type_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Builtin(block, in_mem, n_preds, preds, kind, type);
	obstack_free(&env->preds_obst, preds);
	set_irn_pinned(res, pin_state);
	return res;
}

static ir_node *read_Call(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_ptr = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Call(block, in_mem, in_ptr, n_preds, preds, type);
	obstack_free(&env->preds_obst, preds);
	set_irn_pinned(res, pin_state);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_Carry(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Carry(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Cast(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_op = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	ir_node *res;
	res = new_r_Cast(block, in_op, type);
	return res;
}

static ir_node *read_Cmp(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_relation relation = read_relation(env);
	ir_node *res;
	res = new_r_Cmp(block, in_left, in_right, relation);
	return res;
}

static ir_node *read_Cond(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_selector = read_node_ref(env);
	cond_jmp_predicate jmp_pred = read_cond_jmp_predicate(env);
	ir_node *res;
	res = new_r_Cond(block, in_selector);
	set_Cond_jmp_pred(res, jmp_pred);
	return res;
}

static ir_node *read_Confirm(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_value = read_node_ref(env);
	ir_node *in_bound = read_node_ref(env);
	ir_relation relation = read_relation(env);
	ir_node *res;
	res = new_r_Confirm(block, in_value, in_bound, relation);
	return res;
}

static ir_node *read_Const(read_env_t *env)
{
	ir_tarval* tarval = read_tarval(env);
	ir_node *res;
	res = new_r_Const(env->irg, tarval);
	return res;
}

static ir_node *read_Conv(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_op = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Conv(block, in_op, mode);
	return res;
}

static ir_node *read_CopyB(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_dst = read_node_ref(env);
	ir_node *in_src = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_node *res;
	res = new_r_CopyB(block, in_mem, in_dst, in_src, type);
	set_irn_pinned(res, pin_state);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_Div(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode* resmode = read_mode_ref(env);
	int no_remainder = read_int(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_node *res;
	res = new_r_Div(block, in_mem, in_left, in_right, resmode, pin_state);
	set_Div_no_remainder(res, no_remainder);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_Dummy(read_env_t *env)
{
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Dummy(env->irg, mode);
	return res;
}

static ir_node *read_End(read_env_t *env)
{
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_End(env->irg, n_preds, preds);
	obstack_free(&env->preds_obst, preds);
	return res;
}

static ir_node *read_Eor(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Eor(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Free(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_ptr = read_node_ref(env);
	ir_node *in_count = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	ir_where_alloc where = read_where_alloc(env);
	ir_node *res;
	res = new_r_Free(block, in_mem, in_ptr, in_count, type, where);
	return res;
}

static ir_node *read_IJmp(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_target = read_node_ref(env);
	ir_node *res;
	res = new_r_IJmp(block, in_target);
	return res;
}

static ir_node *read_Id(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_pred = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Id(block, in_pred, mode);
	return res;
}

static ir_node *read_InstOf(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_store = read_node_ref(env);
	ir_node *in_obj = read_node_ref(env);
	ir_type* type = read_type_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	ir_node *res;
	res = new_r_InstOf(block, in_store, in_obj, type);
	set_irn_pinned(res, pin_state);
	return res;
}

static ir_node *read_Jmp(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *res;
	res = new_r_Jmp(block);
	return res;
}

static ir_node *read_Load(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_ptr = read_node_ref(env);
	ir_mode* mode = read_mode_ref(env);
	ir_volatility volatility = read_volatility(env);
	ir_align unaligned = read_align(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_cons_flags flags = cons_none;
	ir_node *res;
	flags |= volatility == volatility_is_volatile ? cons_volatile : cons_none;
	flags |= unaligned == align_non_aligned ? cons_unaligned : cons_none;
	flags |= pin_state == op_pin_state_floats ? cons_floats : cons_none;
	flags |= throws ? cons_throws_exception : cons_none;
	res = new_r_Load(block, in_mem, in_ptr, mode, flags);
	return res;
}

static ir_node *read_Minus(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_op = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Minus(block, in_op, mode);
	return res;
}

static ir_node *read_Mod(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode* resmode = read_mode_ref(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_node *res;
	res = new_r_Mod(block, in_mem, in_left, in_right, resmode, pin_state);
	ir_set_throws_exception(res, throws);
	return res;
}

static ir_node *read_Mul(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Mul(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Mulh(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Mulh(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Mux(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_sel = read_node_ref(env);
	ir_node *in_false = read_node_ref(env);
	ir_node *in_true = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Mux(block, in_sel, in_false, in_true, mode);
	return res;
}

static ir_node *read_NoMem(read_env_t *env)
{
	ir_node *res;
	res = new_r_NoMem(env->irg);
	return res;
}

static ir_node *read_Not(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_op = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Not(block, in_op, mode);
	return res;
}

static ir_node *read_Or(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Or(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Pin(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_op = read_node_ref(env);
	ir_node *res;
	res = new_r_Pin(block, in_op);
	return res;
}

static ir_node *read_Proj(read_env_t *env)
{
	ir_node *in_pred = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	long proj = read_long(env);
	ir_node *res;
	res = new_r_Proj(in_pred, mode, proj);
	return res;
}

static ir_node *read_Raise(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_exo_ptr = read_node_ref(env);
	ir_node *res;
	res = new_r_Raise(block, in_mem, in_exo_ptr);
	return res;
}

static ir_node *read_Return(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Return(block, in_mem, n_preds, preds);
	obstack_free(&env->preds_obst, preds);
	return res;
}

static ir_node *read_Rotl(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Rotl(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Sel(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_ptr = read_node_ref(env);
	ir_entity* entity = read_entity_ref(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Sel(block, in_mem, in_ptr, n_preds, preds, entity);
	obstack_free(&env->preds_obst, preds);
	return res;
}

static ir_node *read_Shl(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Shl(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Shr(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Shr(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Shrs(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Shrs(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Start(read_env_t *env)
{
	ir_node *res;
	res = new_r_Start(env->irg);
	return res;
}

static ir_node *read_Store(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_mem = read_node_ref(env);
	ir_node *in_ptr = read_node_ref(env);
	ir_node *in_value = read_node_ref(env);
	ir_volatility volatility = read_volatility(env);
	ir_align unaligned = read_align(env);
	op_pin_state pin_state = read_pin_state(env);
	bool throws = read_throws(env);
	ir_cons_flags flags = cons_none;
	ir_node *res;
	flags |= volatility == volatility_is_volatile ? cons_volatile : cons_none;
	flags |= unaligned == align_non_aligned ? cons_unaligned : cons_none;
	flags |= pin_state == op_pin_state_floats ? cons_floats : cons_none;
	flags |= throws ? cons_throws_exception : cons_none;
	res = new_r_Store(block, in_mem, in_ptr, in_value, flags);
	return res;
}

static ir_node *read_Sub(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_left = read_node_ref(env);
	ir_node *in_right = read_node_ref(env);
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Sub(block, in_left, in_right, mode);
	return res;
}

static ir_node *read_Switch(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	ir_node *in_selector = read_node_ref(env);
	unsigned n_outs = read_unsigned(env);
	ir_switch_table* table = read_switch_table(env);
	ir_node *res;
	res = new_r_Switch(block, in_selector, n_outs, table);
	return res;
}

static ir_node *read_Sync(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Sync(block, n_preds, preds);
	obstack_free(&env->preds_obst, preds);
	return res;
}

static ir_node *read_Tuple(read_env_t *env)
{
	ir_node *block = read_node_ref(env);
	int       n_preds = read_preds(env);
	ir_node **preds   = (ir_node**)obstack_finish(&env->preds_obst);
	ir_node *res;
	res = new_r_Tuple(block, n_preds, preds);
	obstack_free(&env->preds_obst, preds);
	return res;
}

static ir_node *read_Unknown(read_env_t *env)
{
	ir_mode *mode = read_mode_ref(env);
	ir_node *res;
	res = new_r_Unknown(env->irg, mode);
	return res;
}

static void write_Add(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Add");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Add_left(node));
	write_node_ref(env, get_Add_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Alloc(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Alloc");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Alloc_mem(node));
	write_node_ref(env, get_Alloc_count(node));
	write_type_ref(env, get_Alloc_type(node));
	write_where_alloc(env, get_Alloc_where(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_And(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "And");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_And_left(node));
	write_node_ref(env, get_And_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Bad(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Bad");
	write_node_nr(env, node);
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Borrow(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Borrow");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Borrow_left(node));
	write_node_ref(env, get_Borrow_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Bound(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Bound");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Bound_mem(node));
	write_node_ref(env, get_Bound_index(node));
	write_node_ref(env, get_Bound_lower(node));
	write_node_ref(env, get_Bound_upper(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Builtin(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Builtin");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Builtin_mem(node));
	write_builtin_kind(env, node);
	write_type_ref(env, get_Builtin_type(node));
	write_pin_state(env, get_irn_pinned(node));
	write_pred_refs(env, node, n_Builtin_max+1);
}

static void write_Call(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Call");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Call_mem(node));
	write_node_ref(env, get_Call_ptr(node));
	write_type_ref(env, get_Call_type(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
	write_pred_refs(env, node, n_Call_max+1);
}

static void write_Carry(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Carry");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Carry_left(node));
	write_node_ref(env, get_Carry_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Cast(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Cast");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Cast_op(node));
	write_type_ref(env, get_Cast_type(node));
}

static void write_Cmp(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Cmp");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Cmp_left(node));
	write_node_ref(env, get_Cmp_right(node));
	write_relation(env, get_Cmp_relation(node));
}

static void write_Cond(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Cond");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Cond_selector(node));
	write_cond_jmp_predicate(env, node);
}

static void write_Confirm(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Confirm");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Confirm_value(node));
	write_node_ref(env, get_Confirm_bound(node));
	write_relation(env, get_Confirm_relation(node));
}

static void write_Const(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Const");
	write_node_nr(env, node);
	write_tarval(env, get_Const_tarval(node));
}

static void write_Conv(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Conv");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Conv_op(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_CopyB(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "CopyB");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_CopyB_mem(node));
	write_node_ref(env, get_CopyB_dst(node));
	write_node_ref(env, get_CopyB_src(node));
	write_type_ref(env, get_CopyB_type(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Div(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Div");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Div_mem(node));
	write_node_ref(env, get_Div_left(node));
	write_node_ref(env, get_Div_right(node));
	write_mode_ref(env, get_Div_resmode(node));
	write_int(env, get_Div_no_remainder(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Dummy(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Dummy");
	write_node_nr(env, node);
	write_mode_ref(env, get_irn_mode(node));
}

static void write_End(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "End");
	write_node_nr(env, node);
	write_pred_refs(env, node, 0);
}

static void write_Eor(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Eor");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Eor_left(node));
	write_node_ref(env, get_Eor_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Free(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Free");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Free_mem(node));
	write_node_ref(env, get_Free_ptr(node));
	write_node_ref(env, get_Free_count(node));
	write_type_ref(env, get_Free_type(node));
	write_where_alloc(env, get_Free_where(node));
}

static void write_IJmp(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "IJmp");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_IJmp_target(node));
}

static void write_Id(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Id");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Id_pred(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_InstOf(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "InstOf");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_InstOf_store(node));
	write_node_ref(env, get_InstOf_obj(node));
	write_type_ref(env, get_InstOf_type(node));
	write_pin_state(env, get_irn_pinned(node));
}

static void write_Jmp(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Jmp");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
}

static void write_Load(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Load");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Load_mem(node));
	write_node_ref(env, get_Load_ptr(node));
	write_mode_ref(env, get_Load_mode(node));
	write_volatility(env, get_Load_volatility(node));
	write_align(env, get_Load_unaligned(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Minus(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Minus");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Minus_op(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Mod(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Mod");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Mod_mem(node));
	write_node_ref(env, get_Mod_left(node));
	write_node_ref(env, get_Mod_right(node));
	write_mode_ref(env, get_Mod_resmode(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Mul(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Mul");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Mul_left(node));
	write_node_ref(env, get_Mul_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Mulh(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Mulh");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Mulh_left(node));
	write_node_ref(env, get_Mulh_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Mux(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Mux");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Mux_sel(node));
	write_node_ref(env, get_Mux_false(node));
	write_node_ref(env, get_Mux_true(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_NoMem(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "NoMem");
	write_node_nr(env, node);
}

static void write_Not(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Not");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Not_op(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Or(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Or");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Or_left(node));
	write_node_ref(env, get_Or_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Pin(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Pin");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Pin_op(node));
}

static void write_Proj(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Proj");
	write_node_nr(env, node);
	write_node_ref(env, get_Proj_pred(node));
	write_mode_ref(env, get_irn_mode(node));
	write_long(env, get_Proj_proj(node));
}

static void write_Raise(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Raise");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Raise_mem(node));
	write_node_ref(env, get_Raise_exo_ptr(node));
}

static void write_Return(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Return");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Return_mem(node));
	write_pred_refs(env, node, n_Return_max+1);
}

static void write_Rotl(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Rotl");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Rotl_left(node));
	write_node_ref(env, get_Rotl_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Sel(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Sel");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Sel_mem(node));
	write_node_ref(env, get_Sel_ptr(node));
	write_entity_ref(env, get_Sel_entity(node));
	write_pred_refs(env, node, n_Sel_max+1);
}

static void write_Shl(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Shl");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Shl_left(node));
	write_node_ref(env, get_Shl_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Shr(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Shr");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Shr_left(node));
	write_node_ref(env, get_Shr_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Shrs(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Shrs");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Shrs_left(node));
	write_node_ref(env, get_Shrs_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Start(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Start");
	write_node_nr(env, node);
}

static void write_Store(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Store");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Store_mem(node));
	write_node_ref(env, get_Store_ptr(node));
	write_node_ref(env, get_Store_value(node));
	write_volatility(env, get_Store_volatility(node));
	write_align(env, get_Store_unaligned(node));
	write_pin_state(env, get_irn_pinned(node));
	write_throws(env, ir_throws_exception(node));
}

static void write_Sub(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Sub");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Sub_left(node));
	write_node_ref(env, get_Sub_right(node));
	write_mode_ref(env, get_irn_mode(node));
}

static void write_Switch(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Switch");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_node_ref(env, get_Switch_selector(node));
	write_unsigned(env, get_Switch_n_outs(node));
	write_switch_table(env, get_Switch_table(node));
}

static void write_Sync(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Sync");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_pred_refs(env, node, 0);
}

static void write_Tuple(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Tuple");
	write_node_nr(env, node);
	write_node_ref(env, get_nodes_block(node));
	write_pred_refs(env, node, 0);
}

static void write_Unknown(write_env_t *env, const ir_node *node)
{
	write_symbol(env, "Unknown");
	write_node_nr(env, node);
	write_mode_ref(env, get_irn_mode(node));
}


static void register_generated_node_readers(void)
{
	register_node_reader(new_id_from_str("Add"), read_Add);
	register_node_reader(new_id_from_str("Alloc"), read_Alloc);
	register_node_reader(new_id_from_str("And"), read_And);
	register_node_reader(new_id_from_str("Bad"), read_Bad);
	register_node_reader(new_id_from_str("Borrow"), read_Borrow);
	register_node_reader(new_id_from_str("Bound"), read_Bound);
	register_node_reader(new_id_from_str("Builtin"), read_Builtin);
	register_node_reader(new_id_from_str("Call"), read_Call);
	register_node_reader(new_id_from_str("Carry"), read_Carry);
	register_node_reader(new_id_from_str("Cast"), read_Cast);
	register_node_reader(new_id_from_str("Cmp"), read_Cmp);
	register_node_reader(new_id_from_str("Cond"), read_Cond);
	register_node_reader(new_id_from_str("Confirm"), read_Confirm);
	register_node_reader(new_id_from_str("Const"), read_Const);
	register_node_reader(new_id_from_str("Conv"), read_Conv);
	register_node_reader(new_id_from_str("CopyB"), read_CopyB);
	register_node_reader(new_id_from_str("Div"), read_Div);
	register_node_reader(new_id_from_str("Dummy"), read_Dummy);
	register_node_reader(new_id_from_str("End"), read_End);
	register_node_reader(new_id_from_str("Eor"), read_Eor);
	register_node_reader(new_id_from_str("Free"), read_Free);
	register_node_reader(new_id_from_str("IJmp"), read_IJmp);
	register_node_reader(new_id_from_str("Id"), read_Id);
	register_node_reader(new_id_from_str("InstOf"), read_InstOf);
	register_node_reader(new_id_from_str("Jmp"), read_Jmp);
	register_node_reader(new_id_from_str("Load"), read_Load);
	register_node_reader(new_id_from_str("Minus"), read_Minus);
	register_node_reader(new_id_from_str("Mod"), read_Mod);
	register_node_reader(new_id_from_str("Mul"), read_Mul);
	register_node_reader(new_id_from_str("Mulh"), read_Mulh);
	register_node_reader(new_id_from_str("Mux"), read_Mux);
	register_node_reader(new_id_from_str("NoMem"), read_NoMem);
	register_node_reader(new_id_from_str("Not"), read_Not);
	register_node_reader(new_id_from_str("Or"), read_Or);
	register_node_reader(new_id_from_str("Pin"), read_Pin);
	register_node_reader(new_id_from_str("Proj"), read_Proj);
	register_node_reader(new_id_from_str("Raise"), read_Raise);
	register_node_reader(new_id_from_str("Return"), read_Return);
	register_node_reader(new_id_from_str("Rotl"), read_Rotl);
	register_node_reader(new_id_from_str("Sel"), read_Sel);
	register_node_reader(new_id_from_str("Shl"), read_Shl);
	register_node_reader(new_id_from_str("Shr"), read_Shr);
	register_node_reader(new_id_from_str("Shrs"), read_Shrs);
	register_node_reader(new_id_from_str("Start"), read_Start);
	register_node_reader(new_id_from_str("Store"), read_Store);
	register_node_reader(new_id_from_str("Sub"), read_Sub);
	register_node_reader(new_id_from_str("Switch"), read_Switch);
	register_node_reader(new_id_from_str("Sync"), read_Sync);
	register_node_reader(new_id_from_str("Tuple"), read_Tuple);
	register_node_reader(new_id_from_str("Unknown"), read_Unknown);
}

static void register_generated_node_writers(void)
{
	register_node_writer(op_Add, write_Add);
	register_node_writer(op_Alloc, write_Alloc);
	register_node_writer(op_And, write_And);
	register_node_writer(op_Bad, write_Bad);
	register_node_writer(op_Borrow, write_Borrow);
	register_node_writer(op_Bound, write_Bound);
	register_node_writer(op_Builtin, write_Builtin);
	register_node_writer(op_Call, write_Call);
	register_node_writer(op_Carry, write_Carry);
	register_node_writer(op_Cast, write_Cast);
	register_node_writer(op_Cmp, write_Cmp);
	register_node_writer(op_Cond, write_Cond);
	register_node_writer(op_Confirm, write_Confirm);
	register_node_writer(op_Const, write_Const);
	register_node_writer(op_Conv, write_Conv);
	register_node_writer(op_CopyB, write_CopyB);
	register_node_writer(op_Div, write_Div);
	register_node_writer(op_Dummy, write_Dummy);
	register_node_writer(op_End, write_End);
	register_node_writer(op_Eor, write_Eor);
	register_node_writer(op_Free, write_Free);
	register_node_writer(op_IJmp, write_IJmp);
	register_node_writer(op_Id, write_Id);
	register_node_writer(op_InstOf, write_InstOf);
	register_node_writer(op_Jmp, write_Jmp);
	register_node_writer(op_Load, write_Load);
	register_node_writer(op_Minus, write_Minus);
	register_node_writer(op_Mod, write_Mod);
	register_node_writer(op_Mul, write_Mul);
	register_node_writer(op_Mulh, write_Mulh);
	register_node_writer(op_Mux, write_Mux);
	register_node_writer(op_NoMem, write_NoMem);
	register_node_writer(op_Not, write_Not);
	register_node_writer(op_Or, write_Or);
	register_node_writer(op_Pin, write_Pin);
	register_node_writer(op_Proj, write_Proj);
	register_node_writer(op_Raise, write_Raise);
	register_node_writer(op_Return, write_Return);
	register_node_writer(op_Rotl, write_Rotl);
	register_node_writer(op_Sel, write_Sel);
	register_node_writer(op_Shl, write_Shl);
	register_node_writer(op_Shr, write_Shr);
	register_node_writer(op_Shrs, write_Shrs);
	register_node_writer(op_Start, write_Start);
	register_node_writer(op_Store, write_Store);
	register_node_writer(op_Sub, write_Sub);
	register_node_writer(op_Switch, write_Switch);
	register_node_writer(op_Sync, write_Sync);
	register_node_writer(op_Tuple, write_Tuple);
	register_node_writer(op_Unknown, write_Unknown);
}
