/* Warning: automatically generated code */
ir_node *new_rd_Add(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Add, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Add(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Add(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Add(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Add(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Add(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Add(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Alloc(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_count;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Alloc, mode_T, 2, in);
	res->attr.alloc.type = type;
	res->attr.alloc.where = where;
	res->attr.alloc.exc.pin_state = op_pin_state_pinned;
	res->attr.alloc.exc.throws_exception = false;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Alloc(ir_node *block, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	return new_rd_Alloc(NULL, block, irn_mem, irn_count, type, where);
}

ir_node *new_d_Alloc(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Alloc(dbgi, current_ir_graph->current_block, irn_mem, irn_count, type, where);
	return res;
}

ir_node *new_Alloc(ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	return new_d_Alloc(NULL, irn_mem, irn_count, type, where);
}

ir_node *new_rd_And(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_And, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_And(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_And(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_And(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_And(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_And(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_And(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Bad(dbg_info *dbgi, ir_graph *irg, ir_mode * mode)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_Bad, mode, 0, NULL);
	res->attr.bad.irg.irg = irg;
	
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Bad(ir_graph *irg, ir_mode * mode)
{
	return new_rd_Bad(NULL, irg, mode);
}

ir_node *new_d_Bad(dbg_info *dbgi, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Bad(dbgi, current_ir_graph, mode);
	return res;
}

ir_node *new_Bad(ir_mode * mode)
{
	return new_d_Bad(NULL, mode);
}

ir_node *new_rd_Block(dbg_info *dbgi, ir_graph *irg, int arity, ir_node *const * in)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, NULL, op_Block, mode_BB, arity, in);
	res->attr.block.entity = NULL;
	res->attr.block.irg.irg     = irg;
	res->attr.block.backedge    = new_backedge_arr(irg->obst, arity);
	set_Block_matured(res, 1);

	/* Create and initialize array for Phi-node construction. */
	if (irg_is_constrained(irg, IR_GRAPH_CONSTRAINT_CONSTRUCTION)) {
		res->attr.block.graph_arr = NEW_ARR_D(ir_node *, irg->obst, irg->n_loc);
		memset(res->attr.block.graph_arr, 0, irg->n_loc * sizeof(ir_node*));
	}
	
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Block(ir_graph *irg, int arity, ir_node *const * in)
{
	return new_rd_Block(NULL, irg, arity, in);
}

ir_node *new_d_Block(dbg_info *dbgi, int arity, ir_node *const * in)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Block(dbgi, current_ir_graph, arity, in);
	return res;
}

ir_node *new_Block(int arity, ir_node *const * in)
{
	return new_d_Block(NULL, arity, in);
}

ir_node *new_rd_Borrow(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Borrow, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Borrow(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Borrow(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Borrow(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Borrow(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Borrow(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Borrow(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Bound(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[4];
	in[0] = irn_mem;
	in[1] = irn_index;
	in[2] = irn_lower;
	in[3] = irn_upper;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Bound, mode_T, 4, in);
	res->attr.bound.exc.pin_state = op_pin_state_pinned;
	res->attr.bound.exc.throws_exception = false;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Bound(ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	return new_rd_Bound(NULL, block, irn_mem, irn_index, irn_lower, irn_upper);
}

ir_node *new_d_Bound(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Bound(dbgi, current_ir_graph->current_block, irn_mem, irn_index, irn_lower, irn_upper);
	return res;
}

ir_node *new_Bound(ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	return new_d_Bound(NULL, irn_mem, irn_index, irn_lower, irn_upper);
}

ir_node *new_rd_Builtin(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type)
{
	ir_graph *irg = get_irn_irg(block);

	int r_arity = arity + 1;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	memcpy(&r_in[1], in, sizeof(ir_node *) * arity);
	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Builtin, mode_T, r_arity, r_in);
	res->attr.builtin.kind = kind;
	res->attr.builtin.type = type;
	res->attr.builtin.exc.pin_state = op_pin_state_pinned;
	assert((get_unknown_type() == type) || is_Method_type(type));
	
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Builtin(ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type)
{
	return new_rd_Builtin(NULL, block, irn_mem, arity, in, kind, type);
}

ir_node *new_d_Builtin(dbg_info *dbgi, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Builtin(dbgi, current_ir_graph->current_block, irn_mem, arity, in, kind, type);
	return res;
}

ir_node *new_Builtin(ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type)
{
	return new_d_Builtin(NULL, irn_mem, arity, in, kind, type);
}

ir_node *new_rd_Call(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type)
{
	ir_graph *irg = get_irn_irg(block);

	int r_arity = arity + 2;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	r_in[1] = irn_ptr;
	memcpy(&r_in[2], in, sizeof(ir_node *) * arity);
	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Call, mode_T, r_arity, r_in);
	res->attr.call.type = type;
	res->attr.call.exc.pin_state = op_pin_state_pinned;
	res->attr.call.exc.throws_exception = false;
	assert((get_unknown_type() == type) || is_Method_type(type));
	
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Call(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type)
{
	return new_rd_Call(NULL, block, irn_mem, irn_ptr, arity, in, type);
}

ir_node *new_d_Call(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Call(dbgi, current_ir_graph->current_block, irn_mem, irn_ptr, arity, in, type);
	return res;
}

ir_node *new_Call(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type)
{
	return new_d_Call(NULL, irn_mem, irn_ptr, arity, in, type);
}

ir_node *new_rd_Carry(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Carry, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Carry(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Carry(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Carry(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Carry(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Carry(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Carry(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Cast(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_type* type)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_op;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Cast, get_irn_mode(irn_op), 1, in);
	res->attr.cast.type = type;assert(is_atomic_type(type));
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Cast(ir_node *block, ir_node * irn_op, ir_type* type)
{
	return new_rd_Cast(NULL, block, irn_op, type);
}

ir_node *new_d_Cast(dbg_info *dbgi, ir_node * irn_op, ir_type* type)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Cast(dbgi, current_ir_graph->current_block, irn_op, type);
	return res;
}

ir_node *new_Cast(ir_node * irn_op, ir_type* type)
{
	return new_d_Cast(NULL, irn_op, type);
}

ir_node *new_rd_Cmp(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_relation relation)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Cmp, mode_b, 2, in);
	res->attr.cmp.relation = relation;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Cmp(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_relation relation)
{
	return new_rd_Cmp(NULL, block, irn_left, irn_right, relation);
}

ir_node *new_d_Cmp(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_relation relation)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Cmp(dbgi, current_ir_graph->current_block, irn_left, irn_right, relation);
	return res;
}

ir_node *new_Cmp(ir_node * irn_left, ir_node * irn_right, ir_relation relation)
{
	return new_d_Cmp(NULL, irn_left, irn_right, relation);
}

ir_node *new_rd_Cond(dbg_info *dbgi, ir_node *block, ir_node * irn_selector)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_selector;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Cond, mode_T, 1, in);
	res->attr.cond.jmp_pred = COND_JMP_PRED_NONE;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Cond(ir_node *block, ir_node * irn_selector)
{
	return new_rd_Cond(NULL, block, irn_selector);
}

ir_node *new_d_Cond(dbg_info *dbgi, ir_node * irn_selector)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Cond(dbgi, current_ir_graph->current_block, irn_selector);
	return res;
}

ir_node *new_Cond(ir_node * irn_selector)
{
	return new_d_Cond(NULL, irn_selector);
}

ir_node *new_rd_Confirm(dbg_info *dbgi, ir_node *block, ir_node * irn_value, ir_node * irn_bound, ir_relation relation)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_value;
	in[1] = irn_bound;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Confirm, get_irn_mode(irn_value), 2, in);
	res->attr.confirm.relation = relation;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Confirm(ir_node *block, ir_node * irn_value, ir_node * irn_bound, ir_relation relation)
{
	return new_rd_Confirm(NULL, block, irn_value, irn_bound, relation);
}

ir_node *new_d_Confirm(dbg_info *dbgi, ir_node * irn_value, ir_node * irn_bound, ir_relation relation)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Confirm(dbgi, current_ir_graph->current_block, irn_value, irn_bound, relation);
	return res;
}

ir_node *new_Confirm(ir_node * irn_value, ir_node * irn_bound, ir_relation relation)
{
	return new_d_Confirm(NULL, irn_value, irn_bound, relation);
}

ir_node *new_rd_Const(dbg_info *dbgi, ir_graph *irg, ir_tarval* tarval)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_Const, get_tarval_mode(tarval), 0, NULL);
	res->attr.con.tarval = tarval;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Const(ir_graph *irg, ir_tarval* tarval)
{
	return new_rd_Const(NULL, irg, tarval);
}

ir_node *new_d_Const(dbg_info *dbgi, ir_tarval* tarval)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Const(dbgi, current_ir_graph, tarval);
	return res;
}

ir_node *new_Const(ir_tarval* tarval)
{
	return new_d_Const(NULL, tarval);
}

ir_node *new_rd_Conv(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_op;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Conv, mode, 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Conv(ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Conv(NULL, block, irn_op, mode);
}

ir_node *new_d_Conv(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Conv(dbgi, current_ir_graph->current_block, irn_op, mode);
	return res;
}

ir_node *new_Conv(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Conv(NULL, irn_op, mode);
}

ir_node *new_rd_CopyB(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_dst;
	in[2] = irn_src;

	ir_node *res = new_ir_node(dbgi, irg, block, op_CopyB, mode_T, 3, in);
	res->attr.copyb.type = type;
	res->attr.copyb.exc.pin_state = op_pin_state_pinned;
	res->attr.copyb.exc.throws_exception = false;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_CopyB(ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	return new_rd_CopyB(NULL, block, irn_mem, irn_dst, irn_src, type);
}

ir_node *new_d_CopyB(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_CopyB(dbgi, current_ir_graph->current_block, irn_mem, irn_dst, irn_src, type);
	return res;
}

ir_node *new_CopyB(ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	return new_d_CopyB(NULL, irn_mem, irn_dst, irn_src, type);
}

ir_node *new_rd_Div(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Div, mode_T, 3, in);
	res->attr.div.resmode = resmode;
	res->attr.div.no_remainder = 0;
	res->attr.div.exc.pin_state = pin_state;
	res->attr.div.exc.throws_exception = false;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Div(ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_Div(NULL, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_Div(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Div(dbgi, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	return res;
}

ir_node *new_Div(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_Div(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_Dummy(dbg_info *dbgi, ir_graph *irg, ir_mode * mode)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_Dummy, mode, 0, NULL);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Dummy(ir_graph *irg, ir_mode * mode)
{
	return new_rd_Dummy(NULL, irg, mode);
}

ir_node *new_d_Dummy(dbg_info *dbgi, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Dummy(dbgi, current_ir_graph, mode);
	return res;
}

ir_node *new_Dummy(ir_mode * mode)
{
	return new_d_Dummy(NULL, mode);
}

ir_node *new_rd_End(dbg_info *dbgi, ir_graph *irg, int arity, ir_node *const * in)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_end_block(irg), op_End, mode_X, -1, NULL);
	for (int i = 0; i < arity; ++i) {
		add_irn_n(res, in[i]);
	}
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_End(ir_graph *irg, int arity, ir_node *const * in)
{
	return new_rd_End(NULL, irg, arity, in);
}

ir_node *new_d_End(dbg_info *dbgi, int arity, ir_node *const * in)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_End(dbgi, current_ir_graph, arity, in);
	return res;
}

ir_node *new_End(int arity, ir_node *const * in)
{
	return new_d_End(NULL, arity, in);
}

ir_node *new_rd_Eor(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Eor, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Eor(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Eor(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Eor(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Eor(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Eor(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Eor(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Free(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_ptr;
	in[2] = irn_count;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Free, mode_M, 3, in);
	res->attr.free.type = type;
	res->attr.free.where = where;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Free(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	return new_rd_Free(NULL, block, irn_mem, irn_ptr, irn_count, type, where);
}

ir_node *new_d_Free(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Free(dbgi, current_ir_graph->current_block, irn_mem, irn_ptr, irn_count, type, where);
	return res;
}

ir_node *new_Free(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where)
{
	return new_d_Free(NULL, irn_mem, irn_ptr, irn_count, type, where);
}

ir_node *new_rd_IJmp(dbg_info *dbgi, ir_node *block, ir_node * irn_target)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_target;

	ir_node *res = new_ir_node(dbgi, irg, block, op_IJmp, mode_X, 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_IJmp(ir_node *block, ir_node * irn_target)
{
	return new_rd_IJmp(NULL, block, irn_target);
}

ir_node *new_d_IJmp(dbg_info *dbgi, ir_node * irn_target)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_IJmp(dbgi, current_ir_graph->current_block, irn_target);
	return res;
}

ir_node *new_IJmp(ir_node * irn_target)
{
	return new_d_IJmp(NULL, irn_target);
}

ir_node *new_rd_Id(dbg_info *dbgi, ir_node *block, ir_node * irn_pred, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_pred;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Id, mode, 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Id(ir_node *block, ir_node * irn_pred, ir_mode * mode)
{
	return new_rd_Id(NULL, block, irn_pred, mode);
}

ir_node *new_d_Id(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Id(dbgi, current_ir_graph->current_block, irn_pred, mode);
	return res;
}

ir_node *new_Id(ir_node * irn_pred, ir_mode * mode)
{
	return new_d_Id(NULL, irn_pred, mode);
}

ir_node *new_rd_InstOf(dbg_info *dbgi, ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_store;
	in[1] = irn_obj;

	ir_node *res = new_ir_node(dbgi, irg, block, op_InstOf, mode_T, 2, in);
	res->attr.instof.type = type;
	res->attr.instof.exc.pin_state = op_pin_state_floats;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_InstOf(ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	return new_rd_InstOf(NULL, block, irn_store, irn_obj, type);
}

ir_node *new_d_InstOf(dbg_info *dbgi, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_InstOf(dbgi, current_ir_graph->current_block, irn_store, irn_obj, type);
	return res;
}

ir_node *new_InstOf(ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	return new_d_InstOf(NULL, irn_store, irn_obj, type);
}

ir_node *new_rd_Jmp(dbg_info *dbgi, ir_node *block)
{
	ir_graph *irg = get_irn_irg(block);

	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Jmp, mode_X, 0, NULL);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Jmp(ir_node *block)
{
	return new_rd_Jmp(NULL, block);
}

ir_node *new_d_Jmp(dbg_info *dbgi)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Jmp(dbgi, current_ir_graph->current_block);
	return res;
}

ir_node *new_Jmp(void)
{
	return new_d_Jmp(NULL);
}

ir_node *new_rd_Load(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_ptr;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Load, mode_T, 2, in);
	res->attr.load.mode = mode;
	res->attr.load.volatility = flags & cons_volatile ? volatility_is_volatile : volatility_non_volatile;
	res->attr.load.unaligned = flags & cons_unaligned ? align_non_aligned : align_is_aligned;
	res->attr.load.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;
	res->attr.load.exc.throws_exception = (flags & cons_throws_exception) != 0;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Load(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	return new_rd_Load(NULL, block, irn_mem, irn_ptr, mode, flags);
}

ir_node *new_d_Load(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Load(dbgi, current_ir_graph->current_block, irn_mem, irn_ptr, mode, flags);
	return res;
}

ir_node *new_Load(ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	return new_d_Load(NULL, irn_mem, irn_ptr, mode, flags);
}

ir_node *new_rd_Minus(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_op;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Minus, mode, 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Minus(ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Minus(NULL, block, irn_op, mode);
}

ir_node *new_d_Minus(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Minus(dbgi, current_ir_graph->current_block, irn_op, mode);
	return res;
}

ir_node *new_Minus(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Minus(NULL, irn_op, mode);
}

ir_node *new_rd_Mod(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Mod, mode_T, 3, in);
	res->attr.mod.resmode = resmode;
	res->attr.mod.exc.pin_state = pin_state;
	res->attr.mod.exc.throws_exception = false;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Mod(ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_Mod(NULL, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_Mod(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Mod(dbgi, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	return res;
}

ir_node *new_Mod(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_Mod(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_Mul(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Mul, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Mul(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Mul(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Mul(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Mul(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Mul(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Mul(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Mulh(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Mulh, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Mulh(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Mulh(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Mulh(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Mulh(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Mulh(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Mulh(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Mux(dbg_info *dbgi, ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_sel;
	in[1] = irn_false;
	in[2] = irn_true;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Mux, mode, 3, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Mux(ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	return new_rd_Mux(NULL, block, irn_sel, irn_false, irn_true, mode);
}

ir_node *new_d_Mux(dbg_info *dbgi, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Mux(dbgi, current_ir_graph->current_block, irn_sel, irn_false, irn_true, mode);
	return res;
}

ir_node *new_Mux(ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	return new_d_Mux(NULL, irn_sel, irn_false, irn_true, mode);
}

ir_node *new_rd_NoMem(dbg_info *dbgi, ir_graph *irg)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_NoMem, mode_M, 0, NULL);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_NoMem(ir_graph *irg)
{
	return new_rd_NoMem(NULL, irg);
}

ir_node *new_d_NoMem(dbg_info *dbgi)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_NoMem(dbgi, current_ir_graph);
	return res;
}

ir_node *new_NoMem(void)
{
	return new_d_NoMem(NULL);
}

ir_node *new_rd_Not(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_op;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Not, mode, 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Not(ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Not(NULL, block, irn_op, mode);
}

ir_node *new_d_Not(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Not(dbgi, current_ir_graph->current_block, irn_op, mode);
	return res;
}

ir_node *new_Not(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Not(NULL, irn_op, mode);
}

ir_node *new_rd_Or(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Or, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Or(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Or(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Or(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Or(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Or(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Or(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Phi(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Phi, mode, arity, in);
	res->attr.phi.u.backedge = new_backedge_arr(irg->obst, arity);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Phi(ir_node *block, int arity, ir_node *const * in, ir_mode * mode)
{
	return new_rd_Phi(NULL, block, arity, in, mode);
}

ir_node *new_d_Phi(dbg_info *dbgi, int arity, ir_node *const * in, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Phi(dbgi, current_ir_graph->current_block, arity, in, mode);
	return res;
}

ir_node *new_Phi(int arity, ir_node *const * in, ir_mode * mode)
{
	return new_d_Phi(NULL, arity, in, mode);
}

ir_node *new_rd_Pin(dbg_info *dbgi, ir_node *block, ir_node * irn_op)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_op;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Pin, get_irn_mode(irn_op), 1, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Pin(ir_node *block, ir_node * irn_op)
{
	return new_rd_Pin(NULL, block, irn_op);
}

ir_node *new_d_Pin(dbg_info *dbgi, ir_node * irn_op)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Pin(dbgi, current_ir_graph->current_block, irn_op);
	return res;
}

ir_node *new_Pin(ir_node * irn_op)
{
	return new_d_Pin(NULL, irn_op);
}

ir_node *new_rd_Proj(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode, long proj)
{
	ir_graph *irg = get_irn_irg(irn_pred);

	ir_node *in[1];
	in[0] = irn_pred;

	ir_node *res = new_ir_node(dbgi, irg, get_nodes_block(irn_pred), op_Proj, mode, 1, in);
	res->attr.proj.proj = proj;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Proj(ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_rd_Proj(NULL, irn_pred, mode, proj);
}

ir_node *new_d_Proj(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode, long proj)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Proj(dbgi, irn_pred, mode, proj);
	return res;
}

ir_node *new_Proj(ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_d_Proj(NULL, irn_pred, mode, proj);
}

ir_node *new_rd_Raise(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_exo_ptr;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Raise, mode_T, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Raise(ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	return new_rd_Raise(NULL, block, irn_mem, irn_exo_ptr);
}

ir_node *new_d_Raise(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Raise(dbgi, current_ir_graph->current_block, irn_mem, irn_exo_ptr);
	return res;
}

ir_node *new_Raise(ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	return new_d_Raise(NULL, irn_mem, irn_exo_ptr);
}

ir_node *new_rd_Return(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in)
{
	ir_graph *irg = get_irn_irg(block);

	int r_arity = arity + 1;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	memcpy(&r_in[1], in, sizeof(ir_node *) * arity);
	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Return, mode_X, r_arity, r_in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Return(ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in)
{
	return new_rd_Return(NULL, block, irn_mem, arity, in);
}

ir_node *new_d_Return(dbg_info *dbgi, ir_node * irn_mem, int arity, ir_node *const * in)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Return(dbgi, current_ir_graph->current_block, irn_mem, arity, in);
	return res;
}

ir_node *new_Return(ir_node * irn_mem, int arity, ir_node *const * in)
{
	return new_d_Return(NULL, irn_mem, arity, in);
}

ir_node *new_rd_Rotl(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Rotl, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Rotl(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Rotl(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Rotl(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Rotl(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Rotl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Rotl(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Sel(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity)
{
	ir_graph *irg = get_irn_irg(block);

	int r_arity = arity + 2;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	r_in[1] = irn_ptr;
	memcpy(&r_in[2], in, sizeof(ir_node *) * arity);
	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Sel, is_Method_type(get_entity_type(entity)) ? mode_P_code : mode_P_data, r_arity, r_in);
	res->attr.sel.entity = entity;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Sel(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity)
{
	return new_rd_Sel(NULL, block, irn_mem, irn_ptr, arity, in, entity);
}

ir_node *new_d_Sel(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Sel(dbgi, current_ir_graph->current_block, irn_mem, irn_ptr, arity, in, entity);
	return res;
}

ir_node *new_Sel(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity)
{
	return new_d_Sel(NULL, irn_mem, irn_ptr, arity, in, entity);
}

ir_node *new_rd_Shl(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Shl, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Shl(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shl(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shl(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Shl(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Shl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shl(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Shr(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Shr, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Shr(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shr(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shr(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Shr(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Shr(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shr(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Shrs(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Shrs, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Shrs(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shrs(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shrs(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Shrs(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Shrs(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shrs(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Start(dbg_info *dbgi, ir_graph *irg)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_Start, mode_T, 0, NULL);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Start(ir_graph *irg)
{
	return new_rd_Start(NULL, irg);
}

ir_node *new_d_Start(dbg_info *dbgi)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Start(dbgi, current_ir_graph);
	return res;
}

ir_node *new_Start(void)
{
	return new_d_Start(NULL);
}

ir_node *new_rd_Store(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_ptr;
	in[2] = irn_value;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Store, mode_T, 3, in);
	res->attr.store.volatility = flags & cons_volatile ? volatility_is_volatile : volatility_non_volatile;
	res->attr.store.unaligned = flags & cons_unaligned ? align_non_aligned : align_is_aligned;
	res->attr.store.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;
	res->attr.store.exc.throws_exception = (flags & cons_throws_exception) != 0;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Store(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	return new_rd_Store(NULL, block, irn_mem, irn_ptr, irn_value, flags);
}

ir_node *new_d_Store(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Store(dbgi, current_ir_graph->current_block, irn_mem, irn_ptr, irn_value, flags);
	return res;
}

ir_node *new_Store(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	return new_d_Store(NULL, irn_mem, irn_ptr, irn_value, flags);
}

ir_node *new_rd_Sub(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Sub, mode, 2, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Sub(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Sub(NULL, block, irn_left, irn_right, mode);
}

ir_node *new_d_Sub(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Sub(dbgi, current_ir_graph->current_block, irn_left, irn_right, mode);
	return res;
}

ir_node *new_Sub(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Sub(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Switch(dbg_info *dbgi, ir_node *block, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table)
{
	ir_graph *irg = get_irn_irg(block);

	ir_node *in[1];
	in[0] = irn_selector;

	ir_node *res = new_ir_node(dbgi, irg, block, op_Switch, mode_T, 1, in);
	res->attr.switcha.n_outs = n_outs;
	res->attr.switcha.table = table;
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Switch(ir_node *block, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table)
{
	return new_rd_Switch(NULL, block, irn_selector, n_outs, table);
}

ir_node *new_d_Switch(dbg_info *dbgi, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Switch(dbgi, current_ir_graph->current_block, irn_selector, n_outs, table);
	return res;
}

ir_node *new_Switch(ir_node * irn_selector, unsigned n_outs, ir_switch_table* table)
{
	return new_d_Switch(NULL, irn_selector, n_outs, table);
}

ir_node *new_rd_Sync(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in)
{
	ir_graph *irg = get_irn_irg(block);

	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Sync, mode_M, -1, NULL);
	for (int i = 0; i < arity; ++i) {
		add_irn_n(res, in[i]);
	}
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Sync(ir_node *block, int arity, ir_node *const * in)
{
	return new_rd_Sync(NULL, block, arity, in);
}

ir_node *new_d_Sync(dbg_info *dbgi, int arity, ir_node *const * in)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Sync(dbgi, current_ir_graph->current_block, arity, in);
	return res;
}

ir_node *new_Sync(int arity, ir_node *const * in)
{
	return new_d_Sync(NULL, arity, in);
}

ir_node *new_rd_Tuple(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in)
{
	ir_graph *irg = get_irn_irg(block);

	

	ir_node *res = new_ir_node(dbgi, irg, block, op_Tuple, mode_T, arity, in);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Tuple(ir_node *block, int arity, ir_node *const * in)
{
	return new_rd_Tuple(NULL, block, arity, in);
}

ir_node *new_d_Tuple(dbg_info *dbgi, int arity, ir_node *const * in)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Tuple(dbgi, current_ir_graph->current_block, arity, in);
	return res;
}

ir_node *new_Tuple(int arity, ir_node *const * in)
{
	return new_d_Tuple(NULL, arity, in);
}

ir_node *new_rd_Unknown(dbg_info *dbgi, ir_graph *irg, ir_mode * mode)
{
	
	

	ir_node *res = new_ir_node(dbgi, irg, get_irg_start_block(irg), op_Unknown, mode, 0, NULL);
	irn_verify_irg(res, irg);
	res = optimize_node(res);
	return res;
}

ir_node *new_r_Unknown(ir_graph *irg, ir_mode * mode)
{
	return new_rd_Unknown(NULL, irg, mode);
}

ir_node *new_d_Unknown(dbg_info *dbgi, ir_mode * mode)
{
	assert(irg_is_constrained(current_ir_graph, IR_GRAPH_CONSTRAINT_CONSTRUCTION));
	ir_node *res = new_rd_Unknown(dbgi, current_ir_graph, mode);
	return res;
}

ir_node *new_Unknown(ir_mode * mode)
{
	return new_d_Unknown(NULL, mode);
}
