/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit ir/be/sparc/sparc_spec.pl instead.
 *          created by: ir/be/scripts/generate_regalloc_if.pl ir/be/sparc/sparc_spec.pl ir/be/sparc
 * $date    Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include "gen_sparc_regalloc_if.h"
#include "bearch_sparc_t.h"
#include "irmode.h"

static const arch_register_req_t sparc_class_reg_req_fpflags_class = {
	arch_register_req_type_normal,
	&sparc_reg_classes[CLASS_sparc_fpflags_class],
	NULL,
	0,
	0,
	1
};
static const unsigned sparc_limited_fpflags_class_fpflags [] = { (1 << REG_FPFLAGS_CLASS_FPFLAGS) };
static const arch_register_req_t sparc_single_reg_req_fpflags_class_fpflags = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fpflags_class],
	sparc_limited_fpflags_class_fpflags,
	0,
	0,
	1
};
static const arch_register_req_t sparc_class_reg_req_gp = {
	arch_register_req_type_normal,
	&sparc_reg_classes[CLASS_sparc_gp],
	NULL,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l0 [] = { (1 << REG_GP_L0), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l0 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l0,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l1 [] = { (1 << REG_GP_L1), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l1 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l1,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l2 [] = { (1 << REG_GP_L2), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l2 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l2,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l3 [] = { (1 << REG_GP_L3), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l3 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l3,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l4 [] = { (1 << REG_GP_L4), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l4 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l4,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l5 [] = { (1 << REG_GP_L5), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l5 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l5,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l6 [] = { (1 << REG_GP_L6), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l6 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l6,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_l7 [] = { (1 << REG_GP_L7), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_l7 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_l7,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g0 [] = { (1 << REG_GP_G0), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g0 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g0,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g1 [] = { (1 << REG_GP_G1), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g1 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g1,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g2 [] = { (1 << REG_GP_G2), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g2 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g2,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g3 [] = { (1 << REG_GP_G3), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g3 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g3,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g4 [] = { (1 << REG_GP_G4), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g4 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g4,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g5 [] = { (1 << REG_GP_G5), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g5 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g5,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g6 [] = { (1 << REG_GP_G6), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g6 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g6,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_g7 [] = { (1 << REG_GP_G7), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_g7 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_g7,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o0 [] = { (1 << REG_GP_O0), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o0 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o0,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o1 [] = { (1 << REG_GP_O1), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o1 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o1,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o2 [] = { (1 << REG_GP_O2), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o2 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o2,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o3 [] = { (1 << REG_GP_O3), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o3 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o3,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o4 [] = { (1 << REG_GP_O4), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o4 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o4,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o5 [] = { (1 << REG_GP_O5), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o5 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o5,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_sp [] = { (1 << REG_GP_SP), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_sp = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_sp,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_o7 [] = { (1 << REG_GP_O7), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_o7 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_o7,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i0 [] = { (1 << REG_GP_I0), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i0 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i0,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i1 [] = { (1 << REG_GP_I1), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i1 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i1,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i2 [] = { (1 << REG_GP_I2), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i2 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i2,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i3 [] = { (1 << REG_GP_I3), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i3 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i3,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i4 [] = { (1 << REG_GP_I4), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i4 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i4,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i5 [] = { (1 << REG_GP_I5), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i5 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i5,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_frame_pointer [] = { (1 << REG_GP_FRAME_POINTER), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_frame_pointer = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_frame_pointer,
	0,
	0,
	1
};
static const unsigned sparc_limited_gp_i7 [] = { (1 << REG_GP_I7), 0 };
static const arch_register_req_t sparc_single_reg_req_gp_i7 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_gp],
	sparc_limited_gp_i7,
	0,
	0,
	1
};
static const arch_register_req_t sparc_class_reg_req_fp = {
	arch_register_req_type_normal,
	&sparc_reg_classes[CLASS_sparc_fp],
	NULL,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f0 [] = { (1 << REG_FP_F0), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f0 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f0,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f1 [] = { (1 << REG_FP_F1), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f1 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f1,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f2 [] = { (1 << REG_FP_F2), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f2 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f2,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f3 [] = { (1 << REG_FP_F3), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f3 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f3,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f4 [] = { (1 << REG_FP_F4), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f4 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f4,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f5 [] = { (1 << REG_FP_F5), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f5 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f5,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f6 [] = { (1 << REG_FP_F6), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f6 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f6,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f7 [] = { (1 << REG_FP_F7), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f7 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f7,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f8 [] = { (1 << REG_FP_F8), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f8 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f8,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f9 [] = { (1 << REG_FP_F9), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f9 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f9,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f10 [] = { (1 << REG_FP_F10), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f10 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f10,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f11 [] = { (1 << REG_FP_F11), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f11 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f11,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f12 [] = { (1 << REG_FP_F12), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f12 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f12,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f13 [] = { (1 << REG_FP_F13), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f13 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f13,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f14 [] = { (1 << REG_FP_F14), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f14 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f14,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f15 [] = { (1 << REG_FP_F15), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f15 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f15,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f16 [] = { (1 << REG_FP_F16), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f16 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f16,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f17 [] = { (1 << REG_FP_F17), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f17 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f17,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f18 [] = { (1 << REG_FP_F18), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f18 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f18,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f19 [] = { (1 << REG_FP_F19), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f19 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f19,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f20 [] = { (1 << REG_FP_F20), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f20 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f20,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f21 [] = { (1 << REG_FP_F21), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f21 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f21,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f22 [] = { (1 << REG_FP_F22), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f22 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f22,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f23 [] = { (1 << REG_FP_F23), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f23 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f23,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f24 [] = { (1 << REG_FP_F24), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f24 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f24,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f25 [] = { (1 << REG_FP_F25), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f25 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f25,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f26 [] = { (1 << REG_FP_F26), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f26 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f26,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f27 [] = { (1 << REG_FP_F27), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f27 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f27,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f28 [] = { (1 << REG_FP_F28), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f28 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f28,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f29 [] = { (1 << REG_FP_F29), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f29 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f29,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f30 [] = { (1 << REG_FP_F30), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f30 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f30,
	0,
	0,
	1
};
static const unsigned sparc_limited_fp_f31 [] = { (1 << REG_FP_F31), 0 };
static const arch_register_req_t sparc_single_reg_req_fp_f31 = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_fp],
	sparc_limited_fp_f31,
	0,
	0,
	1
};
static const arch_register_req_t sparc_class_reg_req_mul_div_high_res = {
	arch_register_req_type_normal,
	&sparc_reg_classes[CLASS_sparc_mul_div_high_res],
	NULL,
	0,
	0,
	1
};
static const unsigned sparc_limited_mul_div_high_res_y [] = { (1 << REG_MUL_DIV_HIGH_RES_Y) };
static const arch_register_req_t sparc_single_reg_req_mul_div_high_res_y = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_mul_div_high_res],
	sparc_limited_mul_div_high_res_y,
	0,
	0,
	1
};
static const arch_register_req_t sparc_class_reg_req_flags_class = {
	arch_register_req_type_normal,
	&sparc_reg_classes[CLASS_sparc_flags_class],
	NULL,
	0,
	0,
	1
};
static const unsigned sparc_limited_flags_class_flags [] = { (1 << REG_FLAGS_CLASS_FLAGS) };
static const arch_register_req_t sparc_single_reg_req_flags_class_flags = {
	arch_register_req_type_limited,
	&sparc_reg_classes[CLASS_sparc_flags_class],
	sparc_limited_flags_class_flags,
	0,
	0,
	1
};

arch_register_class_t sparc_reg_classes[] = {
	{ 0, "sparc_fpflags_class", 1, NULL, &sparc_registers[REG_FPFLAGS], arch_register_class_flag_manual_ra, &sparc_class_reg_req_fpflags_class },
	{ 1, "sparc_gp", 32, NULL, &sparc_registers[REG_L0], arch_register_class_flag_none, &sparc_class_reg_req_gp },
	{ 2, "sparc_fp", 32, NULL, &sparc_registers[REG_F0], arch_register_class_flag_none, &sparc_class_reg_req_fp },
	{ 3, "sparc_mul_div_high_res", 1, NULL, &sparc_registers[REG_Y], arch_register_class_flag_manual_ra, &sparc_class_reg_req_mul_div_high_res },
	{ 4, "sparc_flags_class", 1, NULL, &sparc_registers[REG_FLAGS], arch_register_class_flag_manual_ra, &sparc_class_reg_req_flags_class }
};


/** The array of all registers in the sparc architecture, sorted by its global index.*/
const arch_register_t sparc_registers[] = {
	{
		"fpflags",
		&sparc_reg_classes[CLASS_sparc_fpflags_class],
		REG_FPFLAGS_CLASS_FPFLAGS,
		REG_FPFLAGS,
		arch_register_type_none,
		&sparc_single_reg_req_fpflags_class_fpflags,
		0
	},
	{
		"l0",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L0,
		REG_L0,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l0,
		16
	},
	{
		"l1",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L1,
		REG_L1,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l1,
		17
	},
	{
		"l2",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L2,
		REG_L2,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l2,
		18
	},
	{
		"l3",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L3,
		REG_L3,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l3,
		19
	},
	{
		"l4",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L4,
		REG_L4,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l4,
		20
	},
	{
		"l5",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L5,
		REG_L5,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l5,
		21
	},
	{
		"l6",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L6,
		REG_L6,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l6,
		22
	},
	{
		"l7",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_L7,
		REG_L7,
		arch_register_type_none,
		&sparc_single_reg_req_gp_l7,
		23
	},
	{
		"g0",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G0,
		REG_G0,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g0,
		0
	},
	{
		"g1",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G1,
		REG_G1,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g1,
		1
	},
	{
		"g2",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G2,
		REG_G2,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g2,
		2
	},
	{
		"g3",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G3,
		REG_G3,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g3,
		3
	},
	{
		"g4",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G4,
		REG_G4,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g4,
		4
	},
	{
		"g5",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G5,
		REG_G5,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g5,
		5
	},
	{
		"g6",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G6,
		REG_G6,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g6,
		6
	},
	{
		"g7",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_G7,
		REG_G7,
		arch_register_type_none,
		&sparc_single_reg_req_gp_g7,
		7
	},
	{
		"o0",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O0,
		REG_O0,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o0,
		8
	},
	{
		"o1",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O1,
		REG_O1,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o1,
		9
	},
	{
		"o2",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O2,
		REG_O2,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o2,
		10
	},
	{
		"o3",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O3,
		REG_O3,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o3,
		11
	},
	{
		"o4",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O4,
		REG_O4,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o4,
		12
	},
	{
		"o5",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O5,
		REG_O5,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o5,
		13
	},
	{
		"sp",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_SP,
		REG_SP,
		arch_register_type_none,
		&sparc_single_reg_req_gp_sp,
		14
	},
	{
		"o7",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_O7,
		REG_O7,
		arch_register_type_none,
		&sparc_single_reg_req_gp_o7,
		15
	},
	{
		"i0",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I0,
		REG_I0,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i0,
		24
	},
	{
		"i1",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I1,
		REG_I1,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i1,
		25
	},
	{
		"i2",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I2,
		REG_I2,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i2,
		26
	},
	{
		"i3",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I3,
		REG_I3,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i3,
		27
	},
	{
		"i4",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I4,
		REG_I4,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i4,
		28
	},
	{
		"i5",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I5,
		REG_I5,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i5,
		29
	},
	{
		"fp",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_FRAME_POINTER,
		REG_FRAME_POINTER,
		arch_register_type_none,
		&sparc_single_reg_req_gp_frame_pointer,
		30
	},
	{
		"i7",
		&sparc_reg_classes[CLASS_sparc_gp],
		REG_GP_I7,
		REG_I7,
		arch_register_type_none,
		&sparc_single_reg_req_gp_i7,
		30
	},
	{
		"f0",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F0,
		REG_F0,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f0,
		32
	},
	{
		"f1",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F1,
		REG_F1,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f1,
		33
	},
	{
		"f2",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F2,
		REG_F2,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f2,
		34
	},
	{
		"f3",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F3,
		REG_F3,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f3,
		35
	},
	{
		"f4",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F4,
		REG_F4,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f4,
		36
	},
	{
		"f5",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F5,
		REG_F5,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f5,
		37
	},
	{
		"f6",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F6,
		REG_F6,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f6,
		38
	},
	{
		"f7",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F7,
		REG_F7,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f7,
		39
	},
	{
		"f8",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F8,
		REG_F8,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f8,
		40
	},
	{
		"f9",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F9,
		REG_F9,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f9,
		41
	},
	{
		"f10",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F10,
		REG_F10,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f10,
		42
	},
	{
		"f11",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F11,
		REG_F11,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f11,
		43
	},
	{
		"f12",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F12,
		REG_F12,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f12,
		44
	},
	{
		"f13",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F13,
		REG_F13,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f13,
		45
	},
	{
		"f14",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F14,
		REG_F14,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f14,
		46
	},
	{
		"f15",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F15,
		REG_F15,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f15,
		47
	},
	{
		"f16",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F16,
		REG_F16,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f16,
		48
	},
	{
		"f17",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F17,
		REG_F17,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f17,
		49
	},
	{
		"f18",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F18,
		REG_F18,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f18,
		50
	},
	{
		"f19",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F19,
		REG_F19,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f19,
		51
	},
	{
		"f20",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F20,
		REG_F20,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f20,
		52
	},
	{
		"f21",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F21,
		REG_F21,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f21,
		53
	},
	{
		"f22",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F22,
		REG_F22,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f22,
		54
	},
	{
		"f23",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F23,
		REG_F23,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f23,
		55
	},
	{
		"f24",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F24,
		REG_F24,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f24,
		56
	},
	{
		"f25",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F25,
		REG_F25,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f25,
		57
	},
	{
		"f26",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F26,
		REG_F26,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f26,
		58
	},
	{
		"f27",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F27,
		REG_F27,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f27,
		59
	},
	{
		"f28",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F28,
		REG_F28,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f28,
		60
	},
	{
		"f29",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F29,
		REG_F29,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f29,
		61
	},
	{
		"f30",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F30,
		REG_F30,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f30,
		62
	},
	{
		"f31",
		&sparc_reg_classes[CLASS_sparc_fp],
		REG_FP_F31,
		REG_F31,
		arch_register_type_none,
		&sparc_single_reg_req_fp_f31,
		63
	},
	{
		"y",
		&sparc_reg_classes[CLASS_sparc_mul_div_high_res],
		REG_MUL_DIV_HIGH_RES_Y,
		REG_Y,
		arch_register_type_none,
		&sparc_single_reg_req_mul_div_high_res_y,
		0
	},
	{
		"flags",
		&sparc_reg_classes[CLASS_sparc_flags_class],
		REG_FLAGS_CLASS_FLAGS,
		REG_FLAGS,
		arch_register_type_none,
		&sparc_single_reg_req_flags_class_flags,
		0
	},

};

/**
 * Initializes sparc register classes.
 */
void sparc_register_init(void)
{
	sparc_reg_classes[CLASS_sparc_fpflags_class].mode = mode_Bu;
	sparc_reg_classes[CLASS_sparc_gp].mode = mode_Iu;
	sparc_reg_classes[CLASS_sparc_fp].mode = mode_F;
	sparc_reg_classes[CLASS_sparc_mul_div_high_res].mode = mode_Iu;
	sparc_reg_classes[CLASS_sparc_flags_class].mode = mode_Bu;

}
