/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit ir/be/ia32/ia32_spec.pl instead.
 *          created by: ir/be/scripts/generate_regalloc_if.pl ir/be/ia32/ia32_spec.pl ir/be/ia32
 * $date    Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include "gen_ia32_regalloc_if.h"
#include "bearch_ia32_t.h"
#include "irmode.h"

static const arch_register_req_t ia32_class_reg_req_xmm = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_xmm],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm0 [] = { (1 << REG_XMM_XMM0) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm0 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm0,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm1 [] = { (1 << REG_XMM_XMM1) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm1 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm1,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm2 [] = { (1 << REG_XMM_XMM2) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm2 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm2,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm3 [] = { (1 << REG_XMM_XMM3) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm3 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm3,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm4 [] = { (1 << REG_XMM_XMM4) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm4 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm4,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm5 [] = { (1 << REG_XMM_XMM5) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm5 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm5,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm6 [] = { (1 << REG_XMM_XMM6) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm6 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm6,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm7 [] = { (1 << REG_XMM_XMM7) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm7 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm7,
	0,
	0,
	1
};
static const unsigned ia32_limited_xmm_xmm_NOREG [] = { (1 << REG_XMM_XMM_NOREG) };
static const arch_register_req_t ia32_single_reg_req_xmm_xmm_NOREG = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_xmm],
	ia32_limited_xmm_xmm_NOREG,
	0,
	0,
	1
};
static const arch_register_req_t ia32_class_reg_req_flags = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_flags],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_flags_eflags [] = { (1 << REG_FLAGS_EFLAGS) };
static const arch_register_req_t ia32_single_reg_req_flags_eflags = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_flags],
	ia32_limited_flags_eflags,
	0,
	0,
	1
};
static const arch_register_req_t ia32_class_reg_req_gp = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_gp],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_edx [] = { (1 << REG_GP_EDX) };
static const arch_register_req_t ia32_single_reg_req_gp_edx = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_edx,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_ecx [] = { (1 << REG_GP_ECX) };
static const arch_register_req_t ia32_single_reg_req_gp_ecx = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_ecx,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_eax [] = { (1 << REG_GP_EAX) };
static const arch_register_req_t ia32_single_reg_req_gp_eax = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_eax,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_ebx [] = { (1 << REG_GP_EBX) };
static const arch_register_req_t ia32_single_reg_req_gp_ebx = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_ebx,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_esi [] = { (1 << REG_GP_ESI) };
static const arch_register_req_t ia32_single_reg_req_gp_esi = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_esi,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_edi [] = { (1 << REG_GP_EDI) };
static const arch_register_req_t ia32_single_reg_req_gp_edi = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_edi,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_ebp [] = { (1 << REG_GP_EBP) };
static const arch_register_req_t ia32_single_reg_req_gp_ebp = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_ebp,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_esp [] = { (1 << REG_GP_ESP) };
static const arch_register_req_t ia32_single_reg_req_gp_esp = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_esp,
	0,
	0,
	1
};
static const unsigned ia32_limited_gp_gp_NOREG [] = { (1 << REG_GP_GP_NOREG) };
static const arch_register_req_t ia32_single_reg_req_gp_gp_NOREG = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_gp],
	ia32_limited_gp_gp_NOREG,
	0,
	0,
	1
};
static const arch_register_req_t ia32_class_reg_req_fp = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_fp],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st0 [] = { (1 << REG_FP_ST0) };
static const arch_register_req_t ia32_single_reg_req_fp_st0 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st0,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st1 [] = { (1 << REG_FP_ST1) };
static const arch_register_req_t ia32_single_reg_req_fp_st1 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st1,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st2 [] = { (1 << REG_FP_ST2) };
static const arch_register_req_t ia32_single_reg_req_fp_st2 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st2,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st3 [] = { (1 << REG_FP_ST3) };
static const arch_register_req_t ia32_single_reg_req_fp_st3 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st3,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st4 [] = { (1 << REG_FP_ST4) };
static const arch_register_req_t ia32_single_reg_req_fp_st4 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st4,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st5 [] = { (1 << REG_FP_ST5) };
static const arch_register_req_t ia32_single_reg_req_fp_st5 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st5,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st6 [] = { (1 << REG_FP_ST6) };
static const arch_register_req_t ia32_single_reg_req_fp_st6 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st6,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_st7 [] = { (1 << REG_FP_ST7) };
static const arch_register_req_t ia32_single_reg_req_fp_st7 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_st7,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_fp_NOREG [] = { (1 << REG_FP_FP_NOREG) };
static const arch_register_req_t ia32_single_reg_req_fp_fp_NOREG = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp],
	ia32_limited_fp_fp_NOREG,
	0,
	0,
	1
};
static const arch_register_req_t ia32_class_reg_req_mmx = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_mmx],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm0 [] = { (1 << REG_MMX_MM0) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm0 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm0,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm1 [] = { (1 << REG_MMX_MM1) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm1 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm1,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm2 [] = { (1 << REG_MMX_MM2) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm2 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm2,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm3 [] = { (1 << REG_MMX_MM3) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm3 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm3,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm4 [] = { (1 << REG_MMX_MM4) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm4 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm4,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm5 [] = { (1 << REG_MMX_MM5) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm5 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm5,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm6 [] = { (1 << REG_MMX_MM6) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm6 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm6,
	0,
	0,
	1
};
static const unsigned ia32_limited_mmx_mm7 [] = { (1 << REG_MMX_MM7) };
static const arch_register_req_t ia32_single_reg_req_mmx_mm7 = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_mmx],
	ia32_limited_mmx_mm7,
	0,
	0,
	1
};
static const arch_register_req_t ia32_class_reg_req_fp_cw = {
	arch_register_req_type_normal,
	&ia32_reg_classes[CLASS_ia32_fp_cw],
	NULL,
	0,
	0,
	1
};
static const unsigned ia32_limited_fp_cw_fpcw [] = { (1 << REG_FP_CW_FPCW) };
static const arch_register_req_t ia32_single_reg_req_fp_cw_fpcw = {
	arch_register_req_type_limited,
	&ia32_reg_classes[CLASS_ia32_fp_cw],
	ia32_limited_fp_cw_fpcw,
	0,
	0,
	1
};

arch_register_class_t ia32_reg_classes[] = {
	{ 0, "ia32_xmm", 9, NULL, &ia32_registers[REG_XMM0], arch_register_class_flag_none, &ia32_class_reg_req_xmm },
	{ 1, "ia32_flags", 1, NULL, &ia32_registers[REG_EFLAGS], arch_register_class_flag_manual_ra, &ia32_class_reg_req_flags },
	{ 2, "ia32_gp", 9, NULL, &ia32_registers[REG_EDX], arch_register_class_flag_none, &ia32_class_reg_req_gp },
	{ 3, "ia32_fp", 9, NULL, &ia32_registers[REG_ST0], arch_register_class_flag_none, &ia32_class_reg_req_fp },
	{ 4, "ia32_mmx", 8, NULL, &ia32_registers[REG_MM0], arch_register_class_flag_manual_ra, &ia32_class_reg_req_mmx },
	{ 5, "ia32_fp_cw", 1, NULL, &ia32_registers[REG_FPCW], arch_register_class_flag_manual_ra|arch_register_class_flag_state, &ia32_class_reg_req_fp_cw }
};


/** The array of all registers in the ia32 architecture, sorted by its global index.*/
const arch_register_t ia32_registers[] = {
	{
		"xmm0",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM0,
		REG_XMM0,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm0,
		21
	},
	{
		"xmm1",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM1,
		REG_XMM1,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm1,
		22
	},
	{
		"xmm2",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM2,
		REG_XMM2,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm2,
		23
	},
	{
		"xmm3",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM3,
		REG_XMM3,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm3,
		24
	},
	{
		"xmm4",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM4,
		REG_XMM4,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm4,
		25
	},
	{
		"xmm5",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM5,
		REG_XMM5,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm5,
		26
	},
	{
		"xmm6",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM6,
		REG_XMM6,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm6,
		27
	},
	{
		"xmm7",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM7,
		REG_XMM7,
		arch_register_type_none,
		&ia32_single_reg_req_xmm_xmm7,
		28
	},
	{
		"xmm_NOREG",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_XMM_NOREG,
		REG_XMM_NOREG,
		arch_register_type_ignore | arch_register_type_virtual,
		&ia32_single_reg_req_xmm_xmm_NOREG,
		0
	},
	{
		"eflags",
		&ia32_reg_classes[CLASS_ia32_flags],
		REG_FLAGS_EFLAGS,
		REG_EFLAGS,
		arch_register_type_none,
		&ia32_single_reg_req_flags_eflags,
		9
	},
	{
		"edx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_EDX,
		REG_EDX,
		arch_register_type_none,
		&ia32_single_reg_req_gp_edx,
		2
	},
	{
		"ecx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_ECX,
		REG_ECX,
		arch_register_type_none,
		&ia32_single_reg_req_gp_ecx,
		1
	},
	{
		"eax",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_EAX,
		REG_EAX,
		arch_register_type_none,
		&ia32_single_reg_req_gp_eax,
		0
	},
	{
		"ebx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_EBX,
		REG_EBX,
		arch_register_type_none,
		&ia32_single_reg_req_gp_ebx,
		3
	},
	{
		"esi",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_ESI,
		REG_ESI,
		arch_register_type_none,
		&ia32_single_reg_req_gp_esi,
		6
	},
	{
		"edi",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_EDI,
		REG_EDI,
		arch_register_type_none,
		&ia32_single_reg_req_gp_edi,
		7
	},
	{
		"ebp",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_EBP,
		REG_EBP,
		arch_register_type_none,
		&ia32_single_reg_req_gp_ebp,
		5
	},
	{
		"esp",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_ESP,
		REG_ESP,
		arch_register_type_ignore,
		&ia32_single_reg_req_gp_esp,
		4
	},
	{
		"gp_NOREG",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_GP_NOREG,
		REG_GP_NOREG,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual,
		&ia32_single_reg_req_gp_gp_NOREG,
		0
	},
	{
		"st",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST0,
		REG_ST0,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st0,
		11
	},
	{
		"st(1)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST1,
		REG_ST1,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st1,
		12
	},
	{
		"st(2)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST2,
		REG_ST2,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st2,
		13
	},
	{
		"st(3)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST3,
		REG_ST3,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st3,
		14
	},
	{
		"st(4)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST4,
		REG_ST4,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st4,
		15
	},
	{
		"st(5)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST5,
		REG_ST5,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st5,
		16
	},
	{
		"st(6)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST6,
		REG_ST6,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st6,
		17
	},
	{
		"st(7)",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_ST7,
		REG_ST7,
		arch_register_type_none,
		&ia32_single_reg_req_fp_st7,
		18
	},
	{
		"fp_NOREG",
		&ia32_reg_classes[CLASS_ia32_fp],
		REG_FP_FP_NOREG,
		REG_FP_NOREG,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual,
		&ia32_single_reg_req_fp_fp_NOREG,
		0
	},
	{
		"mm0",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM0,
		REG_MM0,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm0,
		29
	},
	{
		"mm1",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM1,
		REG_MM1,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm1,
		30
	},
	{
		"mm2",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM2,
		REG_MM2,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm2,
		31
	},
	{
		"mm3",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM3,
		REG_MM3,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm3,
		32
	},
	{
		"mm4",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM4,
		REG_MM4,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm4,
		33
	},
	{
		"mm5",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM5,
		REG_MM5,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm5,
		34
	},
	{
		"mm6",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM6,
		REG_MM6,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm6,
		35
	},
	{
		"mm7",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MMX_MM7,
		REG_MM7,
		arch_register_type_ignore,
		&ia32_single_reg_req_mmx_mm7,
		36
	},
	{
		"fpcw",
		&ia32_reg_classes[CLASS_ia32_fp_cw],
		REG_FP_CW_FPCW,
		REG_FPCW,
		arch_register_type_ignore | arch_register_type_state,
		&ia32_single_reg_req_fp_cw_fpcw,
		37
	},

};

/**
 * Initializes ia32 register classes.
 */
void ia32_register_init(void)
{
	ia32_reg_classes[CLASS_ia32_xmm].mode = mode_D;
	ia32_reg_classes[CLASS_ia32_flags].mode = mode_Iu;
	ia32_reg_classes[CLASS_ia32_gp].mode = mode_Iu;
	ia32_reg_classes[CLASS_ia32_fp].mode = ia32_mode_E;
	ia32_reg_classes[CLASS_ia32_mmx].mode = mode_D;
	ia32_reg_classes[CLASS_ia32_fp_cw].mode = ia32_mode_fpcw;

}
