#include "gen_arm_regalloc_if.h"
#include "irverify_t.h"
#include "fourcc.h"

static int cmp_attr_arm_EmptyReg(const ir_node *a, const ir_node *b) {
	(void) a;
	(void) b;
	return 1;
}


ir_op *op_arm_fConst = NULL;
ir_op *op_arm_Mvf = NULL;
ir_op *op_arm_Ldr = NULL;
ir_op *op_arm_Rsb = NULL;
ir_op *op_arm_Mla = NULL;
ir_op *op_arm_LinkMovPC = NULL;
ir_op *op_arm_Mov = NULL;
ir_op *op_arm_FltX = NULL;
ir_op *op_arm_Or = NULL;
ir_op *op_arm_EmptyReg = NULL;
ir_op *op_arm_Cmp = NULL;
ir_op *op_arm_Smull = NULL;
ir_op *op_arm_Add = NULL;
ir_op *op_arm_LinkLdrPC = NULL;
ir_op *op_arm_Ldf = NULL;
ir_op *op_arm_Mvn = NULL;
ir_op *op_arm_B = NULL;
ir_op *op_arm_LoadStackM3Epilogue = NULL;
ir_op *op_arm_Tst = NULL;
ir_op *op_arm_Umull = NULL;
ir_op *op_arm_Bic = NULL;
ir_op *op_arm_Sub = NULL;
ir_op *op_arm_Mul = NULL;
ir_op *op_arm_Adf = NULL;
ir_op *op_arm_Bl = NULL;
ir_op *op_arm_Stf = NULL;
ir_op *op_arm_Clz = NULL;
ir_op *op_arm_Suf = NULL;
ir_op *op_arm_Cmfe = NULL;
ir_op *op_arm_CopyB = NULL;
ir_op *op_arm_FrameAddr = NULL;
ir_op *op_arm_And = NULL;
ir_op *op_arm_Str = NULL;
ir_op *op_arm_Dvf = NULL;
ir_op *op_arm_SwitchJmp = NULL;
ir_op *op_arm_StoreStackM4Inc = NULL;
ir_op *op_arm_Muf = NULL;
ir_op *op_arm_SymConst = NULL;
ir_op *op_arm_Eor = NULL;
ir_op *op_arm_Jmp = NULL;

ir_op *get_op_arm_fConst(void)         { return op_arm_fConst; }
int    is_arm_fConst(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fConst; }

ir_op *get_op_arm_Mvf(void)         { return op_arm_Mvf; }
int    is_arm_Mvf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mvf; }

ir_op *get_op_arm_Ldr(void)         { return op_arm_Ldr; }
int    is_arm_Ldr(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Ldr; }

ir_op *get_op_arm_Rsb(void)         { return op_arm_Rsb; }
int    is_arm_Rsb(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Rsb; }

ir_op *get_op_arm_Mla(void)         { return op_arm_Mla; }
int    is_arm_Mla(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mla; }

ir_op *get_op_arm_LinkMovPC(void)         { return op_arm_LinkMovPC; }
int    is_arm_LinkMovPC(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_LinkMovPC; }

ir_op *get_op_arm_Mov(void)         { return op_arm_Mov; }
int    is_arm_Mov(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mov; }

ir_op *get_op_arm_FltX(void)         { return op_arm_FltX; }
int    is_arm_FltX(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_FltX; }

ir_op *get_op_arm_Or(void)         { return op_arm_Or; }
int    is_arm_Or(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Or; }

ir_op *get_op_arm_EmptyReg(void)         { return op_arm_EmptyReg; }
int    is_arm_EmptyReg(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_EmptyReg; }

ir_op *get_op_arm_Cmp(void)         { return op_arm_Cmp; }
int    is_arm_Cmp(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Cmp; }

ir_op *get_op_arm_Smull(void)         { return op_arm_Smull; }
int    is_arm_Smull(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Smull; }

ir_op *get_op_arm_Add(void)         { return op_arm_Add; }
int    is_arm_Add(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Add; }

ir_op *get_op_arm_LinkLdrPC(void)         { return op_arm_LinkLdrPC; }
int    is_arm_LinkLdrPC(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_LinkLdrPC; }

ir_op *get_op_arm_Ldf(void)         { return op_arm_Ldf; }
int    is_arm_Ldf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Ldf; }

ir_op *get_op_arm_Mvn(void)         { return op_arm_Mvn; }
int    is_arm_Mvn(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mvn; }

ir_op *get_op_arm_B(void)         { return op_arm_B; }
int    is_arm_B(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_B; }

ir_op *get_op_arm_LoadStackM3Epilogue(void)         { return op_arm_LoadStackM3Epilogue; }
int    is_arm_LoadStackM3Epilogue(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_LoadStackM3Epilogue; }

ir_op *get_op_arm_Tst(void)         { return op_arm_Tst; }
int    is_arm_Tst(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Tst; }

ir_op *get_op_arm_Umull(void)         { return op_arm_Umull; }
int    is_arm_Umull(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Umull; }

ir_op *get_op_arm_Bic(void)         { return op_arm_Bic; }
int    is_arm_Bic(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Bic; }

ir_op *get_op_arm_Sub(void)         { return op_arm_Sub; }
int    is_arm_Sub(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Sub; }

ir_op *get_op_arm_Mul(void)         { return op_arm_Mul; }
int    is_arm_Mul(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mul; }

ir_op *get_op_arm_Adf(void)         { return op_arm_Adf; }
int    is_arm_Adf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Adf; }

ir_op *get_op_arm_Bl(void)         { return op_arm_Bl; }
int    is_arm_Bl(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Bl; }

ir_op *get_op_arm_Stf(void)         { return op_arm_Stf; }
int    is_arm_Stf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Stf; }

ir_op *get_op_arm_Clz(void)         { return op_arm_Clz; }
int    is_arm_Clz(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Clz; }

ir_op *get_op_arm_Suf(void)         { return op_arm_Suf; }
int    is_arm_Suf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Suf; }

ir_op *get_op_arm_Cmfe(void)         { return op_arm_Cmfe; }
int    is_arm_Cmfe(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Cmfe; }

ir_op *get_op_arm_CopyB(void)         { return op_arm_CopyB; }
int    is_arm_CopyB(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_CopyB; }

ir_op *get_op_arm_FrameAddr(void)         { return op_arm_FrameAddr; }
int    is_arm_FrameAddr(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_FrameAddr; }

ir_op *get_op_arm_And(void)         { return op_arm_And; }
int    is_arm_And(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_And; }

ir_op *get_op_arm_Str(void)         { return op_arm_Str; }
int    is_arm_Str(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Str; }

ir_op *get_op_arm_Dvf(void)         { return op_arm_Dvf; }
int    is_arm_Dvf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Dvf; }

ir_op *get_op_arm_SwitchJmp(void)         { return op_arm_SwitchJmp; }
int    is_arm_SwitchJmp(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_SwitchJmp; }

ir_op *get_op_arm_StoreStackM4Inc(void)         { return op_arm_StoreStackM4Inc; }
int    is_arm_StoreStackM4Inc(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_StoreStackM4Inc; }

ir_op *get_op_arm_Muf(void)         { return op_arm_Muf; }
int    is_arm_Muf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Muf; }

ir_op *get_op_arm_SymConst(void)         { return op_arm_SymConst; }
int    is_arm_SymConst(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_SymConst; }

ir_op *get_op_arm_Eor(void)         { return op_arm_Eor; }
int    is_arm_Eor(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Eor; }

ir_op *get_op_arm_Jmp(void)         { return op_arm_Jmp; }
int    is_arm_Jmp(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Jmp; }



static int arm_opcode_start = -1;
static int arm_opcode_end   = -1;


/** A tag for the arm opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define arm_op_tag FOURCC('A', 'R', 'M', '\0')

/** Return the opcode number of the first arm opcode. */
int get_arm_opcode_first(void) {
	return arm_opcode_start;
}

/** Return the opcode number of the last arm opcode + 1. */
int get_arm_opcode_last(void) {
	return arm_opcode_end;
}

/** Return 1 if the given opcode is a arm machine op, 0 otherwise */
int is_arm_op(const ir_op *op) {
	return get_op_tag(op) == arm_op_tag;
}

/** Return 1 if the given node is a arm machine node, 0 otherwise */
int is_arm_irn(const ir_node *node) {
	return is_arm_op(get_irn_op(node));
}

int get_arm_irn_opcode(const ir_node *node) {
	if (is_arm_irn(node))
		return get_irn_opcode(node) - arm_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x))

static const unsigned arm_limit_gp_sp[] = { BIT(REG_GP_SP), 0 };
static const unsigned arm_limit_gp_r11[] = { BIT(REG_GP_R11), 0 };
static const unsigned arm_limit_gp_pc[] = { BIT(REG_GP_PC), 0 };

static const arch_register_req_t arm_requirements_fpa_fpa = {
	arch_register_req_type_normal,
	& arm_reg_classes[CLASS_arm_fpa],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t arm_requirements_gp_gp = {
	arch_register_req_type_normal,
	& arm_reg_classes[CLASS_arm_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t arm_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0,                            /* different pos */
	0                             /* width */
};


static const arch_register_req_t arm_requirements_gp_not_in_r1 = {
	arch_register_req_type_must_be_different,
	& arm_reg_classes[CLASS_arm_gp],
	NULL,
	0,        /* same pos */
	1,       /* different pos */
	1             /* width */
};


static const arch_register_req_t arm_requirements_flags_flags = {
	arch_register_req_type_normal,
	& arm_reg_classes[CLASS_arm_flags],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0,           /* different pos */
	1            /* width */
};


static const arch_register_req_t arm_requirements_gp_sp = {
	arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t arm_requirements_gp_r11_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_r11,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t arm_requirements_gp_sp_I_S = {
	arch_register_req_type_ignore | arch_register_req_type_produces_sp | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t arm_requirements_gp_pc_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_pc,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};


static const arch_register_req_t arm_requirements_gp_not_sp = {
	arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_sp,
	0,        /* same pos */
	0,       /* different pos */
	1             /* width */
};



/**
 * construct fConst node
 */
ir_node *new_bd_arm_fConst(dbg_info *dbgi, ir_node *block, ir_tarval *tv)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_fConst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = get_tarval_mode(tv);
	static const arch_register_req_t **in_reqs = NULL;
	arm_fConst_attr_t *attr;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	attr = (arm_fConst_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
	attr->tv = tv;
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mvf node
 */
ir_node *new_bd_arm_Mvf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mvf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ldr node
 */
ir_node *new_bd_arm_Ldr(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Ldr;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_load_store_attributes(res, ls_mode, entity, entity_sign, offset, is_frame_entity);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;
	info->out_infos[1].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Rsb;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Rsb;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Rsb;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Rsb node
 */
ir_node *new_bd_arm_Rsb_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Rsb;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mla node
 */
ir_node *new_bd_arm_Mla(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mla;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_not_in_r1;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct LinkMovPC node
 */
ir_node *new_bd_arm_LinkMovPC(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, arm_shift_modifier_t shift_modifier, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_LinkMovPC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, shift_modifier, immediate_rot);
	arch_add_irn_flags(res, arch_irn_flags_modify_flags);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_imm(dbg_info *dbgi, ir_node *block, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mov;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *op0, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mov;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mov;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mov node
 */
ir_node *new_bd_arm_Mov_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mov;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct FltX node
 */
ir_node *new_bd_arm_FltX(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_FltX;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Or node
 */
ir_node *new_bd_arm_Or_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Or;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct EmptyReg node
 */
ir_node *new_bd_arm_EmptyReg(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_EmptyReg;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmp node
 */
ir_node *new_bd_arm_Cmp_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Cmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Smull node
 */
ir_node *new_bd_arm_Smull(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Smull;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;
	info->out_infos[1].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Add node
 */
ir_node *new_bd_arm_Add_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Add;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct LinkLdrPC node
 */
ir_node *new_bd_arm_LinkLdrPC(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_LinkLdrPC;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_load_store_attributes(res, ls_mode, entity, entity_sign, offset, is_frame_entity);
	arch_add_irn_flags(res, arch_irn_flags_modify_flags);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Ldf node
 */
ir_node *new_bd_arm_Ldf(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Ldf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_load_store_attributes(res, ls_mode, entity, entity_sign, offset, is_frame_entity);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;
	info->out_infos[1].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_imm(dbg_info *dbgi, ir_node *block, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mvn;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *op0, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mvn;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mvn;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mvn node
 */
ir_node *new_bd_arm_Mvn_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mvn;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct B node
 */
ir_node *new_bd_arm_B(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_relation relation)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_B;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_flags_flags,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;
	info->out_infos[1].req = &arm_requirements__none;


	attr = (arm_CondJmp_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
		set_arm_CondJmp_relation(res, relation);
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct LoadStackM3Epilogue node
 */
ir_node *new_bd_arm_LoadStackM3Epilogue(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_LoadStackM3Epilogue;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 4;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_r11_I;
	info->out_infos[1].req = &arm_requirements_gp_sp_I_S;
	info->out_infos[2].req = &arm_requirements_gp_pc_I;
	info->out_infos[3].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Tst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Tst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Tst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Tst node
 */
ir_node *new_bd_arm_Tst_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier, bool ins_permuted, bool is_unsigned)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Tst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	init_arm_cmp_attr(res, ins_permuted, is_unsigned);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Umull node
 */
ir_node *new_bd_arm_Umull(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Umull;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;
	info->out_infos[1].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Bic;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Bic;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Bic;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bic node
 */
ir_node *new_bd_arm_Bic_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Bic;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Sub node
 */
ir_node *new_bd_arm_Sub_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Sub;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Mul node
 */
ir_node *new_bd_arm_Mul(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Mul;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_not_in_r1;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Adf node
 */
ir_node *new_bd_arm_Adf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Adf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Bl node
 */
ir_node *new_bd_arm_Bl(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_entity *entity, int symconst_offset)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Bl;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t **in_reqs = NULL;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_SymConst_attributes(res, entity, symconst_offset);
	arch_add_irn_flags(res, arch_irn_flags_modify_flags);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Stf node
 */
ir_node *new_bd_arm_Stf(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Stf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = val;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_load_store_attributes(res, ls_mode, entity, entity_sign, offset, is_frame_entity);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Clz node
 */
ir_node *new_bd_arm_Clz(dbg_info *dbgi, ir_node *block, ir_node *op0)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Clz;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Suf node
 */
ir_node *new_bd_arm_Suf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Suf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Cmfe node
 */
ir_node *new_bd_arm_Cmfe(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, bool ins_permuted)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Cmfe;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Bu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	arm_cmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;
	irn_flags_ |= arch_irn_flags_modify_flags;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_flags_flags;


	attr = (arm_cmp_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
	init_arm_cmp_attr(res, ins_permuted, false);
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct CopyB node
 */
ir_node *new_bd_arm_CopyB(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5, unsigned size)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_CopyB;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 6;
	ir_node        *in[6];
	int             n_res   = 1;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_not_sp,
		& arm_requirements_gp_not_sp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;
	in[3] = op3;
	in[4] = op4;
	in[5] = op5;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_CopyB_attributes(res, size);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct FrameAddr node
 */
ir_node *new_bd_arm_FrameAddr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_entity *entity, int symconst_offset)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_FrameAddr;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = base;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_SymConst_attributes(res, entity, symconst_offset);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_arm_And_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct And node
 */
ir_node *new_bd_arm_And_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_And;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Str node
 */
ir_node *new_bd_arm_Str(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int entity_sign, long offset, bool is_frame_entity)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Str;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_M;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = val;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_load_store_attributes(res, ls_mode, entity, entity_sign, offset, is_frame_entity);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Dvf node
 */
ir_node *new_bd_arm_Dvf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Dvf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 2;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;
	info->out_infos[1].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SwitchJmp node
 */
ir_node *new_bd_arm_SwitchJmp(dbg_info *dbgi, ir_node *block, ir_node *op0, int n_res, const ir_switch_table *table)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_SwitchJmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_SwitchJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;


	attr = (arm_SwitchJmp_attr_t*)get_irn_generic_attr(res);
	(void) attr; /* avoid potential warning */
	init_arm_SwitchJmp_attributes(res, table);
	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct StoreStackM4Inc node
 */
ir_node *new_bd_arm_StoreStackM4Inc(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_StoreStackM4Inc;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 6;
	ir_node        *in[6];
	int             n_res   = 2;
	ir_mode        *mode    = mode_T;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;
	in[3] = op3;
	in[4] = op4;
	in[5] = op5;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_sp_I_S;
	info->out_infos[1].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Muf node
 */
ir_node *new_bd_arm_Muf(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Muf;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_F;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_farith_attributes(res, op_mode);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_fpa_fpa;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct SymConst node
 */
ir_node *new_bd_arm_SymConst(dbg_info *dbgi, ir_node *block, ir_entity *entity, int symconst_offset)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_SymConst;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	init_arm_SymConst_attributes(res, entity, symconst_offset);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, unsigned char immediate_value, unsigned char immediate_rot)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Eor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 1;
	ir_node        *in[1];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, immediate_value, ARM_SHF_IMM, immediate_rot);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg_shift_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, arm_shift_modifier_t shift_modifier, unsigned shift_immediate)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Eor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, shift_immediate);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Eor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 2;
	ir_node        *in[2];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, ARM_SHF_REG, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Eor node
 */
ir_node *new_bd_arm_Eor_reg_shift_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *shift, arm_shift_modifier_t shift_modifier)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Eor;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 3;
	ir_node        *in[3];
	int             n_res   = 1;
	ir_mode        *mode    = mode_Iu;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;
	in[2] = shift;

	/* flags */
	irn_flags_ |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);

	init_arm_shifter_operand(res, 0, shift_modifier, 0);
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements_gp_gp;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}

/**
 * construct Jmp node
 */
ir_node *new_bd_arm_Jmp(dbg_info *dbgi, ir_node *block)
{
	ir_graph         *irg        = get_irn_irg(block);
	ir_op            *op         = op_arm_Jmp;
	arch_irn_flags_t  irn_flags_ = arch_irn_flags_none;
	ir_node          *res;
	backend_info_t   *info;
	int             arity   = 0;
	ir_node       **in      = NULL;
	int             n_res   = 1;
	ir_mode        *mode    = mode_X;
	static const arch_register_req_t **in_reqs = NULL;

	/* flags */
	irn_flags_ |= arch_irn_flags_simple_jump;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(dbgi, irg, block, op, mode, arity, in);

	/* init node attributes */
		init_arm_attributes(res, irn_flags_, in_reqs, n_res);
	
	info = be_get_info(res);
	(void) info; /* avoid potential warning */
	info->out_infos[0].req = &arm_requirements__none;


	/* optimize node */
	res = optimize_node(res);
	irn_verify_irg(res, irg);

	return res;
}



/**
 * Creates the arm specific Firm machine operations
 * needed for the assembler irgs.
 */
void arm_create_opcodes(const arch_irn_ops_t *be_ops)
{
	ir_op *op;
	int    cur_opcode = get_next_ir_opcodes(iro_arm_last);

	arm_opcode_start = cur_opcode;
	op = new_ir_op(cur_opcode + iro_arm_fConst, "arm_fConst", op_pin_state_floats, irop_flag_constlike, oparity_zero, 0, sizeof(arm_fConst_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_fConst;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_fConst = op;
	op = new_ir_op(cur_opcode + iro_arm_Mvf, "arm_Mvf", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Mvf = op;
	op = new_ir_op(cur_opcode + iro_arm_Ldr, "arm_Ldr", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(arm_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_load_store;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Ldr = op;
	op = new_ir_op(cur_opcode + iro_arm_Rsb, "arm_Rsb", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Rsb = op;
	op = new_ir_op(cur_opcode + iro_arm_Mla, "arm_Mla", op_pin_state_floats, irop_flag_none, oparity_trinary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Mla = op;
	op = new_ir_op(cur_opcode + iro_arm_LinkMovPC, "arm_LinkMovPC", op_pin_state_exc_pinned, irop_flag_none, oparity_variable, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_LinkMovPC = op;
	op = new_ir_op(cur_opcode + iro_arm_Mov, "arm_Mov", op_pin_state_floats, irop_flag_none, oparity_variable, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Mov = op;
	op = new_ir_op(cur_opcode + iro_arm_FltX, "arm_FltX", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_FltX = op;
	op = new_ir_op(cur_opcode + iro_arm_Or, "arm_Or", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Or = op;
	op = new_ir_op(cur_opcode + iro_arm_EmptyReg, "arm_EmptyReg", op_pin_state_floats, irop_flag_constlike, oparity_zero, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_EmptyReg;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_EmptyReg = op;
	op = new_ir_op(cur_opcode + iro_arm_Cmp, "arm_Cmp", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_cmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_cmp;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Cmp = op;
	op = new_ir_op(cur_opcode + iro_arm_Smull, "arm_Smull", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Smull = op;
	op = new_ir_op(cur_opcode + iro_arm_Add, "arm_Add", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Add = op;
	op = new_ir_op(cur_opcode + iro_arm_LinkLdrPC, "arm_LinkLdrPC", op_pin_state_exc_pinned, irop_flag_none, oparity_variable, 0, sizeof(arm_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_load_store;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_LinkLdrPC = op;
	op = new_ir_op(cur_opcode + iro_arm_Ldf, "arm_Ldf", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(arm_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_load_store;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Ldf = op;
	op = new_ir_op(cur_opcode + iro_arm_Mvn, "arm_Mvn", op_pin_state_floats, irop_flag_none, oparity_variable, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Mvn = op;
	op = new_ir_op(cur_opcode + iro_arm_B, "arm_B", op_pin_state_pinned, irop_flag_cfopcode|irop_flag_forking, oparity_unary, 0, sizeof(arm_CondJmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_B = op;
	op = new_ir_op(cur_opcode + iro_arm_LoadStackM3Epilogue, "arm_LoadStackM3Epilogue", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_binary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_LoadStackM3Epilogue = op;
	op = new_ir_op(cur_opcode + iro_arm_Tst, "arm_Tst", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_cmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_cmp;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Tst = op;
	op = new_ir_op(cur_opcode + iro_arm_Umull, "arm_Umull", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Umull = op;
	op = new_ir_op(cur_opcode + iro_arm_Bic, "arm_Bic", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Bic = op;
	op = new_ir_op(cur_opcode + iro_arm_Sub, "arm_Sub", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Sub = op;
	op = new_ir_op(cur_opcode + iro_arm_Mul, "arm_Mul", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Mul = op;
	op = new_ir_op(cur_opcode + iro_arm_Adf, "arm_Adf", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Adf = op;
	op = new_ir_op(cur_opcode + iro_arm_Bl, "arm_Bl", op_pin_state_exc_pinned, irop_flag_none, oparity_variable, 0, sizeof(arm_SymConst_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_SymConst;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Bl = op;
	op = new_ir_op(cur_opcode + iro_arm_Stf, "arm_Stf", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(arm_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_load_store;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Stf = op;
	op = new_ir_op(cur_opcode + iro_arm_Clz, "arm_Clz", op_pin_state_floats, irop_flag_none, oparity_unary, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Clz = op;
	op = new_ir_op(cur_opcode + iro_arm_Suf, "arm_Suf", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Suf = op;
	op = new_ir_op(cur_opcode + iro_arm_Cmfe, "arm_Cmfe", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_cmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_cmp;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Cmfe = op;
	op = new_ir_op(cur_opcode + iro_arm_CopyB, "arm_CopyB", op_pin_state_pinned, irop_flag_none, oparity_any, 0, sizeof(arm_CopyB_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_CopyB;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_CopyB = op;
	op = new_ir_op(cur_opcode + iro_arm_FrameAddr, "arm_FrameAddr", op_pin_state_floats, irop_flag_constlike, oparity_unary, 0, sizeof(arm_SymConst_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_SymConst;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_FrameAddr = op;
	op = new_ir_op(cur_opcode + iro_arm_And, "arm_And", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_And = op;
	op = new_ir_op(cur_opcode + iro_arm_Str, "arm_Str", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_trinary, 0, sizeof(arm_load_store_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_load_store;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Str = op;
	op = new_ir_op(cur_opcode + iro_arm_Dvf, "arm_Dvf", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Dvf = op;
	op = new_ir_op(cur_opcode + iro_arm_SwitchJmp, "arm_SwitchJmp", op_pin_state_pinned, irop_flag_cfopcode|irop_flag_forking, oparity_unary, 0, sizeof(arm_SwitchJmp_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_SwitchJmp;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_SwitchJmp = op;
	op = new_ir_op(cur_opcode + iro_arm_StoreStackM4Inc, "arm_StoreStackM4Inc", op_pin_state_exc_pinned, irop_flag_uses_memory, oparity_any, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_StoreStackM4Inc = op;
	op = new_ir_op(cur_opcode + iro_arm_Muf, "arm_Muf", op_pin_state_floats, irop_flag_none, oparity_binary, 0, sizeof(arm_farith_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_farith;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Muf = op;
	op = new_ir_op(cur_opcode + iro_arm_SymConst, "arm_SymConst", op_pin_state_floats, irop_flag_constlike, oparity_zero, 0, sizeof(arm_SymConst_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_SymConst;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_SymConst = op;
	op = new_ir_op(cur_opcode + iro_arm_Eor, "arm_Eor", op_pin_state_floats, irop_flag_none, oparity_zero, 0, sizeof(arm_shifter_operand_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm_shifter_operand;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Eor = op;
	op = new_ir_op(cur_opcode + iro_arm_Jmp, "arm_Jmp", op_pin_state_pinned, irop_flag_cfopcode, oparity_zero, 0, sizeof(arm_attr_t));
	op->ops.be_ops        = be_ops;
	op->ops.dump_node     = arm_dump_node;
	op->ops.node_cmp_attr = cmp_attr_arm;
	op->ops.copy_attr     = arm_copy_attr;
	set_op_tag(op, arm_op_tag);
	op_arm_Jmp = op;

	arm_opcode_end = cur_opcode + iro_arm_last;
}

void arm_free_opcodes(void)
{
	free_ir_op(op_arm_fConst); op_arm_fConst = NULL;
	free_ir_op(op_arm_Mvf); op_arm_Mvf = NULL;
	free_ir_op(op_arm_Ldr); op_arm_Ldr = NULL;
	free_ir_op(op_arm_Rsb); op_arm_Rsb = NULL;
	free_ir_op(op_arm_Mla); op_arm_Mla = NULL;
	free_ir_op(op_arm_LinkMovPC); op_arm_LinkMovPC = NULL;
	free_ir_op(op_arm_Mov); op_arm_Mov = NULL;
	free_ir_op(op_arm_FltX); op_arm_FltX = NULL;
	free_ir_op(op_arm_Or); op_arm_Or = NULL;
	free_ir_op(op_arm_EmptyReg); op_arm_EmptyReg = NULL;
	free_ir_op(op_arm_Cmp); op_arm_Cmp = NULL;
	free_ir_op(op_arm_Smull); op_arm_Smull = NULL;
	free_ir_op(op_arm_Add); op_arm_Add = NULL;
	free_ir_op(op_arm_LinkLdrPC); op_arm_LinkLdrPC = NULL;
	free_ir_op(op_arm_Ldf); op_arm_Ldf = NULL;
	free_ir_op(op_arm_Mvn); op_arm_Mvn = NULL;
	free_ir_op(op_arm_B); op_arm_B = NULL;
	free_ir_op(op_arm_LoadStackM3Epilogue); op_arm_LoadStackM3Epilogue = NULL;
	free_ir_op(op_arm_Tst); op_arm_Tst = NULL;
	free_ir_op(op_arm_Umull); op_arm_Umull = NULL;
	free_ir_op(op_arm_Bic); op_arm_Bic = NULL;
	free_ir_op(op_arm_Sub); op_arm_Sub = NULL;
	free_ir_op(op_arm_Mul); op_arm_Mul = NULL;
	free_ir_op(op_arm_Adf); op_arm_Adf = NULL;
	free_ir_op(op_arm_Bl); op_arm_Bl = NULL;
	free_ir_op(op_arm_Stf); op_arm_Stf = NULL;
	free_ir_op(op_arm_Clz); op_arm_Clz = NULL;
	free_ir_op(op_arm_Suf); op_arm_Suf = NULL;
	free_ir_op(op_arm_Cmfe); op_arm_Cmfe = NULL;
	free_ir_op(op_arm_CopyB); op_arm_CopyB = NULL;
	free_ir_op(op_arm_FrameAddr); op_arm_FrameAddr = NULL;
	free_ir_op(op_arm_And); op_arm_And = NULL;
	free_ir_op(op_arm_Str); op_arm_Str = NULL;
	free_ir_op(op_arm_Dvf); op_arm_Dvf = NULL;
	free_ir_op(op_arm_SwitchJmp); op_arm_SwitchJmp = NULL;
	free_ir_op(op_arm_StoreStackM4Inc); op_arm_StoreStackM4Inc = NULL;
	free_ir_op(op_arm_Muf); op_arm_Muf = NULL;
	free_ir_op(op_arm_SymConst); op_arm_SymConst = NULL;
	free_ir_op(op_arm_Eor); op_arm_Eor = NULL;
	free_ir_op(op_arm_Jmp); op_arm_Jmp = NULL;
}
