/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit ir/be/amd64/amd64_spec.pl instead.
 *         created by: ir/be/scripts/generate_regalloc_if.pl ir/be/amd64/amd64_spec.pl ir/be/amd64
 * @date   Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_AMD64_GEN_AMD64_REGALLOC_IF_H
#define FIRM_BE_AMD64_GEN_AMD64_REGALLOC_IF_H

#include "bearch.h"
#include "amd64_nodes_attr.h"

/** global register indices for amd64 registers */
enum reg_indices {
	REG_EFLAGS,
	REG_RAX,
	REG_RCX,
	REG_RDX,
	REG_RSI,
	REG_RDI,
	REG_RBX,
	REG_RBP,
	REG_RSP,
	REG_R8,
	REG_R9,
	REG_R10,
	REG_R11,
	REG_R12,
	REG_R13,
	REG_R14,
	REG_R15,

	N_AMD64_REGISTERS
};
/** local register indices for amd64 registers */
enum {
	REG_FLAGS_EFLAGS = 0,
	REG_GP_RAX = 0,
	REG_GP_RCX = 1,
	REG_GP_RDX = 2,
	REG_GP_RSI = 3,
	REG_GP_RDI = 4,
	REG_GP_RBX = 5,
	REG_GP_RBP = 6,
	REG_GP_RSP = 7,
	REG_GP_R8 = 8,
	REG_GP_R9 = 9,
	REG_GP_R10 = 10,
	REG_GP_R11 = 11,
	REG_GP_R12 = 12,
	REG_GP_R13 = 13,
	REG_GP_R14 = 14,
	REG_GP_R15 = 15,

};

/** number of registers in amd64 register classes. */
enum {
	N_amd64_flags_REGS = 1,
	N_amd64_gp_REGS = 16,

};
enum reg_classes {
	CLASS_amd64_flags = 0,
	CLASS_amd64_gp = 1,
	N_AMD64_CLASSES = 2
};



extern const arch_register_t amd64_registers[N_AMD64_REGISTERS];

extern arch_register_class_t amd64_reg_classes[N_AMD64_CLASSES];

void amd64_register_init(void);

#endif
