/*
 * Library checksum functions test program
 *
 * Copyright (C) 2006-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <memory.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "ewf_test_libcerror.h"
#include "ewf_test_libcnotify.h"
#include "ewf_test_libewf.h"
#include "ewf_test_macros.h"
#include "ewf_test_unused.h"

#include "../libewf/libewf_checksum.h"
#include "../libewf/libewf_deflate.h"

/* Define to make ewf_test_checksum generate verbose output
#define EWF_TEST_CHECKSUM
 */

uint8_t ewf_test_checksum_uncompressed_byte_stream[ 7640 ] = {
	0x09, 0x09, 0x20, 0x20, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x45, 0x53, 0x53, 0x45, 0x52, 0x20,
	0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x4c, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x4c,
	0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x33, 0x2c, 0x20, 0x32, 0x39, 0x20, 0x4a, 0x75, 0x6e, 0x65,
	0x20, 0x32, 0x30, 0x30, 0x37, 0x0a, 0x0a, 0x20, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x20, 0x28, 0x43, 0x29, 0x20, 0x32, 0x30, 0x30, 0x37, 0x20, 0x46, 0x72, 0x65, 0x65, 0x20,
	0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20, 0x3c, 0x68, 0x74, 0x74, 0x70, 0x3a,
	0x2f, 0x2f, 0x66, 0x73, 0x66, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x3e, 0x0a, 0x20, 0x45, 0x76, 0x65,
	0x72, 0x79, 0x6f, 0x6e, 0x65, 0x20, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74,
	0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x64,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x76, 0x65, 0x72, 0x62, 0x61, 0x74,
	0x69, 0x6d, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x73, 0x0a, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x69, 0x6e,
	0x67, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x2e, 0x0a, 0x0a, 0x0a, 0x20, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55,
	0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x20, 0x69,
	0x6e, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x0a, 0x74, 0x68, 0x65, 0x20,
	0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20,
	0x33, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x0a, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x2c, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x65,
	0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20,
	0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x77, 0x2e, 0x0a, 0x0a, 0x20,
	0x20, 0x30, 0x2e, 0x20, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x20,
	0x41, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x68, 0x65, 0x72, 0x65, 0x69, 0x6e, 0x2c, 0x20,
	0x22, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x22, 0x20, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x20, 0x33, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65,
	0x73, 0x73, 0x65, 0x72, 0x0a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x47, 0x4e, 0x55, 0x20, 0x47, 0x50, 0x4c, 0x22, 0x20, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x20, 0x33, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x0a, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x22, 0x54, 0x68, 0x65, 0x20, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x22, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f,
	0x20, 0x61, 0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20,
	0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x0a, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x61, 0x73, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x77, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x41, 0x6e, 0x20, 0x22,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x6e, 0x79, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x6d, 0x61,
	0x6b, 0x65, 0x73, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64,
	0x0a, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2c,
	0x20, 0x62, 0x75, 0x74, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f,
	0x74, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x77, 0x69, 0x73, 0x65, 0x20, 0x62, 0x61, 0x73, 0x65,
	0x64, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x2e, 0x0a, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x20, 0x73, 0x75, 0x62,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x69, 0x73, 0x20, 0x64, 0x65, 0x65, 0x6d, 0x65,
	0x64, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x0a, 0x6f, 0x66, 0x20, 0x75, 0x73, 0x69, 0x6e,
	0x67, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x20, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x41, 0x20, 0x22, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x22, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20,
	0x62, 0x79, 0x20, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x72, 0x20,
	0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e, 0x0a, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x0a,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x77, 0x61, 0x73,
	0x20, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64,
	0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x54, 0x68,
	0x65, 0x20, 0x22, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x20, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20,
	0x57, 0x6f, 0x72, 0x6b, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x43,
	0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x2c, 0x20, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x0a, 0x66, 0x6f, 0x72, 0x20, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2c, 0x20, 0x63, 0x6f, 0x6e,
	0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x69, 0x73, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x72, 0x65, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20,
	0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6f, 0x6e, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x22, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61,
	0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x6d,
	0x65, 0x61, 0x6e, 0x73, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20,
	0x63, 0x6f, 0x64, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x2f, 0x6f, 0x72, 0x20, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x64, 0x61, 0x74, 0x61, 0x0a,
	0x61, 0x6e, 0x64, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x73, 0x20, 0x6e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x72, 0x65, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x66, 0x72,
	0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e,
	0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x2e, 0x0a, 0x0a, 0x20, 0x20,
	0x31, 0x2e, 0x20, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20,
	0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x33, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x47, 0x4e, 0x55, 0x20, 0x47, 0x50, 0x4c, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x59, 0x6f, 0x75,
	0x20, 0x6d, 0x61, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x20, 0x61, 0x20, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x65, 0x64, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72,
	0x20, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x33, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x34, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x0a, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x62, 0x79, 0x20, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x33, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x47, 0x50,
	0x4c, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x32, 0x2e, 0x20, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x69,
	0x6e, 0x67, 0x20, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x49, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x20,
	0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2c, 0x20, 0x61, 0x6e,
	0x64, 0x2c, 0x20, 0x69, 0x6e, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x20, 0x61, 0x0a, 0x66, 0x61, 0x63, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x61,
	0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x64, 0x61, 0x74,
	0x61, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64,
	0x20, 0x62, 0x79, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x0a, 0x74, 0x68, 0x61, 0x74, 0x20, 0x75, 0x73, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x28, 0x6f, 0x74, 0x68, 0x65, 0x72,
	0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x67, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x20, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x20, 0x77, 0x68, 0x65, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x0a, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x69, 0x73,
	0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x29, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x20,
	0x79, 0x6f, 0x75, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x20, 0x61,
	0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x0a, 0x0a,
	0x20, 0x20, 0x20, 0x61, 0x29, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x6d, 0x61, 0x6b, 0x65,
	0x20, 0x61, 0x20, 0x67, 0x6f, 0x6f, 0x64, 0x20, 0x66, 0x61, 0x69, 0x74, 0x68, 0x20, 0x65, 0x66,
	0x66, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x65, 0x6e, 0x73, 0x75, 0x72,
	0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x75, 0x70,
	0x70, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x64, 0x61, 0x74, 0x61, 0x2c, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x20,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x73, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76,
	0x65, 0x72, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x74, 0x73, 0x20, 0x70,
	0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x20, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x6d,
	0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x66, 0x75, 0x6c, 0x2c, 0x20, 0x6f, 0x72, 0x0a, 0x0a, 0x20,
	0x20, 0x20, 0x62, 0x29, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47,
	0x4e, 0x55, 0x20, 0x47, 0x50, 0x4c, 0x2c, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x6e, 0x6f, 0x6e,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20,
	0x6f, 0x66, 0x0a, 0x20, 0x20, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x33,
	0x2e, 0x20, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x43, 0x6f, 0x64, 0x65, 0x20, 0x49, 0x6e,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x61, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x20, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x0a,
	0x0a, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x63, 0x6f,
	0x64, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x69, 0x6e,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x20, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x0a, 0x61, 0x20, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x61,
	0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x2e, 0x20, 0x20, 0x59, 0x6f, 0x75, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x79, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x0a, 0x63,
	0x6f, 0x64, 0x65, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20,
	0x6f, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2c, 0x20,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2c, 0x20, 0x69,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x0a, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x20, 0x69, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x6e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x2c, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x0a, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x73, 0x6d, 0x61,
	0x6c, 0x6c, 0x20, 0x6d, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x2c, 0x20, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x0a, 0x28, 0x74, 0x65, 0x6e, 0x20, 0x6f,
	0x72, 0x20, 0x66, 0x65, 0x77, 0x65, 0x72, 0x20, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x20, 0x69, 0x6e,
	0x20, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x29, 0x2c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x64, 0x6f,
	0x20, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c,
	0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x61, 0x29, 0x20, 0x47,
	0x69, 0x76, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x6f,
	0x74, 0x69, 0x63, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x65, 0x61, 0x63, 0x68, 0x20, 0x63,
	0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x0a,
	0x20, 0x20, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73,
	0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x69, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x69, 0x74, 0x73, 0x20, 0x75, 0x73, 0x65, 0x20, 0x61, 0x72, 0x65, 0x0a, 0x20, 0x20,
	0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x62, 0x29,
	0x20, 0x41, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x61, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e,
	0x55, 0x20, 0x47, 0x50, 0x4c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x34, 0x2e, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x59, 0x6f, 0x75,
	0x20, 0x6d, 0x61, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x20, 0x61, 0x20, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x75, 0x6e, 0x64, 0x65,
	0x72, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20,
	0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2c, 0x0a, 0x74, 0x61, 0x6b,
	0x65, 0x6e, 0x20, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x2c, 0x20, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x20, 0x64, 0x6f, 0x20, 0x6e, 0x6f, 0x74, 0x20,
	0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x69,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57,
	0x6f, 0x72, 0x6b, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x0a,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x20, 0x69, 0x66,
	0x20, 0x79, 0x6f, 0x75, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x64, 0x6f, 0x20, 0x65, 0x61, 0x63,
	0x68, 0x20, 0x6f, 0x66, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69,
	0x6e, 0x67, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x61, 0x29, 0x20, 0x47, 0x69, 0x76, 0x65, 0x20,
	0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x65, 0x61, 0x63, 0x68, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20,
	0x57, 0x6f, 0x72, 0x6b, 0x20, 0x74, 0x68, 0x61, 0x74, 0x0a, 0x20, 0x20, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64,
	0x20, 0x69, 0x6e, 0x20, 0x69, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x69, 0x74, 0x73, 0x20, 0x75, 0x73, 0x65, 0x20, 0x61, 0x72, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x62, 0x29, 0x20, 0x41,
	0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x61, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e,
	0x55, 0x20, 0x47, 0x50, 0x4c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x63, 0x29, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x61,
	0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x20, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x20, 0x63, 0x6f, 0x70,
	0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x20, 0x64,
	0x75, 0x72, 0x69, 0x6e, 0x67, 0x0a, 0x20, 0x20, 0x20, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x20, 0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x0a, 0x20, 0x20, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x20,
	0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x2c, 0x20, 0x61, 0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c,
	0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x20,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73,
	0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x63, 0x6f, 0x70,
	0x69, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x47,
	0x50, 0x4c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x0a, 0x0a, 0x20,
	0x20, 0x20, 0x64, 0x29, 0x20, 0x44, 0x6f, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x3a, 0x0a, 0x0a, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x29, 0x20, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x20, 0x43, 0x6f, 0x72, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x43, 0x6f, 0x64, 0x65, 0x20,
	0x69, 0x6e, 0x20, 0x61, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x73, 0x75, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x2c, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x20, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x75, 0x73, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x72, 0x65, 0x6c, 0x69,
	0x6e, 0x6b, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x0a, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x20,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6b, 0x2c, 0x20, 0x69, 0x6e, 0x20,
	0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6d, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x73,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x36, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x47, 0x4e, 0x55, 0x20, 0x47, 0x50, 0x4c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x79, 0x69, 0x6e, 0x67, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x6f, 0x72,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x29, 0x20, 0x55, 0x73,
	0x65, 0x20, 0x61, 0x20, 0x73, 0x75, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x6d, 0x65, 0x63, 0x68,
	0x61, 0x6e, 0x69, 0x73, 0x6d, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e,
	0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x20, 0x20, 0x41, 0x20, 0x73, 0x75,
	0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d,
	0x20, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x28, 0x61, 0x29,
	0x20, 0x75, 0x73, 0x65, 0x73, 0x20, 0x61, 0x74, 0x20, 0x72, 0x75, 0x6e, 0x20, 0x74, 0x69, 0x6d,
	0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x61,
	0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x6f,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65, 0x72, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x72, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x28, 0x62, 0x29, 0x20, 0x77, 0x69, 0x6c,
	0x6c, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x6c, 0x79, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x0a, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x0a, 0x0a,
	0x20, 0x20, 0x20, 0x65, 0x29, 0x20, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x20, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
	0x20, 0x69, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x77, 0x69, 0x73, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x36, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x47, 0x4e, 0x55,
	0x20, 0x47, 0x50, 0x4c, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74,
	0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x69, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61,
	0x72, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20,
	0x57, 0x6f, 0x72, 0x6b, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x62, 0x79,
	0x20, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x72, 0x20,
	0x72, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20,
	0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x61, 0x20, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x6e, 0x6b,
	0x65, 0x64, 0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x28, 0x49, 0x66, 0x0a,
	0x20, 0x20, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x20, 0x34, 0x64, 0x30, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x0a, 0x20, 0x20, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x61,
	0x6c, 0x20, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x43, 0x6f, 0x64, 0x65, 0x2e, 0x20, 0x49, 0x66,
	0x20, 0x79, 0x6f, 0x75, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x34, 0x64, 0x31, 0x2c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79,
	0x20, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x36, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x47, 0x50, 0x4c, 0x0a, 0x20, 0x20, 0x20, 0x66, 0x6f, 0x72,
	0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x29, 0x0a, 0x0a, 0x20, 0x20, 0x35, 0x2e, 0x20, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64,
	0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x59,
	0x6f, 0x75, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65, 0x20, 0x61, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20,
	0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x20, 0x73, 0x69, 0x64, 0x65, 0x20, 0x62, 0x79, 0x20, 0x73, 0x69, 0x64,
	0x65, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x20, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x77,
	0x69, 0x74, 0x68, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x0a, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x0a, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x20, 0x63, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x75,
	0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x6f,
	0x75, 0x72, 0x0a, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2c, 0x20, 0x69, 0x66, 0x20, 0x79, 0x6f,
	0x75, 0x20, 0x64, 0x6f, 0x20, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x20,
	0x61, 0x29, 0x20, 0x41, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x62,
	0x61, 0x73, 0x65, 0x64, 0x0a, 0x20, 0x20, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2c, 0x20, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2c, 0x0a, 0x20, 0x20, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x79, 0x65,
	0x64, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x65, 0x72, 0x6d,
	0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x62, 0x29, 0x20, 0x47, 0x69, 0x76, 0x65, 0x20, 0x70,
	0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x20, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x70,
	0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x74, 0x0a, 0x20, 0x20, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2c, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x77, 0x68, 0x65, 0x72,
	0x65, 0x20, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x20, 0x20,
	0x20, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x75, 0x6e,
	0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x0a,
	0x0a, 0x20, 0x20, 0x36, 0x2e, 0x20, 0x52, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x20, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e,
	0x55, 0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c,
	0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e,
	0x0a, 0x0a, 0x20, 0x20, 0x54, 0x68, 0x65, 0x20, 0x46, 0x72, 0x65, 0x65, 0x20, 0x53, 0x6f, 0x66,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x6d, 0x61, 0x79, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x2f, 0x6f, 0x72, 0x20, 0x6e, 0x65, 0x77, 0x20,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x0a, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x20, 0x53, 0x75, 0x63, 0x68, 0x20, 0x6e, 0x65, 0x77, 0x0a, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x62, 0x65, 0x20, 0x73,
	0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x73, 0x70, 0x69, 0x72, 0x69, 0x74,
	0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x20,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x6d, 0x61, 0x79,
	0x0a, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x6e, 0x65, 0x77,
	0x20, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x6e,
	0x63, 0x65, 0x72, 0x6e, 0x73, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x45, 0x61, 0x63, 0x68, 0x20, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20,
	0x61, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67,
	0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x2e,
	0x20, 0x49, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20,
	0x61, 0x73, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x20,
	0x69, 0x74, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x61, 0x20, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x0a, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x20, 0x22, 0x6f, 0x72, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6c, 0x61,
	0x74, 0x65, 0x72, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x0a, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x74, 0x2c, 0x20, 0x79, 0x6f, 0x75, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x6f, 0x66, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x61, 0x74, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x79,
	0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x0a, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x46, 0x72, 0x65, 0x65, 0x20, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20, 0x46, 0x6f,
	0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x49, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x61, 0x73, 0x20, 0x79, 0x6f, 0x75, 0x0a,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x20, 0x69, 0x74, 0x20, 0x64, 0x6f, 0x65, 0x73,
	0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x79, 0x20, 0x61, 0x20, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x0a,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x6d, 0x61, 0x79, 0x20,
	0x63, 0x68, 0x6f, 0x6f, 0x73, 0x65, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65,
	0x73, 0x73, 0x65, 0x72, 0x0a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x20, 0x65, 0x76, 0x65, 0x72,
	0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x46, 0x72, 0x65, 0x65, 0x20, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20,
	0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x49,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x61, 0x73,
	0x20, 0x79, 0x6f, 0x75, 0x20, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x20, 0x69, 0x74,
	0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x61, 0x20, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x64, 0x65, 0x63, 0x69,
	0x64, 0x65, 0x0a, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x66, 0x75, 0x74, 0x75, 0x72,
	0x65, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x47, 0x4e, 0x55, 0x20, 0x4c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x6c, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x20, 0x73, 0x68, 0x61, 0x6c, 0x6c, 0x0a, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x2c,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x27, 0x73, 0x20, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f,
	0x66, 0x20, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x20,
	0x61, 0x6e, 0x79, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x0a, 0x70,
	0x65, 0x72, 0x6d, 0x61, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x74,
	0x6f, 0x20, 0x63, 0x68, 0x6f, 0x6f, 0x73, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x0a, 0x0a };

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_checksum_calculate_adler32 function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_checksum_calculate_adler32(
     void )
{
	libcerror_error_t *error = NULL;
	uint32_t checksum        = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libewf_checksum_calculate_adler32(
	          &checksum,
	          ewf_test_checksum_uncompressed_byte_stream,
	          7640,
	          1,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_EQUAL_UINT32(
	 "checksum",
	 checksum,
	 (uint32_t) 0x304a56a4UL );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_checksum_calculate_adler32(
	          NULL,
	          ewf_test_checksum_uncompressed_byte_stream,
	          7640,
	          1,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_checksum_calculate_adler32(
	          &checksum,
	          NULL,
	          7640,
	          1,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_checksum_calculate_adler32(
	          &checksum,
	          ewf_test_checksum_uncompressed_byte_stream,
	          (size_t) SSIZE_MAX + 1,
	          1,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#endif
{
	EWF_TEST_UNREFERENCED_PARAMETER( argc )
	EWF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( HAVE_DEBUG_OUTPUT ) && defined( EWF_TEST_DEFLATE )
	libcnotify_verbose_set(
	 1 );
	libcnotify_stream_set(
	 stderr,
	 NULL );
#endif

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	EWF_TEST_RUN(
	 "libewf_checksum_calculate_adler32",
	 ewf_test_checksum_calculate_adler32 );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

on_error:
	return( EXIT_FAILURE );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */
}

