#! /usr/bin/env python
#
# Python script to open and close Windows EventLog (EVT) file(s) using pyevt
# and a file object
#
# Author:            Joachim Metz
# Creation date:     October 25, 2012
# Modification date: January 13, 2013
#

__author__    = "Joachim Metz"
__version__   = "20130113"
__date__      = "Jan 13, 2013"
__copyright__ = "Copyright (c) 2011-2013, Joachim Metz <joachim.metz@gmail.com>"
__license__   = "GNU LGPL version 3"

import sys
import pyevt

# ----------------------------------------------------------------------------
# Main
# ----------------------------------------------------------------------------

print "open_close_file_object.py " + __version__ + " (libevt " + pyevt.get_version() + ")\n"

argc = len( sys.argv )

if argc < 2:
	print "Usage: open_close_file_object.py filename\n"

	sys.exit( 1 )

evt_file = pyevt.file();

if evt_file == None:
	print "Missing EVT file object\n"

	sys.exit( 1 )

try:
	file_object = file( 
	               sys.argv[ 1 ] )

	evt_file.open_file_object(
	 file_object )

except:
	print "Unable to open file\n"
	print sys.exc_info()[ 1 ]

	sys.exit( 1 )

try:
	evt_file.close()
	file_object.close()
except:
	print "Unable to close file\n"
	print sys.exc_info()
 
	sys.exit( 1 )

sys.exit( 0 )

