//
// Copyright (C) 2011-15 DyND Developers
// BSD 2-Clause License, see LICENSE.txt
//

#include <dynd/string.hpp>
#include <dynd/kernels/string_concat_kernel.hpp>
#include <dynd/kernels/string_count_kernel.hpp>
#include <dynd/kernels/string_find_kernel.hpp>
#include <dynd/kernels/string_replace_kernel.hpp>
#include <dynd/func/elwise.hpp>

using namespace std;
using namespace dynd;


////////////////////////////////////////////////////////////
// String kernels

namespace dynd {
  namespace nd {

    DYND_API callable string_concatenation::make()
    {
      return functional::elwise(callable::make<string_concatenation_kernel>());
    }

    DYND_API struct string_concatenation string_concatenation;

    DYND_API callable string_count::make()
    {
      return functional::elwise(callable::make<string_count_kernel>());
    }

    DYND_API struct string_count string_count;

    DYND_API callable string_find::make()
    {
      return functional::elwise(callable::make<string_find_kernel>());
    }

    DYND_API struct string_find string_find;

    DYND_API callable string_replace::make()
    {
      return functional::elwise(callable::make<string_replace_kernel>());
    }

    DYND_API struct string_replace string_replace;

  } // namespace nd
} // namespace dynd
