/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef DS_MUTEX_H
#define DS_MUTEX_H

#include <DSCore.h>
#ifdef _WIN32_
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#else
#include <pthread.h>
#endif
/*!
 * @header DSMutex
 * @discussion This header implements simple cross-platform locking functionality.
 */

/*!
 * @class DSMutex
 * @discussion This class provides for locking.
 */
class EXPSYM DSMutex
{
	private:
#ifndef _WIN32_
		pthread_mutex_t mutex;
#else
		HANDLE mutex;
#endif

	public:
		/*!
			@function DSMutex
			@discussion Create a Mutex.
		*/
		DSMutex();
		/*!
			@function ~TSMutex
			@discussion Destroy a Mutex.
		*/
		~DSMutex();

		/*!
		 * @function lock
		 * @discussion Lock the mutex.  lock() will not return until it successfully obtains a lock, however long that takes.  That means, once you've acquired a lock, remember to unlock it, otherwise everybody else will wait forever (deadlock) and we don't want that, do we?
		 */
		void         lock();
		/*!
		 * @function unlock
		 * @discussion Release a previously acquired lock.  Do not unlock a lock you haven't locked, it hurts.  Remember to do this to ensure that everybody else gets a turn.  As soon as you unlock it, anybody waiting on a lock is allowed to proceed.
		 */
		void         unlock();
};

#endif

