/*
 * Copyright (c) 2000-2006 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/*
 * @OSF_COPYRIGHT@
 */

#ifndef _PPC_MISC_PROTOS_H_
#define _PPC_MISC_PROTOS_H_

#include <debug.h>
#include <mach_kdb.h>
#include <mach_kgdb.h>
#include <mach_kdp.h>
#include <mach_debug.h>

#include <ppc/boot.h>
#include <kern/thread.h>
#include <mach/vm_types.h>
#include <kern/cpu_data.h>
#include <ppc/savearea.h>
#include <mach/ppc/thread_status.h>
#include <stdarg.h>
#include <string.h>

/* uncached-safe */
extern void		bzero_nc(
					char				*buf, 
					int					size);

/* uncached-safe */
void bcopy_nc(const char *, char *, int);

/* Physical to physical copy (ints must be disabled) */
extern void		bcopy_phys(
					addr64_t			from,
					addr64_t			to,
					int					size);

/* Physical to physical copy virtually (ints must be disabled) */
extern void		bcopy_physvir_32(
					addr64_t			from,
					addr64_t			to,
					int					size);

extern void		phys_copy(
					addr64_t			from,
					addr64_t			to,
					vm_size_t			size); 

extern void		machine_conf(
					void);

extern void		machine_startup(void);

extern void		ppc_vm_init(
					uint64_t			ppc_mem_size,
					boot_args			*args);

extern int		ppcNull(
					struct savearea		*asavearea);

extern int		ppcNullinst(
					struct savearea		*asavearea);

extern void		disable_bluebox_internal(
					thread_t		act);

extern uint64_t	hid0get64(
					void);

extern void		hid5set64(
					uint64_t);

extern void		Load_context(
					thread_t			th);

thread_t Switch_context(thread_t, thread_continue_t, thread_t);

extern void		vec_save(
					struct facility_context *vec_fc);

extern void		toss_live_fpu(
					struct facility_context *fpu_fc);

extern void		toss_live_vec(
					struct facility_context *vec_fc);

extern struct savearea *enterDebugger(unsigned int, struct savearea *,
		unsigned int);

extern void		draw_panic_dialog(
					void);

extern void		commit_paniclog(
					void);
#if	DEBUG
#define DPRINTF(x) { printf("%s : ",__FUNCTION__);printf x; }
#endif	/* DEBUG */

#if MACH_ASSERT
extern void		dump_thread(
					thread_t			th);
#endif /* MACH_ASSERT */

/* XXX move to osfmk/ppc/debug.h or some other debug header */
void print_backtrace(struct savearea *);
int Call_Debugger(int, struct savearea *);
int kdp_dump_trap(int, struct savearea *);
void SysChoked(unsigned int, struct savearea *);
int Call_DebuggerC(unsigned int, struct savearea *);
void kdp_trap(unsigned int, struct savearea *);

#endif /* _PPC_MISC_PROTOS_H_ */
