/*
 * Copyright (c) 2000-2007 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */

#define kProgressBarHeight   (18)
#define kProgressBarCapWidth (9)
#define kProgressBarWidth    (300 + 2 * kProgressBarCapWidth)

static const unsigned char 
progressmeter_leftcap[2][kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd4, 0xb4, 0xa5, 
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x99, 0x99, 0x99, 0x99, 
    0xff, 0xff, 0xff, 0xc4, 0x99, 0x99, 0xc3, 0xe2, 0xef, 
    0xff, 0xff, 0xc4, 0x99, 0x99, 0xd4, 0xfe, 0xfe, 0xfe, 
    0xff, 0xd9, 0x99, 0x99, 0xe7, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xff, 0xaf, 0x99, 0xd9, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xe8, 0x99, 0xaf, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xcf, 0x99, 0xc7, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xc4, 0x99, 0xd1, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xc4, 0x99, 0xd1, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xcf, 0x99, 0xc8, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xe8, 0x99, 0xaf, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xff, 0xaf, 0x99, 0xd9, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xff, 0xd8, 0x99, 0x99, 0xe8, 0xfe, 0xfe, 0xfe, 0xfe, 
    0xff, 0xff, 0xc4, 0x99, 0x99, 0xd4, 0xfe, 0xfe, 0xfe, 
    0xff, 0xff, 0xff, 0xc4, 0x99, 0x99, 0xc3, 0xe2, 0xef, 
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x99, 0x99, 0x99, 0x99, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd4, 0xb4, 0xa5, 
},
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd3, 0xb4, 0xa4, 
    0xff, 0xff, 0xff, 0xff, 0xd4, 0x99, 0x9a, 0x99, 0x99, 
    0xff, 0xff, 0xff, 0xc4, 0x99, 0x98, 0x99, 0x99, 0x99, 
    0xff, 0xff, 0xc4, 0x99, 0x9a, 0x99, 0x9a, 0x99, 0x99, 
    0xff, 0xd9, 0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 
    0xff, 0xb0, 0x98, 0x98, 0x99, 0x98, 0x99, 0x99, 0x99, 
    0xe8, 0x99, 0x9a, 0x99, 0x99, 0x98, 0x98, 0x99, 0x99, 
    0xcf, 0x99, 0x99, 0x98, 0x99, 0x9a, 0x98, 0x98, 0x98, 
    0xc5, 0x99, 0x99, 0x9a, 0x99, 0x99, 0x9a, 0x98, 0x99, 
    0xc4, 0x99, 0x99, 0x99, 0x9a, 0x98, 0x99, 0x99, 0x99, 
    0xcf, 0x98, 0x99, 0x99, 0x98, 0x98, 0x98, 0x98, 0x99, 
    0xe8, 0x9a, 0x99, 0x99, 0x9a, 0x98, 0x99, 0x99, 0x99, 
    0xff, 0xb0, 0x9a, 0x99, 0x99, 0x98, 0x99, 0x9a, 0x99, 
    0xff, 0xd8, 0x99, 0x99, 0x99, 0x9a, 0x98, 0x98, 0x99, 
    0xff, 0xff, 0xc4, 0x98, 0x99, 0x98, 0x9a, 0x99, 0x9a, 
    0xff, 0xff, 0xff, 0xc5, 0x99, 0x9a, 0x9a, 0x99, 0x98, 
    0xff, 0xff, 0xff, 0xff, 0xd3, 0x98, 0x99, 0x98, 0x9a, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd4, 0xb4, 0xa5, 
}
};


static const unsigned char 
progressmeter_middle[2][1 * kProgressBarHeight] = {
{
    0x99, 
    0x99, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0xfe, 
    0x99, 
    0x99, 
},
{
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
    0x99, 
}};

static const unsigned char 
progressmeter_rightcap[2][kProgressBarCapWidth * kProgressBarHeight] = {
{
    0xa8, 0xb7, 0xd5, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x99, 0x99, 0x99, 0x99, 0xd8, 0xff, 0xff, 0xff, 0xff, 
    0xef, 0xe0, 0xc0, 0x99, 0x99, 0xc5, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xfe, 0xd1, 0x99, 0x99, 0xc5, 0xff, 0xff, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xe2, 0x99, 0x99, 0xdf, 0xff, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xd4, 0x99, 0xb7, 0xff, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xa8, 0x99, 0xee, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xc0, 0x99, 0xd5, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xcc, 0x99, 0xcb, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xcc, 0x99, 0xcb, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xc1, 0x99, 0xd5, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xa8, 0x99, 0xee, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xd4, 0x99, 0xb7, 0xff, 
    0xfe, 0xfe, 0xfe, 0xfe, 0xe3, 0x99, 0x99, 0xdf, 0xff, 
    0xfe, 0xfe, 0xfe, 0xd1, 0x99, 0x99, 0xc5, 0xff, 0xff, 
    0xef, 0xe0, 0xc0, 0x99, 0x99, 0xc5, 0xff, 0xff, 0xff, 
    0x99, 0x99, 0x99, 0x99, 0xd8, 0xff, 0xff, 0xff, 0xff, 
    0xa8, 0xb7, 0xd5, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
},
{
    0xa8, 0xb7, 0xd7, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x99, 0x99, 0x99, 0x99, 0xd7, 0xff, 0xff, 0xff, 0xff, 
    0x98, 0x98, 0x98, 0x98, 0x98, 0xc5, 0xff, 0xff, 0xff, 
    0x99, 0x99, 0x98, 0x9a, 0x98, 0x9a, 0xc5, 0xff, 0xff, 
    0x99, 0x9a, 0x99, 0x99, 0x9a, 0x98, 0x9a, 0xdf, 0xff, 
    0x99, 0x99, 0x98, 0x99, 0x98, 0x99, 0x99, 0xb7, 0xff, 
    0x9a, 0x98, 0x99, 0x98, 0x99, 0x99, 0x99, 0x9a, 0xee, 
    0x9a, 0x99, 0x9a, 0x98, 0x9a, 0x99, 0x9a, 0x9a, 0xd5, 
    0x98, 0x99, 0x99, 0x98, 0x9a, 0x99, 0x9a, 0x99, 0xcb, 
    0x98, 0x99, 0x9a, 0x98, 0x98, 0x99, 0x99, 0x99, 0xc9, 
    0x99, 0x99, 0x98, 0x99, 0x9a, 0x99, 0x99, 0x99, 0xd5, 
    0x99, 0x99, 0x99, 0x99, 0x98, 0x99, 0x99, 0x9a, 0xee, 
    0x9a, 0x98, 0x98, 0x99, 0x99, 0x99, 0x99, 0xb7, 0xff, 
    0x99, 0x9a, 0x9a, 0x98, 0x99, 0x99, 0x9a, 0xdf, 0xff, 
    0x99, 0x99, 0x9a, 0x98, 0x99, 0x99, 0xc7, 0xff, 0xff, 
    0x98, 0x99, 0x99, 0x98, 0x9a, 0xc5, 0xff, 0xff, 0xff, 
    0x99, 0x99, 0x99, 0x9a, 0xd8, 0xff, 0xff, 0xff, 0xff, 
    0xa8, 0xb7, 0xd7, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
}};

