/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2006  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>
#include <stdexcept>

#include "Common.h"
#include "LineBuffer.h"

int main(int argc, char ** argv)
{
	StartTest("getting the root item via path");
	{
		Arxx::Archive Archive;
		Arxx::Item Item(Archive);
		
		Archive.vSetRootItem(&Item);
		
		Arxx::Item * RootItem(Archive.GetItem("/"));
		
		EqualTest(RootItem, &Item);
	}
	EndTest();
	
	StartTest("getting \"/this\" item via path");
	{
		Arxx::Archive Archive;
		Arxx::Item Item1(Archive);
		Arxx::Item Item2(Archive);
		
		Item2.vSetName("this");
		Item1.GetStructure().bAdd(Item2.u4GetUniqueID(), "child");
		Archive.vSetRootItem(&Item1);
		
		Arxx::Item * Item(Archive.GetItem("/this"));
		
		EqualTest(Item, &Item2);
	}
	EndTest();
	
	StartTest("getting \"/this/that\" item via path");
	{
		Arxx::Archive Archive;
		Arxx::Item Item1(Archive);
		Arxx::Item Item2(Archive);
		Arxx::Item Item3(Archive);
		
		Item2.vSetName("this");
		Item3.vSetName("that");
		Item1.GetStructure().bAdd(Item2.u4GetUniqueID(), "child");
		Item2.GetStructure().bAdd(Item3.u4GetUniqueID(), "child");
		Archive.vSetRootItem(&Item1);
		
		Arxx::Item * Item(Archive.GetItem("/this/that"));
		
		EqualTest(Item, &Item3);
	}
	EndTest();
	
	StartTest("getting \"/sub::this\" item via path");
	{
		Arxx::Archive Archive;
		Arxx::Item Item1(Archive);
		Arxx::Item Item2(Archive);
		
		Item2.vSetName("this");
		Item1.GetStructure().bAdd(Item2.u4GetUniqueID(), "sub");
		Archive.vSetRootItem(&Item1);
		
		Arxx::Item * Item(Archive.GetItem("/sub::this"));
		
		EqualTest(Item, &Item2);
	}
	EndTest();
	
	StartTest("getting \"/this/sub::that\" item via path");
	{
		Arxx::Archive Archive;
		Arxx::Item Item1(Archive);
		Arxx::Item Item2(Archive);
		Arxx::Item Item3(Archive);
		
		Item2.vSetName("this");
		Item3.vSetName("that");
		Item1.GetStructure().bAdd(Item2.u4GetUniqueID(), "child");
		Item2.GetStructure().bAdd(Item3.u4GetUniqueID(), "sub");
		Archive.vSetRootItem(&Item1);
		
		Arxx::Item * Item(Archive.GetItem("/this/sub::that"));
		
		EqualTest(Item, &Item3);
	}
	EndTest();
	
	return iEndTests();
}
