/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "../Include/Item.h"

/**
 * @file Test3.cxx
 * 
 * Compiler tests. Compilation is success.
 * 
 * This test case uses the structure iterators and Relation iterators to check whether they have correctly declared comparison operators in terms of constness.
 **/

int main(int argc, char ** argv)
{
	Arxx::Item Item;
	Arxx::Structure & Structure(Item.GetStructure());
	
	Structure.bAdd(1, "1");
	Structure.bAdd(1, "2");
	Structure.bAdd(2, "3");
	Structure.bAdd(2, "2");
	
	Arxx::Structure::iterator iBegin1(Structure.begin());
	Arxx::Structure::iterator iBegin2(Structure.begin());
	
	if(iBegin1 == iBegin2)
	{
		// the Arxx::Structure::iterator::operator==(iterator) is defined
	}
	if(iBegin1 != iBegin2)
	{
		// the Arxx::Structure::iterator::operator!=(iterator) is defined
	}
	{
		const Arxx::Structure & c_Structure(Structure);
		Arxx::Structure::const_iterator c_iBegin1(c_Structure.begin());
		Arxx::Structure::const_iterator c_iBegin2(iBegin2);
		
		if(c_iBegin1 == c_iBegin2)
		{
			// the Arxx::Structure::const_iterator::operator==(const_iterator) is defined
		}
		if(c_iBegin1 != c_iBegin2)
		{
			// the Arxx::Structure::const_iterator::operator!=(const_iterator) is defined
		}
		if(c_iBegin1 == iBegin1)
		{
			// the Arxx::Structure::const_iterator::operator==(iterator) is defined
		}
		if(c_iBegin1 != iBegin1)
		{
			// the Arxx::Structure::const_iterator::operator!=(iterator) is defined
		}
		if(iBegin1 == c_iBegin1)
		{
			// the Arxx::Structure::iterator::operator==(const_iterator) is defined
		}
		if(iBegin1 != c_iBegin1)
		{
			// the Arxx::Structure::iterator::operator!=(const_iterator) is defined
		}
	}
	
	Arxx::Structure::Relation::iterator iReference1(iBegin1->begin());
	Arxx::Structure::Relation::iterator iReference2(iBegin2->begin());
	
	if(iReference1 == iReference2)
	{
		// the Arxx::Structure::Relation::iterator::operator==(iterator) is defined
	}
	if(iReference1 != iReference2)
	{
		// the Arxx::Structure::Relation::iterator::operator!=(iterator) is defined
	}
	{
		Arxx::Structure::Relation::const_iterator c_iReference1(iReference1);
		Arxx::Structure::Relation::const_iterator c_iReference2(iBegin2->begin());
		
		if(c_iReference1 == c_iReference2)
		{
			// the Arxx::Structure::Relation::const_iterator::operator==(const_iterator) is defined
		}
		if(c_iReference1 != c_iReference2)
		{
			// the Arxx::Structure::Relation::const_iterator::operator!=(const_iterator) is defined
		}
		if(c_iReference1 == iReference1)
		{
			// the Arxx::Structure::Relation::const_iterator::operator==(iterator) is defined
		}
		if(c_iReference1 != iReference1)
		{
			// the Arxx::Structure::Relation::const_iterator::operator!=(iterator) is defined
		}
		if(iReference1 == c_iReference1)
		{
			// the Arxx::Structure::Relation::iterator::operator==(const_iterator) is defined
		}
		if(iReference1 != c_iReference1)
		{
			// the Arxx::Structure::Relation::iterator::operator!=(const_iterator) is defined
		}
	}
	
	return 0;
}
